/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server;

import ch.systemsx.cisd.authentication.ISessionManager;
import ch.systemsx.cisd.openbis.common.spring.IInvocationLoggerContext;
import ch.systemsx.cisd.openbis.generic.server.ICommonServerForInternalUse;
import ch.systemsx.cisd.openbis.generic.shared.AbstractServerLogger;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.MetaprojectAssignmentsIds;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.id.metaproject.IMetaprojectId;
import ch.systemsx.cisd.openbis.generic.shared.basic.IEntityInformationHolderWithPermId;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Attachment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AuthorizationGroup;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AuthorizationGroupUpdates;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.BasicEntityDescription;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.BatchOperationKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.CorePlugin;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.CustomImportFile;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetRelatedEntities;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetRelationshipRole;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetUpdateResult;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataStore;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataStoreServiceKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatastoreServiceDescription;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Deletion;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DeletionType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DetailedSearchCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DynamicPropertyEvaluationInfo;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityHistory;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityTypePropertyType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityValidationEvaluationInfo;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ExperimentType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ExperimentUpdateResult;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ExternalDataManagementSystem;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.FileFormatType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Grantee;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.GridCustomFilter;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IExpressionUpdates;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IMetaprojectRegistration;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IMetaprojectUpdates;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IPropertyTypeUpdates;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IScriptUpdates;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ISpaceUpdates;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IVocabularyTermUpdates;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IVocabularyUpdates;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.LastModificationState;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.LinkModel;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ListMaterialCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ListSampleCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MatchingEntity;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Material;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MaterialIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MaterialType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Metaproject;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MetaprojectAssignments;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MetaprojectAssignmentsCount;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MetaprojectAssignmentsFetchOption;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MetaprojectNullRegistration;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MetaprojectNullUpdates;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewAttachment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewAuthorizationGroup;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewColumnOrFilter;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewETNewPTAssigments;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewETPTAssignment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewPTNewAssigment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewSample;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewVocabulary;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Person;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Project;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PropertyType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PropertyUpdates;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.RoleAssignment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.RoleWithHierarchy;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleParentWithDerived;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleUpdateResult;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Script;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ScriptType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Space;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModel;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Vocabulary;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.VocabularyTerm;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.VocabularyTermReplacement;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.api.IManagedInputWidgetDescription;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.api.IManagedProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.api.IManagedUiAction;
import ch.systemsx.cisd.openbis.generic.shared.coreplugin.ICorePluginResourceLoader;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataSetUpdatesDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataSetUploadContext;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentUpdatesDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.ListSampleCriteriaDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.ProjectUpdatesDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.PropertyTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SampleParentWithDerivedDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePropertyPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SampleUpdatesDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.SearchableEntity;
import ch.systemsx.cisd.openbis.generic.shared.dto.Session;
import ch.systemsx.cisd.openbis.generic.shared.dto.SessionContextDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.VocabularyTermWithStats;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.DatabaseInstanceIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ProjectIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SpaceIdentifier;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Level;

final class CommonServerLogger
extends AbstractServerLogger
implements ICommonServerForInternalUse {
    CommonServerLogger(ISessionManager<Session> sessionManager, IInvocationLoggerContext context) {
        super(sessionManager, context);
    }

    @Override
    public SessionContextDTO tryToAuthenticateAsSystem() {
        return null;
    }

    @Override
    public List<Space> listSpaces(String sessionToken, DatabaseInstanceIdentifier identifier) {
        if (identifier == null || identifier.getDatabaseInstanceCode() == null) {
            this.logAccess(sessionToken, "list_spaces");
        } else {
            this.logAccess(sessionToken, "list_spaces", "DATABASE-INSTANCE(%s)", identifier);
        }
        return null;
    }

    @Override
    public void registerSpace(String sessionToken, String groupCode, String descriptionOrNull) {
        this.logTracking(sessionToken, "register_space", "CODE(%s)", groupCode);
    }

    @Override
    public void updateScript(String sessionToken, IScriptUpdates updates) {
        this.logTracking(sessionToken, "update_script", "SCRIPT(%s)", updates.getId());
    }

    @Override
    public void updateSpace(String sessionToken, ISpaceUpdates updates) {
        this.logTracking(sessionToken, "update_space", "SPACE(%s)", updates);
    }

    @Override
    public List<Person> listPersons(String sessionToken) {
        this.logAccess(sessionToken, "list_persons");
        return null;
    }

    @Override
    public List<Person> listActivePersons(String sessionToken) {
        this.logAccess(sessionToken, "list_active_persons");
        return null;
    }

    @Override
    public void registerPerson(String sessionToken, String userID) {
        this.logTracking(sessionToken, "register_person", "CODE(%s)", userID);
    }

    @Override
    public List<RoleAssignment> listRoleAssignments(String sessionToken) {
        this.logAccess(sessionToken, "list_roles");
        return null;
    }

    @Override
    public void registerSpaceRole(String sessionToken, RoleWithHierarchy.RoleCode roleCode, SpaceIdentifier spaceIdentifier, Grantee grantee) {
        this.logTracking(sessionToken, "register_role", "ROLE(%s) SPACE(%s) GRANTEE(%s)", roleCode, spaceIdentifier, grantee);
    }

    @Override
    public void registerInstanceRole(String sessionToken, RoleWithHierarchy.RoleCode roleCode, Grantee grantee) {
        this.logTracking(sessionToken, "register_role", "ROLE(%s)  GRANTEE(%s)", roleCode, grantee);
    }

    @Override
    public void deleteSpaceRole(String sessionToken, RoleWithHierarchy.RoleCode roleCode, SpaceIdentifier spaceIdentifier, Grantee grantee) {
        this.logTracking(sessionToken, "delete_role", "ROLE(%s) SPACE(%s) GRANTEE(%s)", roleCode, spaceIdentifier, grantee);
    }

    @Override
    public void deleteInstanceRole(String sessionToken, RoleWithHierarchy.RoleCode roleCode, Grantee grantee) {
        this.logTracking(sessionToken, "delete_role", "ROLE(%s) GRANTEE(%s)", roleCode, grantee);
    }

    @Override
    public final List<SampleType> listSampleTypes(String sessionToken) {
        this.logAccess(sessionToken, "list_sample_types");
        return null;
    }

    @Override
    public Map<String, List<IManagedInputWidgetDescription>> listManagedInputWidgetDescriptions(String sessionToken, EntityKind entityKind, String entityTypeCode) {
        this.logAccess(sessionToken, "list_managed_input_widget_descriptions", "TYPE(%s)", entityTypeCode);
        return null;
    }

    @Override
    public List<Sample> listSamples(String sessionToken, ListSampleCriteria criteria) {
        if (criteria.isIncludeSpace()) {
            this.logAccess(sessionToken, "list_samples", "TYPE(%s) OWNERS(space=%s) CONTAINER(%s) PARENT(%s) CHILD(%s) EXPERIMENT(%s)", criteria.getSampleType(), criteria.getSpaceCode(), criteria.getContainerSampleIds(), criteria.getParentSampleId(), criteria.getChildSampleId(), criteria.getExperimentId());
        } else if (criteria.isIncludeInstance()) {
            this.logAccess(sessionToken, "list_samples", "TYPE(%s) OWNERS(instance=%s) CONTAINER(%s) PARENT(%s) CHILD(%s) EXPERIMENT(%s)", criteria.getSampleType(), criteria.getSampleType().getDatabaseInstance(), criteria.getContainerSampleIds(), criteria.getParentSampleId(), criteria.getChildSampleId(), criteria.getExperimentId());
        } else {
            this.logAccess(sessionToken, "list_samples", "TYPE(%s) CONTAINER(%s) PARENT(%s) CHILD(%s) EXPERIMENT(%s)", criteria.getSampleType(), criteria.getContainerSampleIds(), criteria.getParentSampleId(), criteria.getChildSampleId(), criteria.getExperimentId());
        }
        return null;
    }

    @Override
    public List<Sample> listMetaprojectSamples(String sessionToken, IMetaprojectId metaprojectId) {
        this.logAccess(sessionToken, "list_metaproject_samples", "METAPROJECT_ID(%s)", metaprojectId);
        return null;
    }

    @Override
    public List<Sample> listSamplesOnBehalfOfUser(String sessionToken, ListSampleCriteria criteria, String userId) {
        if (criteria.isIncludeSpace()) {
            this.logAccess(sessionToken, "list_samples", "TYPE(%s) OWNERS(space=%s) CONTAINER(%s) PARENT(%s) CHILD(%s) EXPERIMENT(%s)", criteria.getSampleType(), criteria.getSpaceCode(), criteria.getContainerSampleIds(), criteria.getParentSampleId(), criteria.getChildSampleId(), criteria.getExperimentId());
        } else if (criteria.isIncludeInstance()) {
            this.logAccess(sessionToken, "list_samples", "TYPE(%s) OWNERS(instance=%s) CONTAINER(%s) PARENT(%s) CHILD(%s) EXPERIMENT(%s)", criteria.getSampleType(), criteria.getSampleType().getDatabaseInstance(), criteria.getContainerSampleIds(), criteria.getParentSampleId(), criteria.getChildSampleId(), criteria.getExperimentId());
        } else {
            this.logAccess(sessionToken, "list_samples", "TYPE(%s) CONTAINER(%s) PARENT(%s) CHILD(%s) EXPERIMENT(%s)", criteria.getSampleType(), criteria.getContainerSampleIds(), criteria.getParentSampleId(), criteria.getChildSampleId(), criteria.getExperimentId());
        }
        return null;
    }

    public final List<SamplePropertyPE> listSamplesProperties(String sessionToken, ListSampleCriteriaDTO criteria, List<PropertyTypePE> propertyCodes) {
        this.logAccess(sessionToken, "list_samples_properties", "CRITERIA(%s) PROPERTIES(%s)", criteria, this.abbreviate(propertyCodes));
        return null;
    }

    public final SampleParentWithDerivedDTO getSampleInfo(String sessionToken, SampleIdentifier identifier) {
        this.logAccess(sessionToken, "get_sample_info", "IDENTIFIER(%s)", identifier);
        return null;
    }

    @Override
    public final List<AbstractExternalData> listSampleExternalData(String sessionToken, TechId sampleId, boolean showOnlyDirectlyConnected) {
        this.logAccess(sessionToken, "list_sample_external_data", "ID(%s) DIRECT(%s)", sampleId, showOnlyDirectlyConnected);
        return null;
    }

    @Override
    public List<AbstractExternalData> listExperimentExternalData(String sessionToken, TechId experimentId, boolean showOnlyDirectlyConnected) {
        this.logAccess(sessionToken, "list_experiment_external_data", "ID(%s) DIRECT(%s)", experimentId, showOnlyDirectlyConnected);
        return null;
    }

    @Override
    public List<AbstractExternalData> listMetaprojectExternalData(String sessionToken, IMetaprojectId metaprojectId) {
        this.logAccess(sessionToken, "list_metaproject_external_data", "METAPROJECT_ID(%s)", metaprojectId);
        return null;
    }

    @Override
    public List<AbstractExternalData> listDataSetRelationships(String sessionToken, TechId datasetId, DataSetRelationshipRole role) {
        this.logAccess(sessionToken, "list_dataset_relationships", "ID(%s), ROLE(%s)", datasetId, role);
        return null;
    }

    @Override
    public final List<MatchingEntity> listMatchingEntities(String sessionToken, SearchableEntity[] searchableEntities, String queryText, boolean useWildcardSearchMode, int maxSIze) {
        this.logAccess(sessionToken, "list_matching_entities", "SEARCHABLE-ENTITIES(%s) QUERY-TEXT(%s) WILDCARD_MODE(%s) MAX_SIZE(%s)", this.abbreviate((Object[])searchableEntities), queryText, useWildcardSearchMode, maxSIze);
        return null;
    }

    public void registerSample(String sessionToken, NewSample newSample) {
        this.logTracking(sessionToken, "register_sample", "SAMPLE_TYPE(%s) SAMPLE(%S)", newSample.getSampleType(), newSample.getIdentifier());
    }

    @Override
    public List<Experiment> listExperiments(String sessionToken, ExperimentType experimentType, ProjectIdentifier project) {
        this.logAccess(sessionToken, "list_experiments", "TYPE(%s) PROJECT(%s)", experimentType, project);
        return null;
    }

    @Override
    public List<Experiment> listMetaprojectExperiments(String sessionToken, IMetaprojectId metaprojectId) {
        this.logAccess(sessionToken, "list_metaproject_experiments", "METAPROJECT_ID(%s)", metaprojectId);
        return null;
    }

    @Override
    public List<Experiment> listExperimentsHavingSamples(String sessionToken, ExperimentType experimentType, ProjectIdentifier project) {
        this.logAccess(sessionToken, "list_experiments_having_samples", "TYPE(%s) PROJECT(%s)", experimentType, project);
        return null;
    }

    @Override
    public List<Experiment> listExperimentsHavingDataSets(String sessionToken, ExperimentType experimentType, ProjectIdentifier project) {
        this.logAccess(sessionToken, "list_experiments_data_sets", "TYPE(%s) PROJECT(%s)", experimentType, project);
        return null;
    }

    @Override
    public List<Experiment> listExperiments(String sessionToken, ExperimentType experimentType, SpaceIdentifier space) {
        this.logAccess(sessionToken, "list_experiments", "TYPE(%s) SPACE(%s)", experimentType, space);
        return null;
    }

    @Override
    public List<Project> listProjects(String sessionToken) {
        this.logAccess(sessionToken, "list_projects");
        return null;
    }

    @Override
    public List<ExperimentType> listExperimentTypes(String sessionToken) {
        this.logAccess(sessionToken, "list_experiment_types");
        return null;
    }

    @Override
    public List<PropertyType> listPropertyTypes(String sessionToken, boolean withRelations) {
        this.logAccess(sessionToken, "list_property_types", withRelations ? "WITH_RELATIONS" : "", new Object[0]);
        return null;
    }

    @Override
    public List<EntityHistory> listEntityHistory(String sessionToken, EntityKind entityKind, TechId entityID) {
        this.logAccess(sessionToken, "list_entity_history", "ENTITY_KIND(%s) ENTITY_ID(%s)", entityKind, entityID);
        return null;
    }

    @Override
    public final List<DataType> listDataTypes(String sessionToken) {
        this.logAccess(sessionToken, "list_data_types");
        return null;
    }

    @Override
    public final List<Script> listScripts(String sessionToken, ScriptType scriptTypeOrNull, EntityKind entityKindOrNull) {
        this.logAccess(sessionToken, "list_scripts", "SCRIPT_TYPE(%s) ENTITY_KIND(%s)", scriptTypeOrNull, entityKindOrNull);
        return null;
    }

    @Override
    public List<FileFormatType> listFileFormatTypes(String sessionToken) {
        this.logAccess(sessionToken, "list_file_format_types");
        return null;
    }

    @Override
    public final List<Vocabulary> listVocabularies(String sessionToken, boolean withTerms, boolean excludeInternal) {
        this.logAccess(sessionToken, "list_vocabularies");
        return null;
    }

    @Override
    public String assignPropertyType(String sessionToken, NewETPTAssignment assignment) {
        String entityTypeFormat = String.valueOf(assignment.getEntityKind().name()) + "_TYPE(%S)";
        this.logTracking(sessionToken, "assign_property_type", " PROPERTY_TYPE(%S) " + entityTypeFormat + " MANDATORY(%S) DEFAULT(%S) SECTION(%S) PREVIOUS_ORDINAL(%S)", assignment.getPropertyTypeCode(), assignment.getEntityTypeCode(), assignment.isMandatory(), assignment.getDefaultValue(), assignment.getSection(), assignment.getOrdinal());
        return null;
    }

    @Override
    public void updatePropertyTypeAssignment(String sessionToken, NewETPTAssignment assignmentUpdates) {
        String entityTypeFormat = String.valueOf(assignmentUpdates.getEntityKind().name()) + "_TYPE(%S)";
        this.logTracking(sessionToken, "update_property_type_assignment", " PROPERTY_TYPE(%S) " + entityTypeFormat + " MANDATORY(%S) DEFAULT(%S) SECTION(%S) PREVIOUS_ORDINAL(%S)", assignmentUpdates.getPropertyTypeCode(), assignmentUpdates.getEntityTypeCode(), assignmentUpdates.isMandatory(), assignmentUpdates.getDefaultValue(), assignmentUpdates.getSection(), assignmentUpdates.getOrdinal());
    }

    @Override
    public void unassignPropertyType(String sessionToken, EntityKind entityKind, String propertyTypeCode, String entityTypeCode) {
        String entityTypeFormat = String.valueOf(entityKind.name()) + "_TYPE(%S)";
        this.logTracking(sessionToken, "unassign_property_type", " PROPERTY_TYPE(%S) " + entityTypeFormat, propertyTypeCode, entityTypeCode);
    }

    @Override
    public int countPropertyTypedEntities(String sessionToken, EntityKind entityKind, String propertyTypeCode, String entityTypeCode) {
        String entityTypeFormat = String.valueOf(entityKind.name()) + "_TYPE(%S)";
        this.logAccess(sessionToken, "count_property_typed_entities", "PROPERTY_TYPE(%s) " + entityTypeFormat, propertyTypeCode, entityTypeCode);
        return 0;
    }

    @Override
    public final String registerEntitytypeAndAssignPropertyTypes(String sessionToken, NewETNewPTAssigments newETNewPTAssigments) {
        for (NewPTNewAssigment newAssigment : newETNewPTAssigments.getAssigments()) {
            String entityTypeFormat = String.valueOf(newAssigment.getAssignment().getEntityKind().name()) + "_TYPE(%S)";
            this.logTracking(sessionToken, "register_assign_property_type", " PROPERTY_TYPE(%S) " + entityTypeFormat + " MANDATORY(%S) DEFAULT(%S) SECTION(%S) PREVIOUS_ORDINAL(%S)", newAssigment.getAssignment().getPropertyTypeCode(), newAssigment.getAssignment().getEntityTypeCode(), newAssigment.getAssignment().isMandatory(), newAssigment.getAssignment().getDefaultValue(), newAssigment.getAssignment().getSection(), newAssigment.getAssignment().getOrdinal());
        }
        return null;
    }

    @Override
    public final String updateEntitytypeAndPropertyTypes(String sessionToken, NewETNewPTAssigments newETNewPTAssigments) {
        for (NewPTNewAssigment newAssigment : newETNewPTAssigments.getAssigments()) {
            String entityTypeFormat = String.valueOf(newAssigment.getAssignment().getEntityKind().name()) + "_TYPE(%S)";
            this.logTracking(sessionToken, "update_assign_property_type", " PROPERTY_TYPE(%S) " + entityTypeFormat + " MANDATORY(%S) DEFAULT(%S) SECTION(%S) PREVIOUS_ORDINAL(%S)", newAssigment.getAssignment().getPropertyTypeCode(), newAssigment.getAssignment().getEntityTypeCode(), newAssigment.getAssignment().isMandatory(), newAssigment.getAssignment().getDefaultValue(), newAssigment.getAssignment().getSection(), newAssigment.getAssignment().getOrdinal());
        }
        return null;
    }

    @Override
    public final String registerAndAssignPropertyType(String sessionToken, PropertyType propertyType, NewETPTAssignment assignment) {
        String entityTypeFormat = String.valueOf(assignment.getEntityKind().name()) + "_TYPE(%S)";
        this.logTracking(sessionToken, "register_assign_property_type", " PROPERTY_TYPE(%S) " + entityTypeFormat + " MANDATORY(%S) DEFAULT(%S) SECTION(%S) PREVIOUS_ORDINAL(%S)", assignment.getPropertyTypeCode(), assignment.getEntityTypeCode(), assignment.isMandatory(), assignment.getDefaultValue(), assignment.getSection(), assignment.getOrdinal());
        return null;
    }

    @Override
    public final void registerPropertyType(String sessionToken, PropertyType propertyType) {
        this.logTracking(sessionToken, "register_property_type", "PROPERTY_TYPE(%s)", propertyType.getCode());
    }

    @Override
    public void updatePropertyType(String sessionToken, IPropertyTypeUpdates updates) {
        this.logTracking(sessionToken, "update_property_type", "PROPERTY_TYPE(%s)", updates);
    }

    @Override
    public final void registerVocabulary(String sessionToken, NewVocabulary vocabulary) {
        this.logTracking(sessionToken, "register_vocabulary", "VOCABULARY(%s)", vocabulary.getCode());
    }

    @Override
    public void updateVocabulary(String sessionToken, IVocabularyUpdates updates) {
        this.logTracking(sessionToken, "update_vocabulary", "ID(%s) CODE(%s)", updates.getId(), updates.getCode());
    }

    @Override
    public void addVocabularyTerms(String sessionToken, TechId vocabularyId, List<VocabularyTerm> vocabularyTerms, Long previousTermOrdinal, boolean allowChangingInternallyManaged) {
        this.logTracking(sessionToken, "add_vocabulary_terms", "ID(%s) TERMS(%s) PREVIOUS_ORDINAL(%s) ALLOW_CHANGING_INTERNALLY_MANAGED(%s)", vocabularyId, this.abbreviate(vocabularyTerms), Long.toString(previousTermOrdinal), allowChangingInternallyManaged);
    }

    @Override
    public void addUnofficialVocabularyTerm(String sessionToken, TechId vocabularyId, String code, String label, String description, Long previousTermOrdinal) {
        this.logTracking(sessionToken, "add_unofficial_vocabulary_terms", "ID(%s) CODE(%s), LABEL(%s), DESCRIPTION(%s), PREVIOUS_ORDINAL(%s)", vocabularyId, code, label, description, Long.toString(previousTermOrdinal));
    }

    @Override
    public void updateVocabularyTerm(String sessionToken, IVocabularyTermUpdates updates) {
        this.logTracking(sessionToken, "update_vocabulary_term", "VOCABULARY_TERM(%s)", updates);
    }

    @Override
    public void deleteVocabularyTerms(String sessionToken, TechId vocabularyId, List<VocabularyTerm> termsToBeDeleted, List<VocabularyTermReplacement> termsToBeReplaced) {
        this.logTracking(sessionToken, "delete_vocabulary_terms", "VOCABULARY_ID(%s) DELETED(%s) REPLACEMENTS(%s)", vocabularyId, this.abbreviate(termsToBeDeleted), this.abbreviate(termsToBeReplaced));
    }

    @Override
    public void makeVocabularyTermsOfficial(String sessionToken, TechId vocabularyId, List<VocabularyTerm> termsToBeOfficial) {
        this.logTracking(sessionToken, "make_vocabulary_terms_official", "VOCABULARY_ID(%s) OFFICIAL(%s)", vocabularyId, this.abbreviate(termsToBeOfficial));
    }

    @Override
    public void registerProject(String sessionToken, ProjectIdentifier projectIdentifier, String description, String leaderId, Collection<NewAttachment> attachments) {
        this.logTracking(sessionToken, "register_project", "PROJECT(%s) ATTACHMNETS(%s)", projectIdentifier, this.abbreviate(attachments));
    }

    @Override
    public List<Experiment> searchForExperiments(String sessionToken, DetailedSearchCriteria criteria) {
        this.logAccess(sessionToken, "search_for_experiments", "criteria(%s)", criteria);
        return null;
    }

    @Override
    public List<AbstractExternalData> searchForDataSets(String sessionToken, DetailedSearchCriteria criteria) {
        this.logAccess(sessionToken, "search_for_datasets", "criteria(%s)", criteria);
        return null;
    }

    @Override
    public List<AbstractExternalData> searchForDataSetsOnBehalfOfUser(String sessionToken, DetailedSearchCriteria criteria, String userId) {
        this.logAccess(sessionToken, "search_for_datasets", "criteria(%s) user_id(%s)", criteria, userId);
        return null;
    }

    @Override
    public List<Sample> searchForSamples(String sessionToken, DetailedSearchCriteria criteria) {
        this.logAccess(sessionToken, "search_for_samples", "criteria(%s)", criteria);
        return null;
    }

    @Override
    public AbstractExternalData getDataSetInfo(String sessionToken, TechId datasetId) {
        this.logAccess(sessionToken, "getDataSetInfo", "datasetId(%s)", datasetId.getId());
        return null;
    }

    @Override
    public DataSetUpdateResult updateDataSet(String sessionToken, DataSetUpdatesDTO updates) {
        this.logTracking(sessionToken, "updateDataSet", "DATA_SET(%s)", updates.getDatasetId());
        return null;
    }

    @Override
    public List<AbstractExternalData> listRelatedDataSets(String sessionToken, DataSetRelatedEntities entities, boolean withDetails) {
        this.logAccess(sessionToken, "list_related_datasets", "WITH_DETAILS(%s)", withDetails);
        return null;
    }

    @Override
    public List<AbstractExternalData> listRelatedDataSetsOnBehalfOfUser(String sessionToken, DataSetRelatedEntities entities, boolean withDetails, String userId) {
        this.logAccess(sessionToken, "list_related_datasets_on_behalf_of_user", "WITH_DETAILS(%s)", "WITH_USER(%s)", withDetails, userId);
        return null;
    }

    @Override
    public List<MaterialType> listMaterialTypes(String sessionToken) {
        this.logAccess(sessionToken, "list_material_types");
        return null;
    }

    @Override
    public MaterialType getMaterialType(String sessionToken, String code) {
        this.logAccess(sessionToken, "get_material_type", "CODE(%s)", code);
        return null;
    }

    public List<Material> listMaterials(String sessionToken, MaterialType materialType, boolean withProperties) {
        this.logAccess(sessionToken, "list_materials", "TYPE(%s) withProperties(%s)", materialType, withProperties);
        return null;
    }

    @Override
    public List<Material> listMaterials(String sessionToken, ListMaterialCriteria criteria, boolean withProperties) {
        this.logAccess(sessionToken, "list_materials", "TYPE(%s) IDS(%s) withProperties(%s)", criteria.tryGetMaterialType(), criteria.tryGetMaterialIds() == null ? "-" : this.abbreviate(criteria.tryGetMaterialIds()), withProperties);
        return null;
    }

    @Override
    public List<Material> listMetaprojectMaterials(String sessionToken, IMetaprojectId metaprojectId) {
        this.logAccess(sessionToken, "list_metaproject_materials", "METAPROJECT_ID(%s)", metaprojectId);
        return null;
    }

    @Override
    public void registerMaterialType(String sessionToken, MaterialType entityType) {
        this.logTracking(sessionToken, "register_material_type", "CODE(%s)", entityType.getCode());
    }

    @Override
    public void updateMaterialType(String sessionToken, EntityType entityType) {
        this.logTracking(sessionToken, "update_material_type", "CODE(%s)", entityType.getCode());
    }

    @Override
    public void registerSampleType(String sessionToken, SampleType entityType) {
        this.logTracking(sessionToken, "register_sample_type", "CODE(%s)", entityType.getCode());
    }

    @Override
    public void updateSampleType(String sessionToken, EntityType entityType) {
        this.logTracking(sessionToken, "update_sample_type", "CODE(%s)", entityType.getCode());
    }

    @Override
    public void registerExperimentType(String sessionToken, ExperimentType entityType) {
        this.logTracking(sessionToken, "register_experiment_type", "CODE(%s)", entityType.getCode());
    }

    @Override
    public void updateExperimentType(String sessionToken, EntityType entityType) {
        this.logTracking(sessionToken, "update_experiment_type", "CODE(%s)", entityType.getCode());
    }

    @Override
    public void registerFileFormatType(String sessionToken, FileFormatType type) {
        this.logTracking(sessionToken, "register_file_format_type", "CODE(%s)", type.getCode());
    }

    @Override
    public void registerDataSetType(String sessionToken, DataSetType entityType) {
        this.logTracking(sessionToken, "register_data_set_type", "CODE(%s)", entityType.getCode());
    }

    @Override
    public void updateDataSetType(String sessionToken, EntityType entityType) {
        this.logTracking(sessionToken, "update_data_set_type", "CODE(%s)", entityType.getCode());
    }

    @Override
    public void deleteDataSets(String sessionToken, List<String> dataSetCodes, String reason, DeletionType type, boolean isTrashEnabled) {
        this.logTracking(sessionToken, "delete_data_sets", "TYPE(%s) CODES(%s) REASON(%s)", type, this.abbreviate(dataSetCodes), reason);
    }

    @Override
    public void deleteDataSetsForced(String sessionToken, List<String> dataSetCodes, String reason, DeletionType type, boolean isTrashEnabled) {
        this.logTracking(sessionToken, "delete_data_sets_forced", "TYPE(%s) CODES(%s) REASON(%s)", type, this.abbreviate(dataSetCodes), reason);
    }

    @Override
    public void deleteSamples(String sessionToken, List<TechId> sampleIds, String reason, DeletionType deletionType) {
        this.logTracking(sessionToken, "delete_samples", "TYPE(%s) IDS(%s) REASON(%s)", deletionType, this.abbreviate(sampleIds), reason);
    }

    @Override
    public void deleteExperiments(String sessionToken, List<TechId> experimentIds, String reason, DeletionType deletionType) {
        this.logTracking(sessionToken, "delete_experiments", "TYPE(%s) IDS(%s) REASON(%s)", deletionType, this.abbreviate(experimentIds), reason);
    }

    @Override
    public void deleteVocabularies(String sessionToken, List<TechId> vocabularyIds, String reason) {
        this.logTracking(sessionToken, "delete_vocabularies", "IDS(%s) REASON(%s)", this.abbreviate(vocabularyIds), reason);
    }

    @Override
    public void deletePropertyTypes(String sessionToken, List<TechId> propertyTypeIds, String reason) {
        this.logTracking(sessionToken, "delete_property_types", "IDS(%s) REASON(%s)", this.abbreviate(propertyTypeIds), reason);
    }

    @Override
    public void deleteProjects(String sessionToken, List<TechId> projectIds, String reason) {
        this.logTracking(sessionToken, "delete_projects", "IDS(%s) REASON(%s)", this.abbreviate(projectIds), reason);
    }

    @Override
    public void deleteSpaces(String sessionToken, List<TechId> groupIds, String reason) {
        this.logTracking(sessionToken, "delete_spaces", "IDS(%s) REASON(%s)", this.abbreviate(groupIds), reason);
    }

    @Override
    public void deleteScripts(String sessionToken, List<TechId> scriptIds) {
        this.logTracking(sessionToken, "delete_scripts", "IDS(%s)", this.abbreviate(scriptIds));
    }

    @Override
    public void deleteExperimentAttachments(String sessionToken, TechId experimentId, List<String> fileNames, String reason) {
        this.logTracking(sessionToken, "delete_experiment_attachments", "ID(%s) FILES(%s) REASON(%s)", experimentId, this.abbreviate(fileNames), reason);
    }

    @Override
    public void deleteSampleAttachments(String sessionToken, TechId experimentId, List<String> fileNames, String reason) {
        this.logTracking(sessionToken, "delete_sample_attachments", "ID(%s) FILES(%s) REASON(%s)", experimentId, this.abbreviate(fileNames), reason);
    }

    @Override
    public void deleteProjectAttachments(String sessionToken, TechId experimentId, List<String> fileNames, String reason) {
        this.logTracking(sessionToken, "delete_project_attachments", "ID(%s) FILES(%s) REASON(%s)", experimentId, this.abbreviate(fileNames), reason);
    }

    @Override
    public List<Attachment> listExperimentAttachments(String sessionToken, TechId experimentId) {
        this.logAccess(sessionToken, "list_experiment_attachments", "ID(%s)", experimentId);
        return null;
    }

    @Override
    public List<Attachment> listSampleAttachments(String sessionToken, TechId sampleId) {
        this.logAccess(sessionToken, "list_sample_attachments", "ID(%s)", sampleId);
        return null;
    }

    @Override
    public List<Attachment> listProjectAttachments(String sessionToken, TechId projectId) {
        this.logAccess(sessionToken, "list_project_attachments", "ID(%s)", projectId);
        return null;
    }

    @Override
    public String uploadDataSets(String sessionToken, List<String> dataSetCodes, DataSetUploadContext uploadContext) {
        this.logTracking(sessionToken, "upload_data_sets", "CODES(%s) CIFEX-URL(%s) FILE(%s)", dataSetCodes, uploadContext.getCifexURL(), uploadContext.getFileName());
        return null;
    }

    @Override
    public List<VocabularyTermWithStats> listVocabularyTermsWithStatistics(String sessionToken, Vocabulary vocabulary) {
        this.logAccess(sessionToken, "list_vocabulary_terms_with_statistics", "VOCABULARY(%s)", vocabulary.getCode());
        return null;
    }

    @Override
    public Set<VocabularyTerm> listVocabularyTerms(String sessionToken, Vocabulary vocabulary) {
        this.logAccess(sessionToken, "list_vocabulary_terms", "VOCABULARY(%s)", vocabulary.getCode());
        return null;
    }

    @Override
    public List<DataSetType> listDataSetTypes(String sessionToken) {
        this.logAccess(sessionToken, "list_data_set_types");
        return null;
    }

    @Override
    public LastModificationState getLastModificationState(String sessionToken) {
        return null;
    }

    @Override
    public final SampleParentWithDerived getSampleInfo(String sessionToken, TechId sampleId) {
        this.logAccess(sessionToken, "get_sample_info", "ID(%s)", sampleId);
        return null;
    }

    @Override
    public SampleUpdateResult updateSample(String sessionToken, SampleUpdatesDTO updates) {
        this.logTracking(sessionToken, "edit_sample", "SAMPLE(%s), CHANGE_TO_EXPERIMENT(%s) ATTACHMENTS(%s)", updates.getSampleIdOrNull(), updates.getExperimentIdentifierOrNull(), updates.getAttachments().size());
        return null;
    }

    @Override
    public Experiment getExperimentInfo(String sessionToken, ExperimentIdentifier identifier) {
        this.logAccess(sessionToken, "get_experiment_info", "IDENTIFIER(%s)", identifier);
        return null;
    }

    @Override
    public Experiment getExperimentInfo(String sessionToken, TechId experimentId) {
        this.logAccess(sessionToken, "get_experiment_info", "ID(%s)", experimentId);
        return null;
    }

    @Override
    public ExperimentUpdateResult updateExperiment(String sessionToken, ExperimentUpdatesDTO updates) {
        this.logTracking(sessionToken, "update_experiment", "EXPERIMENT(%s)", updates.getExperimentId());
        return null;
    }

    @Override
    public IIdHolder getProjectIdHolder(String sessionToken, String projectPermId) {
        this.logAccess(sessionToken, "get_project_id_holder", "PERM_ID(%s)", projectPermId);
        return null;
    }

    @Override
    public Project getProjectInfo(String sessionToken, TechId projectId) {
        this.logAccess(sessionToken, "get_project_info", "ID(%s)", projectId);
        return null;
    }

    @Override
    public Project getProjectInfo(String sessionToken, ProjectIdentifier projectIdentifier) {
        this.logAccess(sessionToken, "get_project_info", "IDENTIFIER(%s)", projectIdentifier);
        return null;
    }

    @Override
    public IEntityInformationHolderWithPermId getEntityInformationHolder(String sessionToken, EntityKind entityKind, String permId) {
        String entityTypeFormat = String.valueOf(entityKind.name()) + "_TYPE(%S)";
        this.logTracking(sessionToken, "get_entity_information_holder", String.valueOf(entityTypeFormat) + " PERM_ID(%S) ", entityKind, permId);
        return null;
    }

    @Override
    public IEntityInformationHolderWithPermId getMaterialInformationHolder(String sessionToken, MaterialIdentifier identifier) {
        this.logTracking(sessionToken, "get_material_information_holder", " IDENTIFIER(%S) ", identifier);
        return null;
    }

    @Override
    public Material getMaterialInfo(String sessionToken, MaterialIdentifier identifier) {
        this.logTracking(sessionToken, "getMaterialInfo", " IDENTIFIER(%S) ", identifier);
        return null;
    }

    @Override
    public Material getMaterialInfo(String sessionToken, TechId materialId) {
        this.logAccess(sessionToken, "get_material_info", "ID(%s)", materialId);
        return null;
    }

    @Override
    public Date updateMaterial(String sessionToken, TechId materialId, List<IEntityProperty> properties, String[] metaprojects, Date version) {
        this.logTracking(sessionToken, "edit_material", "MATERIAL(%s)", materialId);
        return null;
    }

    @Override
    public String generateCode(String sessionToken, String prefix, EntityKind entityKind) {
        this.logAccess(sessionToken, "generate_code", "PREFIX(%s) ENTITY_KIND(%s)", prefix, entityKind);
        return null;
    }

    @Override
    public int updateProject(String sessionToken, ProjectUpdatesDTO updates) {
        this.logTracking(sessionToken, "edit_project", "PROJECT_ID(%s) ATTACHMENTS_ADDED(%s)", updates.getTechId(), updates.getAttachments().size());
        return 0;
    }

    @Override
    public void deleteDataSetTypes(String sessionToken, List<String> entityTypesCodes) {
        this.logTracking(sessionToken, "delete_data_set_types", "CODES(%s)", this.abbreviate(entityTypesCodes));
    }

    @Override
    public void deleteExperimentTypes(String sessionToken, List<String> entityTypesCodes) {
        this.logTracking(sessionToken, "delete_experiment_types", "CODES(%s)", this.abbreviate(entityTypesCodes));
    }

    @Override
    public void deleteMaterialTypes(String sessionToken, List<String> entityTypesCodes) {
        this.logTracking(sessionToken, "delete_material_types", "CODES(%s)", this.abbreviate(entityTypesCodes));
    }

    @Override
    public void deleteSampleTypes(String sessionToken, List<String> entityTypesCodes) {
        this.logTracking(sessionToken, "delete_sample_types", "CODES(%s)", this.abbreviate(entityTypesCodes));
    }

    @Override
    public String getTemplateColumns(String sessionToken, EntityKind entityKind, String type, boolean autoGenerate, boolean withExperiments, boolean withSpace, BatchOperationKind operationKind) {
        this.logAccess(sessionToken, "get_template_columns", "ENTITY_KIND(%s) ENTITY_TYPE(%s) AUTO_GENERATE(%s) WITH_EXP(%s) WITH_SPACE(%s) OPERATION(%s)", entityKind, type, autoGenerate, withExperiments, withSpace, operationKind.getDescription());
        return null;
    }

    @Override
    public void deleteFileFormatTypes(String sessionToken, List<String> codes) {
        this.logTracking(sessionToken, "delete_file_format_types", "CODES(%s)", this.abbreviate(codes));
    }

    @Override
    public void updateFileFormatType(String sessionToken, AbstractType type) {
        this.logTracking(sessionToken, "update_file_format_type", "CODE(%s)", type.getCode());
    }

    @Override
    public void updateExperimentAttachments(String sessionToken, TechId experimentId, Attachment attachment) {
        this.logTracking(sessionToken, "update_experiment_attachment", "EXPERIMENT_ID(%s) ATTACHMENT(%s)", experimentId, attachment.getFileName());
    }

    @Override
    public void addExperimentAttachment(String sessionToken, TechId experimentId, NewAttachment attachment) {
        this.logTracking(sessionToken, "add_experiment_attachment", "EXPERIMENT_ID(%s) ATTACHMENT(%s)", experimentId, attachment.getFileName());
    }

    @Override
    public void updateProjectAttachments(String sessionToken, TechId projectId, Attachment attachment) {
        this.logTracking(sessionToken, "update_project_attachment", "PROJECT_ID(%s) ATTACHMENT(%s)", projectId, attachment.getFileName());
    }

    @Override
    public void addProjectAttachments(String sessionToken, TechId projectId, NewAttachment attachment) {
        this.logTracking(sessionToken, "add_project_attachment", "PROJECT_ID(%s) ATTACHMENT(%s)", projectId, attachment.getFileName());
    }

    @Override
    public void updateSampleAttachments(String sessionToken, TechId sampleId, Attachment attachment) {
        this.logTracking(sessionToken, "update_sample_attachment", "SAMPLE_ID(%s) ATTACHMENT(%s)", sampleId, attachment.getFileName());
    }

    @Override
    public void addSampleAttachments(String sessionToken, TechId sampleId, NewAttachment attachment) {
        this.logTracking(sessionToken, "add_sample_attachment", "SAMPLE_ID(%s) ATTACHMENT(%s)", sampleId, attachment.getFileName());
    }

    @Override
    public List<DataStore> listDataStores(String sessionToken) {
        this.logAccess(sessionToken, "listDataStores");
        return null;
    }

    @Override
    public List<DatastoreServiceDescription> listDataStoreServices(String sessionToken, DataStoreServiceKind dataStoreServiceKind) {
        this.logAccess(sessionToken, "listDataStoreServices");
        return null;
    }

    @Override
    public TableModel createReportFromDatasets(String sessionToken, DatastoreServiceDescription serviceDescription, List<String> datasetCodes) {
        this.logAccess(sessionToken, "createReportFromDatasets", "SERVICE(%s), DATASETS(%s)", serviceDescription, this.abbreviate(datasetCodes));
        return null;
    }

    @Override
    public TableModel createReportFromDatasets(String sessionToken, String serviceKey, List<String> datasetCodes) {
        this.logAccess(sessionToken, "createReportFromDatasets", "SERVICE(%s), DATASETS(%s)", serviceKey, this.abbreviate(datasetCodes));
        return null;
    }

    @Override
    public void processDatasets(String sessionToken, DatastoreServiceDescription serviceDescription, List<String> datasetCodes) {
        this.logTracking(sessionToken, "processDatasets", "SERVICE(%s), DATASETS(%s)", serviceDescription, this.abbreviate(datasetCodes));
    }

    @Override
    public void registerAuthorizationGroup(String sessionToken, NewAuthorizationGroup newAuthorizationGroup) {
        this.logTracking(sessionToken, "registerAuthorizationGroup", "CODE(%s)", newAuthorizationGroup.getCode());
    }

    @Override
    public void registerScript(String sessionToken, Script script) {
        this.logTracking(sessionToken, "registerScript", "NAME(%s)", script.getName());
    }

    @Override
    public void deleteAuthorizationGroups(String sessionToken, List<TechId> authGroupIds, String reason) {
        this.logTracking(sessionToken, "deleteAuthorizationGroups", "TECH_IDS(%s)", this.abbreviate(authGroupIds));
    }

    @Override
    public List<AuthorizationGroup> listAuthorizationGroups(String sessionToken) {
        this.logAccess(sessionToken, "listAuthorizatonGroups");
        return null;
    }

    @Override
    public Date updateAuthorizationGroup(String sessionToken, AuthorizationGroupUpdates updates) {
        this.logTracking(sessionToken, "updateAuthorizationGroup", "TECH_ID(%s)", updates.getId());
        return null;
    }

    @Override
    public List<Person> listPersonInAuthorizationGroup(String sessionToken, TechId authorizatonGroupId) {
        this.logAccess(sessionToken, "listPersonInAuthorizationGroup", "ID(%s)", authorizatonGroupId);
        return null;
    }

    @Override
    public void addPersonsToAuthorizationGroup(String sessionToken, TechId authorizationGroupId, List<String> personsCodes) {
        this.logTracking(sessionToken, "addPersonsToAuthorizationGroup", "TECH_ID(%s) PERSONS(%s)", authorizationGroupId, this.abbreviate(personsCodes));
    }

    @Override
    public void removePersonsFromAuthorizationGroup(String sessionToken, TechId authorizationGroupId, List<String> personsCodes) {
        this.logTracking(sessionToken, "removePersonsFromAuthorizationGroup", "TECH_ID(%s) PERSONS(%s)", authorizationGroupId, this.abbreviate(personsCodes));
    }

    @Override
    public List<GridCustomFilter> listFilters(String sessionToken, String gridId) {
        this.logAccess(sessionToken, "listFilters", "GRID(%s)", gridId);
        return null;
    }

    @Override
    public void registerFilter(String sessionToken, NewColumnOrFilter filter) {
        this.logTracking(sessionToken, "registerFilter", "FILTER(%s)", filter);
    }

    @Override
    public void deleteFilters(String sessionToken, List<TechId> filterIds) {
        this.logTracking(sessionToken, "deleteFilters", "TECH_IDS(%s)", this.abbreviate(filterIds));
    }

    @Override
    public void updateFilter(String sessionToken, IExpressionUpdates updates) {
        this.logTracking(sessionToken, "updateFilters", "ID(%s) NAME(%s)", updates.getId(), updates.getName());
    }

    @Override
    public void registerGridCustomColumn(String sessionToken, NewColumnOrFilter column) {
        this.logTracking(sessionToken, "registerGridCustomColumn", "COLUMN(%s)", column);
    }

    @Override
    public void deleteGridCustomColumns(String sessionToken, List<TechId> columnIds) {
        this.logTracking(sessionToken, "deleteGridCustomColumns", "TECH_IDS(%s)", this.abbreviate(columnIds));
    }

    @Override
    public void updateGridCustomColumn(String sessionToken, IExpressionUpdates updates) {
        this.logTracking(sessionToken, "updateGridCustomColumn", "ID(%s) NAME(%s)", updates.getId(), updates.getName());
    }

    @Override
    public void keepSessionAlive(String sessionToken) {
        this.logAccess(Level.DEBUG, sessionToken, "keepSessionAlive", "TOKEN(%s)", sessionToken);
    }

    @Override
    public void updateVocabularyTerms(String sessionToken, TechId vocabularyId, List<VocabularyTerm> terms) {
        this.logTracking(sessionToken, "update_vocabulary_terms", "VOCABULARY_TERMS(%s) VOCABULARY(%s)", this.abbreviate(terms), vocabularyId);
    }

    @Override
    public void deleteMaterials(String sessionToken, List<TechId> materialIds, String reason) {
        this.logTracking(sessionToken, "delete_materials", "IDS(%s) REASON(%s)", this.abbreviate(materialIds), reason);
    }

    @Override
    public int lockDatasets(String sessionToken, List<String> datasetCodes) {
        this.logTracking(sessionToken, "lockDatasets", "DATASETS(%s)", this.abbreviate(datasetCodes));
        return 0;
    }

    @Override
    public int unlockDatasets(String sessionToken, List<String> datasetCodes) {
        this.logTracking(sessionToken, "unlockDatasets", "DATASETS(%s)", this.abbreviate(datasetCodes));
        return 0;
    }

    @Override
    public LinkModel retrieveLinkFromDataSet(String sessionToken, DatastoreServiceDescription serviceDescription, String dataSetCode) {
        this.logAccess(sessionToken, "retrieveLinkFromDataSet", "SERVICE(%s), DATASET(%s)", serviceDescription, dataSetCode);
        return null;
    }

    @Override
    public Script getScriptInfo(String sessionToken, TechId scriptId) {
        this.logAccess(sessionToken, "getScriptInfo", "SCRIPT(%s)", scriptId);
        return null;
    }

    @Override
    public String evaluate(String sessionToken, DynamicPropertyEvaluationInfo info) {
        this.logAccess(sessionToken, "evaluate", "%s(%s)", info.getEntityKind().name(), info.getEntityIdentifier());
        return null;
    }

    @Override
    public String evaluate(String sessionToken, EntityValidationEvaluationInfo info) {
        this.logAccess(sessionToken, "evaluate", "%s(%s)", info.getEntityKind().name(), info.getEntityIdentifier());
        return null;
    }

    @Override
    public IEntityInformationHolderWithPermId getEntityInformationHolder(String sessionToken, BasicEntityDescription info) {
        this.logAccess(sessionToken, "getEntityInformationHolder", "KIND(%s) IDENTIFIER(%s)", info.getEntityKind(), info.getEntityIdentifier());
        return null;
    }

    @Override
    public void updateManagedPropertyOnExperiment(String sessionToken, TechId experimentId, IManagedProperty managedProperty, IManagedUiAction updateAction) {
        this.logTracking(sessionToken, "updateManagedPropertyOnExperiment", "ID(%s) PROPERTY(%s) ACTION(%s)", experimentId, managedProperty.getPropertyTypeCode(), updateAction.getName());
    }

    @Override
    public void updateManagedPropertyOnSample(String sessionToken, TechId sampleId, IManagedProperty managedProperty, IManagedUiAction updateAction) {
        this.logTracking(sessionToken, "updateManagedPropertyOnSample", "ID(%s) PROPERTY(%s) ACTION(%s)", sampleId, managedProperty.getPropertyTypeCode(), updateAction.getName());
    }

    @Override
    public void updateManagedPropertyOnDataSet(String sessionToken, TechId dataSetId, IManagedProperty managedProperty, IManagedUiAction updateAction) {
        this.logTracking(sessionToken, "updateManagedPropertyOnDataSet", "ID(%s) PROPERTY(%s) ACTION(%s)", dataSetId, managedProperty.getPropertyTypeCode(), updateAction.getName());
    }

    @Override
    public void updateManagedPropertyOnMaterial(String sessionToken, TechId materialId, IManagedProperty managedProperty, IManagedUiAction updateAction) {
        this.logTracking(sessionToken, "updateManagedPropertyOnMaterial", "ID(%s) PROPERTY(%s) ACTION(%s)", materialId, managedProperty.getPropertyTypeCode(), updateAction.getName());
    }

    @Override
    public String getDefaultPutDataStoreBaseURL(String sessionToken) {
        this.logAccess(sessionToken, "getDefaultPutDataStoreBaseURL");
        return null;
    }

    @Override
    public void updateDataSetProperties(String sessionToken, TechId entityId, List<PropertyUpdates> modifiedProperties) {
        this.logTracking(sessionToken, "updateDataSetProperty", "ID(%s) MODIFIED_PROPERTIES(%s)", entityId, this.abbreviate(modifiedProperties));
    }

    @Override
    public void updateExperimentProperties(String sessionToken, TechId entityId, List<PropertyUpdates> modifiedProperties) {
        this.logTracking(sessionToken, "updateExperimentProperty", "ID(%s) MODIFIED_PROPERTIES(%s)", entityId, this.abbreviate(modifiedProperties));
    }

    @Override
    public void updateSampleProperties(String sessionToken, TechId entityId, List<PropertyUpdates> modifiedProperties) {
        this.logTracking(sessionToken, "updateSampleProperty", "ID(%s) MODIFIED_PROPERTIES(%s)", entityId, this.abbreviate(modifiedProperties));
    }

    @Override
    public void updateMaterialProperties(String sessionToken, TechId entityId, List<PropertyUpdates> modifiedProperties) {
        this.logTracking(sessionToken, "updateMaterialProperty", "ID(%s), MODIFIED_PROPERTIES(%s)", entityId, this.abbreviate(modifiedProperties));
    }

    @Override
    public List<Experiment> listExperiments(String sessionToken, List<ExperimentIdentifier> experimentIdentifiers) {
        this.logTracking(sessionToken, "listExperiments", "experimentIdentifiers(%s)", this.abbreviate(experimentIdentifiers));
        return null;
    }

    @Override
    public List<Deletion> listDeletions(String sessionToken, boolean withDeletedEntities) {
        this.logAccess(sessionToken, "listDeletions", "WITH_ENTITIES(%s)", withDeletedEntities);
        return null;
    }

    @Override
    public List<Deletion> listOriginalDeletions(String sessionToken) {
        this.logAccess(sessionToken, "listOriginalDeletions");
        return null;
    }

    @Override
    public void revertDeletions(String sessionToken, List<TechId> deletionIds) {
        this.logTracking(sessionToken, "revertDeletions", "ID(%s)", this.abbreviate(deletionIds));
    }

    @Override
    public void deletePermanently(String sessionToken, List<TechId> deletionIds) {
        this.logTracking(sessionToken, "deletePermanently", "ID(%s)", this.abbreviate(deletionIds));
    }

    @Override
    public void deletePermanentlyForced(String sessionToken, List<TechId> deletionIds) {
        this.logTracking(sessionToken, "deletePermanentlyForced", "ID(%s)", this.abbreviate(deletionIds));
    }

    @Override
    public List<EntityTypePropertyType<?>> listEntityTypePropertyTypes(String sessionToken) {
        this.logTracking(sessionToken, "listEntityTypePropertyTypes", "", new Object[0]);
        return null;
    }

    @Override
    public List<EntityTypePropertyType<?>> listEntityTypePropertyTypes(String sessionToken, EntityType entityType) {
        this.logTracking(sessionToken, "listEntityTypePropertyTypes", "ENTITY_TYPE(%s)", entityType != null ? entityType.getCode() : null);
        return null;
    }

    @Override
    public void registerPlugin(String sessionToken, CorePlugin plugin, ICorePluginResourceLoader resourceLoader) {
        this.logTracking(sessionToken, "registerPlugin", "PLUGIN(%s), LOADER(%s)", plugin, resourceLoader);
    }

    @Override
    public List<DataStore> listDataStores() {
        this.logTracking("internal_call", "listDataStores", "", new Object[0]);
        return null;
    }

    @Override
    public List<Material> searchForMaterials(String sessionToken, DetailedSearchCriteria criteria) {
        this.logAccess(sessionToken, "search_for_materials", "criteria(%s)", criteria);
        return null;
    }

    @Override
    public TableModel createReportFromAggregationService(String sessionToken, DatastoreServiceDescription serviceDescription, Map<String, Object> parameters) {
        this.logAccess(sessionToken, "createReportFromAggregationService", "SERVICE(%s), PARAMETERS(%s)", serviceDescription, parameters);
        return null;
    }

    @Override
    public String performCustomImport(String sessionToken, String customImportCode, CustomImportFile customImportFile) {
        this.logAccess(sessionToken, "performCustomImport", "CUSTOM_IMPORT_CODE(%s), CUSTOM_IMPORT_FILE(%s)", customImportCode, customImportFile);
        return null;
    }

    @Override
    public void sendCountActiveUsersEmail(String sessionToken) {
        this.logAccess(sessionToken, "sendCountActiveUsersEmail", "", new Object[0]);
    }

    @Override
    public List<ExternalDataManagementSystem> listExternalDataManagementSystems(String sessionToken) {
        this.logAccess(sessionToken, "listExternalDataManagementSystems", "", new Object[0]);
        return null;
    }

    @Override
    public ExternalDataManagementSystem getExternalDataManagementSystem(String sessionToken, String code) {
        this.logAccess(sessionToken, "getExternalDataManagementSystem", "", new Object[0]);
        return null;
    }

    @Override
    public void createOrUpdateExternalDataManagementSystem(String sessionToken, ExternalDataManagementSystem edms) {
        this.logAccess(sessionToken, "createOrUpdateExternalDataManagementSystem CODE(%s)", edms.getCode(), new Object[0]);
    }

    @Override
    public List<Metaproject> listMetaprojects(String sessionToken) {
        this.logAccess(sessionToken, "listMetaprojects");
        return null;
    }

    @Override
    public List<Metaproject> listMetaprojectsOnBehalfOfUser(String sessionToken, String userId) {
        this.logAccess(sessionToken, "listMetaprojectsOnBehalfOfUser", "USER(%s)", userId);
        return null;
    }

    @Override
    public List<MetaprojectAssignmentsCount> listMetaprojectAssignmentsCounts(String sessionToken) {
        this.logAccess(sessionToken, "listMetaprojectAssignmentsCounts");
        return null;
    }

    @Override
    public MetaprojectAssignmentsCount getMetaprojectAssignmentsCount(String sessionToken, IMetaprojectId metaprojectId) {
        this.logAccess(sessionToken, "getMetaprojectAssignmentsCount", "METAPROJECT_ID(%s)", metaprojectId);
        return null;
    }

    @Override
    public MetaprojectAssignments getMetaprojectAssignments(String sessionToken, IMetaprojectId metaprojectId, EnumSet<MetaprojectAssignmentsFetchOption> fetchOptions) {
        this.logAccess(sessionToken, "getMetaprojectAssignments", "METAPROJECT_ID(%s) FETCH_OPTIONS(%s)", metaprojectId, fetchOptions);
        return null;
    }

    @Override
    public Metaproject getMetaproject(String sessionToken, IMetaprojectId metaprojectId) {
        this.logAccess(sessionToken, "getMetaproject", "METAPROJECT_ID(%s)", metaprojectId);
        return null;
    }

    @Override
    public MetaprojectAssignments getMetaprojectAssignments(String sessionToken, IMetaprojectId metaprojectId) {
        this.logAccess(sessionToken, "getMetaprojectAssignments", "METAPROJECT_ID(%s)", metaprojectId);
        return null;
    }

    @Override
    public MetaprojectAssignments getMetaprojectAssignmentsOnBehalfOfUser(String sessionToken, IMetaprojectId metaprojectId, String userId) {
        this.logAccess(sessionToken, "getMetaprojectAssignmentsOnBehalfOfUser", "METAPROJECT_ID(%s) USER(%s)", metaprojectId, userId);
        return null;
    }

    @Override
    public void addToMetaproject(String sessionToken, IMetaprojectId metaprojectId, MetaprojectAssignmentsIds assignmentsToAdd) {
        MetaprojectAssignmentsIds assignments = assignmentsToAdd != null ? assignmentsToAdd : new MetaprojectAssignmentsIds();
        this.logAccess(sessionToken, "addToMetaproject", "METAPROJECT_ID(%s), EXPERIMENTS(%s), SAMPLES(%s), DATA_SETS(%s), MATERIALS(%s)", metaprojectId, this.abbreviate(assignments.getExperiments()), this.abbreviate(assignments.getSamples()), this.abbreviate(assignments.getDataSets()), this.abbreviate(assignments.getMaterials()));
    }

    @Override
    public void removeFromMetaproject(String sessionToken, IMetaprojectId metaprojectId, MetaprojectAssignmentsIds assignmentsToRemove) {
        MetaprojectAssignmentsIds assignments = assignmentsToRemove != null ? assignmentsToRemove : new MetaprojectAssignmentsIds();
        this.logAccess(sessionToken, "removeFromMetaproject", "METAPROJECT_ID(%s), EXPERIMENTS(%s), SAMPLES(%s), DATA_SETS(%s), MATERIALS(%s)", metaprojectId, this.abbreviate(assignments.getExperiments()), this.abbreviate(assignments.getSamples()), this.abbreviate(assignments.getDataSets()), this.abbreviate(assignments.getMaterials()));
    }

    @Override
    public void deleteMetaproject(String sessionToken, IMetaprojectId metaprojectId, String reason) {
        this.logAccess(sessionToken, "deleteMetaproject", "METAPROJECT_ID(%s)", metaprojectId);
    }

    @Override
    public void deleteMetaprojects(String sessionToken, List<IMetaprojectId> metaprojectIds, String reason) {
        this.logTracking(sessionToken, "deleteMetaprojects", "METAPROJECT_IDS(%s) REASON(%s)", this.abbreviate(metaprojectIds), reason);
    }

    @Override
    public Metaproject registerMetaproject(String sessionToken, IMetaprojectRegistration registration) {
        IMetaprojectRegistration notNullRegistration = registration == null ? new MetaprojectNullRegistration() : registration;
        this.logAccess(sessionToken, "registerMetaproject", "NAME(%s) DESCRIPTION(%s)", notNullRegistration.getName(), notNullRegistration.getDescription());
        return null;
    }

    @Override
    public Metaproject updateMetaproject(String sessionToken, IMetaprojectId metaprojectId, IMetaprojectUpdates updates) {
        IMetaprojectUpdates notNullUpdate = updates == null ? new MetaprojectNullUpdates() : updates;
        this.logAccess(sessionToken, "updateMetaproject", "METAPROJECT_ID(%s) NAME(%s) DESCRIPTION(%s)", metaprojectId, notNullUpdate.getName(), notNullUpdate.getDescription());
        return null;
    }

    @Override
    public List<String> listPredeployedPlugins(String sessionToken, ScriptType scriptType) {
        this.logAccess(sessionToken, "list_predeployed_plugins", "SCRIPT_TYPE(%s)", scriptType);
        return null;
    }

    @Override
    public void registerOrUpdatePredeployedPlugin(String sessionToken, Script script) {
        this.logAccess(sessionToken, "register_or_update_predeployed_plugin", "NAME(%s)", script.getName());
    }

    @Override
    public void invalidatePredeployedPlugin(String sessionToken, String name, ScriptType scriptType) {
        this.logAccess(sessionToken, "invalidate_predeployed_plugin", "NAME(%s)", name);
    }
}

