/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.authorization.validator;

import ch.systemsx.cisd.openbis.generic.server.authorization.validator.AbstractValidator;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExpression;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseInstance;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Person;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.RoleWithHierarchy;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatabaseInstancePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.RoleAssignmentPE;
import java.util.Set;

public final class ExpressionValidator
extends AbstractValidator<AbstractExpression> {
    @Override
    public final boolean doValidation(PersonPE person, AbstractExpression value) {
        return value.isPublic() || this.isRegistrator(person, value) || ExpressionValidator.isInstanceAdmin(person, value.getDatabaseInstance());
    }

    private boolean isRegistrator(PersonPE person, AbstractExpression value) {
        Person registrator = value.getRegistrator();
        return person.getUserId().equals(registrator.getUserId()) && person.getDatabaseInstance().getCode().equals(registrator.getDatabaseInstance().getCode());
    }

    private static boolean isInstanceAdmin(PersonPE person, DatabaseInstance databaseInstance) {
        Set<RoleAssignmentPE> roleAssignments = person.getAllPersonRoles();
        for (RoleAssignmentPE roleAssignment : roleAssignments) {
            DatabaseInstancePE roleInstance = roleAssignment.getDatabaseInstance();
            if (roleInstance == null || !roleInstance.getUuid().equals(databaseInstance.getUuid()) || !roleAssignment.getRole().equals(RoleWithHierarchy.RoleCode.ADMIN)) continue;
            return true;
        }
        return false;
    }
}

