/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.logicalimage;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.IScreeningClientServiceAsync;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.SliderWithAutoWidth;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.SliderWithMovieButtons;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.SliderWithMovieButtonsValueLoader;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.logicalimage.LogicalImageSeriesControls;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.logicalimage.LogicalImageSeriesDownloader;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.logicalimage.LogicalImageSeriesModel;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.logicalimage.LogicalImageSeriesPoint;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.SliderEvent;
import com.extjs.gxt.ui.client.widget.Label;
import com.extjs.gxt.ui.client.widget.Slider;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;

public class LogicalImageSeriesTimeAndDepthControls
extends LogicalImageSeriesControls {
    private Label timeLabel;
    private Label depthLabel;
    private SliderWithMovieButtons timeSliderWithButtons;
    private Slider depthSlider;

    public LogicalImageSeriesTimeAndDepthControls(IViewContext<IScreeningClientServiceAsync> viewContext, String displayTypeId, LogicalImageSeriesDownloader imageDownloader, LogicalImageSeriesModel imageModel) {
        super(viewContext, displayTypeId, imageDownloader, imageModel);
        VerticalPanel timeSliderWithLabel = new VerticalPanel();
        timeSliderWithLabel.add((Widget)this.getTimeLabel());
        timeSliderWithLabel.add(this.getTimeSliderWithButtons().getSliderWidget());
        VerticalPanel depthSliderWithLabel = new VerticalPanel();
        depthSliderWithLabel.add((Widget)this.getDepthLabel());
        depthSliderWithLabel.add((Widget)this.getDepthSlider());
        HorizontalPanel timeAndDepthSlidersWithLabels = new HorizontalPanel();
        timeAndDepthSlidersWithLabels.add((Widget)timeSliderWithLabel);
        timeAndDepthSlidersWithLabels.add(this.getSpacer());
        timeAndDepthSlidersWithLabels.add((Widget)depthSliderWithLabel);
        VerticalPanel mainPanel = new VerticalPanel();
        mainPanel.add((Widget)timeAndDepthSlidersWithLabels);
        mainPanel.add(this.getTimeSliderWithButtons().getButtonsWidget());
        mainPanel.add(this.getTimeSliderWithButtons().getLoadingWidget());
        this.add((Widget)mainPanel);
        this.refreshLabels();
    }

    private SliderWithMovieButtons getTimeSliderWithButtons() {
        if (this.timeSliderWithButtons == null) {
            this.timeSliderWithButtons = new SliderWithMovieButtons(this.getImageModel().getNumberOfTimepoints());
            this.timeSliderWithButtons.setValue(1);
            this.timeSliderWithButtons.setDelay(this.getSettingsManager().getDefaultMovieDelay(this.getDisplayTypeId()));
            this.timeSliderWithButtons.addDelayChangeHandler(new ChangeHandler(){

                public void onChange(ChangeEvent event) {
                    LogicalImageSeriesTimeAndDepthControls.this.getSettingsManager().setDefaultMovieDelay(LogicalImageSeriesTimeAndDepthControls.this.getDisplayTypeId(), LogicalImageSeriesTimeAndDepthControls.this.timeSliderWithButtons.getDelay());
                }
            });
            this.timeSliderWithButtons.setValueLoader(new SliderWithMovieButtonsValueLoader(){

                @Override
                public void loadValue(int value, AsyncCallback<Void> callback) {
                    LogicalImageSeriesTimeAndDepthControls.this.refreshValue((AsyncCallback<Void>)callback);
                    LogicalImageSeriesTimeAndDepthControls.this.refreshLabels();
                }
            });
        }
        return this.timeSliderWithButtons;
    }

    private Label getTimeLabel() {
        if (this.timeLabel == null) {
            this.timeLabel = new Label();
        }
        return this.timeLabel;
    }

    private Slider getDepthSlider() {
        if (this.depthSlider == null) {
            this.depthSlider = new SliderWithAutoWidth(this.getImageModel().getNumberOfDepthLevels());
            this.depthSlider.setValue(1);
            this.depthSlider.addListener(Events.Change, (Listener)new Listener<SliderEvent>(){

                public void handleEvent(SliderEvent be) {
                    LogicalImageSeriesTimeAndDepthControls.this.refreshValue((AsyncCallback<Void>)null);
                    LogicalImageSeriesTimeAndDepthControls.this.refreshLabels();
                }
            });
        }
        return this.depthSlider;
    }

    private Label getDepthLabel() {
        if (this.depthLabel == null) {
            this.depthLabel = new Label();
        }
        return this.depthLabel;
    }

    private Widget getSpacer() {
        HTML spacer = new HTML();
        spacer.getElement().getStyle().setWidth(20.0, Style.Unit.PX);
        return spacer;
    }

    private void refreshValue(AsyncCallback<Void> callback) {
        int timeIndex = this.getTimeSliderWithButtons().getValue();
        int depthIndex = this.getDepthSlider().getValue();
        int frame = (timeIndex - 1) * this.getImageModel().getNumberOfDepthLevels() + (depthIndex - 1);
        this.getImageDownloader().setSelectedFrame(frame, callback);
        this.layout();
    }

    private void refreshLabels() {
        int timeIndex = this.getTimeSliderWithButtons().getValue();
        int depthIndex = this.getDepthSlider().getValue();
        int numberOfTimePoints = this.getImageModel().getNumberOfTimepoints();
        int numberOfDepthLevels = this.getImageModel().getNumberOfDepthLevels();
        LogicalImageSeriesPoint point = this.getImageModel().get(timeIndex - 1, depthIndex - 1);
        this.getTimeLabel().setText("Time: " + point.getTimePointOrNull() + " sec (" + timeIndex + "/" + numberOfTimePoints + ")");
        this.getDepthLabel().setText("Depth: " + point.getDepthOrNull() + " (" + depthIndex + "/" + numberOfDepthLevels + ")");
    }
}

