/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.base.mdarray.MDLongArray;
import java.lang.reflect.Field;
import java.util.BitSet;
import ncsa.hdf.hdf5lib.exceptions.HDF5JavaException;
import org.apache.commons.lang.SystemUtils;

public final class BitSetConversionUtils {
    private static final int ADDRESS_BITS_PER_WORD = 6;
    private static final int BITS_PER_WORD = 64;
    private static final int BIT_INDEX_MASK = 63;
    private static final Field BIT_SET_WORDS = BitSetConversionUtils.getBitSetWords();
    private static final Field BIT_SET_WORDS_IN_USE = BitSetConversionUtils.getBitSetWordsInUse();

    private static Field getBitSetWords() {
        try {
            Field bitsField = BitSet.class.getDeclaredField(SystemUtils.IS_JAVA_1_5 ? "bits" : "words");
            bitsField.setAccessible(true);
            return bitsField;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return null;
        }
    }

    private static Field getBitSetWordsInUse() {
        try {
            Field unitsInUseField = BitSet.class.getDeclaredField(SystemUtils.IS_JAVA_1_5 ? "unitsInUse" : "wordsInUse");
            unitsInUseField.setAccessible(true);
            return unitsInUseField;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return null;
        }
    }

    public static BitSet fromStorageForm(long[] serializedWordArray) {
        return BitSetConversionUtils.fromStorageForm(serializedWordArray, 0, serializedWordArray.length);
    }

    public static BitSet fromStorageForm(long[] serializedWordArray, int start, int length) {
        if (BIT_SET_WORDS != null) {
            return BitSetConversionUtils.fromStorageFormFast(serializedWordArray, start, length);
        }
        return BitSetConversionUtils.fromStorageFormGeneric(serializedWordArray, start, length);
    }

    public static BitSet[] fromStorageForm2D(MDLongArray serializedWordArray) {
        if (serializedWordArray.rank() != 2) {
            throw new HDF5JavaException("Array is supposed to be of rank 2, but is of rank " + serializedWordArray.rank());
        }
        int dimX = serializedWordArray.dimensions()[0];
        int dimY = serializedWordArray.dimensions()[1];
        BitSet[] result = new BitSet[dimY];
        int i = 0;
        while (i < result.length) {
            result[i] = BitSetConversionUtils.fromStorageForm(serializedWordArray.getAsFlatArray(), i * dimX, dimX);
            ++i;
        }
        return result;
    }

    private static BitSet fromStorageFormFast(long[] serializedWordArray, int start, int length) {
        try {
            BitSet result = new BitSet();
            int inUse = BitSetConversionUtils.calcInUse(serializedWordArray, start, length);
            BIT_SET_WORDS_IN_USE.set(result, inUse);
            BIT_SET_WORDS.set(result, BitSetConversionUtils.trim(serializedWordArray, start, inUse));
            return result;
        }
        catch (IllegalAccessException ex) {
            throw new IllegalAccessError(ex.getMessage());
        }
    }

    @Private
    static BitSet fromStorageFormGeneric(long[] serializedWordArray, int start, int length) {
        BitSet result = new BitSet();
        int wordIndex = 0;
        while (wordIndex < length) {
            long word = serializedWordArray[start + wordIndex];
            int bitInWord = 0;
            while (bitInWord < 64) {
                if ((word & 1L << bitInWord) != 0L) {
                    result.set(wordIndex << 6 | bitInWord);
                }
                ++bitInWord;
            }
            ++wordIndex;
        }
        return result;
    }

    public static long[] toStorageForm(BitSet[] data, int numberOfWords) {
        long[] result = new long[data.length * numberOfWords];
        int idx = 0;
        BitSet[] bitSetArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            BitSet bs = bitSetArray[n2];
            System.arraycopy(BitSetConversionUtils.toStorageForm(bs, numberOfWords), 0, result, idx, numberOfWords);
            idx += numberOfWords;
            ++n2;
        }
        return result;
    }

    public static long[] toStorageForm(BitSet data) {
        if (BIT_SET_WORDS != null) {
            return BitSetConversionUtils.toStorageFormFast(data);
        }
        return BitSetConversionUtils.toStorageFormGeneric(data);
    }

    public static long[] toStorageForm(BitSet data, int numberOfWords) {
        if (BIT_SET_WORDS != null) {
            return BitSetConversionUtils.toStorageFormFast(data, numberOfWords);
        }
        return BitSetConversionUtils.toStorageFormGeneric(data, numberOfWords);
    }

    private static long[] toStorageFormFast(BitSet data) {
        try {
            long[] storageForm = (long[])BIT_SET_WORDS.get(data);
            int inUse = BIT_SET_WORDS_IN_USE.getInt(data);
            return BitSetConversionUtils.trim(storageForm, 0, inUse);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalAccessError(ex.getMessage());
        }
    }

    private static long[] toStorageFormFast(BitSet data, int numberOfWords) {
        try {
            long[] storageForm = (long[])BIT_SET_WORDS.get(data);
            return BitSetConversionUtils.trimEnforceLen(storageForm, 0, numberOfWords);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalAccessError(ex.getMessage());
        }
    }

    private static long[] trim(long[] array, int start, int len) {
        int inUse = BitSetConversionUtils.calcInUse(array, start, len);
        if (inUse < array.length) {
            long[] trimmedArray = new long[inUse];
            System.arraycopy(array, start, trimmedArray, 0, inUse);
            return trimmedArray;
        }
        return array;
    }

    private static long[] trimEnforceLen(long[] array, int start, int len) {
        if (len != array.length) {
            long[] trimmedArray = new long[len];
            int inUse = BitSetConversionUtils.calcInUse(array, start, len);
            System.arraycopy(array, start, trimmedArray, 0, inUse);
            return trimmedArray;
        }
        return array;
    }

    private static int calcInUse(long[] array, int start, int len) {
        int result = Math.min(len, array.length);
        while (result > 0 && array[start + result - 1] == 0L) {
            --result;
        }
        return result;
    }

    public static int getWordIndex(int bitIndex) {
        return bitIndex >> 6;
    }

    public static long getBitMaskInWord(int bitIndex) {
        return 1L << (bitIndex & 0x3F);
    }

    static long[] toStorageFormGeneric(BitSet data) {
        long[] words = new long[data.size() >> 6];
        int bitIndex = data.nextSetBit(0);
        while (bitIndex >= 0) {
            int wordIndex;
            int n = wordIndex = BitSetConversionUtils.getWordIndex(bitIndex);
            words[n] = words[n] | BitSetConversionUtils.getBitMaskInWord(bitIndex);
            bitIndex = data.nextSetBit(bitIndex + 1);
        }
        return words;
    }

    static long[] toStorageFormGeneric(BitSet data, int numberOfWords) {
        long[] words = new long[numberOfWords];
        int bitIndex = data.nextSetBit(0);
        while (bitIndex >= 0) {
            int wordIndex = BitSetConversionUtils.getWordIndex(bitIndex);
            if (wordIndex >= words.length) break;
            int n = wordIndex;
            words[n] = words[n] | BitSetConversionUtils.getBitMaskInWord(bitIndex);
            bitIndex = data.nextSetBit(bitIndex + 1);
        }
        return words;
    }

    static int getMaxLengthInWords(BitSet[] data) {
        int length = 0;
        BitSet[] bitSetArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            BitSet bs = bitSetArray[n2];
            length = Math.max(length, bs.length());
            ++n2;
        }
        return length;
    }
}

