/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5;

import ch.systemsx.cisd.base.mdarray.MDAbstractArray;
import ch.systemsx.cisd.base.mdarray.MDLongArray;
import ch.systemsx.cisd.hdf5.HDF5TimeDuration;
import ch.systemsx.cisd.hdf5.HDF5TimeUnit;
import java.util.Iterator;

public class HDF5TimeDurationMDArray
extends MDAbstractArray<Long> {
    private static final long serialVersionUID = 1L;
    final MDLongArray timeDurations;
    final HDF5TimeUnit timeUnit;

    public HDF5TimeDurationMDArray(MDLongArray timeDurations, HDF5TimeUnit timeUnit) {
        super(timeDurations.dimensions(), timeDurations.getAsFlatArray().length, 0);
        this.timeDurations = timeDurations;
        this.timeUnit = timeUnit;
    }

    public HDF5TimeDurationMDArray(long[] timeDurations, int[] dimensions, HDF5TimeUnit timeUnit) {
        super(dimensions, timeDurations.length, 0);
        this.timeDurations = new MDLongArray(timeDurations, dimensions, true);
        this.timeUnit = timeUnit;
    }

    public HDF5TimeDurationMDArray(HDF5TimeDuration[] timeDurations, int[] dimensions, HDF5TimeUnit timeUnit) {
        super(dimensions, timeDurations.length, 0);
        HDF5TimeUnit smallestTimeUnit = HDF5TimeDurationMDArray.getSmallestUnit(timeDurations);
        long[] durations = new long[timeDurations.length];
        if (timeUnit != smallestTimeUnit) {
            int i = 0;
            while (i < timeDurations.length) {
                durations[i] = timeUnit.convert(timeDurations[i]);
                ++i;
            }
        } else {
            int i = 0;
            while (i < timeDurations.length) {
                durations[i] = timeDurations[i].getValue();
                ++i;
            }
        }
        this.timeDurations = new MDLongArray(durations, dimensions, true);
        this.timeUnit = timeUnit;
    }

    public HDF5TimeDurationMDArray(HDF5TimeDuration[] timeDurations, int[] dimensions) {
        super(dimensions, timeDurations.length, 0);
        HDF5TimeUnit smallestTimeUnit = HDF5TimeDurationMDArray.getSmallestUnit(timeDurations);
        long[] durations = new long[timeDurations.length];
        int i = 0;
        while (i < timeDurations.length) {
            durations[i] = smallestTimeUnit.convert(timeDurations[i]);
            ++i;
        }
        this.timeDurations = new MDLongArray(durations, dimensions, true);
        this.timeUnit = smallestTimeUnit;
    }

    private static HDF5TimeUnit getSmallestUnit(HDF5TimeDuration[] timeDurations) {
        HDF5TimeUnit unit = timeDurations[0].getUnit();
        int i = 1;
        while (i < timeDurations.length) {
            HDF5TimeUnit u = timeDurations[i].getUnit();
            if (u != unit && u.ordinal() < unit.ordinal()) {
                unit = u;
            }
            ++i;
        }
        return unit;
    }

    public HDF5TimeUnit getUnit() {
        return this.timeUnit;
    }

    public long[] getAsFlatArray() {
        return this.timeDurations.getAsFlatArray();
    }

    public int[] dimensions() {
        return this.timeDurations.dimensions();
    }

    public long[] longDimensions() {
        return this.timeDurations.longDimensions();
    }

    public int getLength() {
        return this.timeDurations.size();
    }

    public MDLongArray getValues(HDF5TimeUnit targetUnit) {
        if (targetUnit == this.timeUnit) {
            return this.timeDurations;
        }
        long[] sourceDurations = this.timeDurations.getAsFlatArray();
        long[] targetDurations = new long[sourceDurations.length];
        int i = 0;
        while (i < targetDurations.length) {
            targetDurations[i] = targetUnit.convert(sourceDurations[i], this.timeUnit);
            ++i;
        }
        return new MDLongArray(targetDurations, this.timeDurations.dimensions());
    }

    public long[] getAsFlatArray(HDF5TimeUnit targetUnit) {
        return this.getValues(targetUnit).getAsFlatArray();
    }

    public HDF5TimeDuration get(HDF5TimeUnit targetUnit, int index) {
        if (targetUnit == this.timeUnit) {
            return new HDF5TimeDuration(this.timeDurations.get(index), this.timeUnit);
        }
        return new HDF5TimeDuration(targetUnit.convert(this.timeDurations.get(index), this.timeUnit), targetUnit);
    }

    public HDF5TimeDuration get(HDF5TimeUnit targetUnit, int indexX, int indexY) {
        if (targetUnit == this.timeUnit) {
            return new HDF5TimeDuration(this.timeDurations.get(indexX, indexY), this.timeUnit);
        }
        return new HDF5TimeDuration(targetUnit.convert(this.timeDurations.get(indexX, indexY), this.timeUnit), targetUnit);
    }

    public HDF5TimeDuration get(HDF5TimeUnit targetUnit, int indexX, int indexY, int indexZ) {
        if (targetUnit == this.timeUnit) {
            return new HDF5TimeDuration(this.timeDurations.get(indexX, indexY, indexZ), this.timeUnit);
        }
        return new HDF5TimeDuration(targetUnit.convert(this.timeDurations.get(indexX, indexY, indexZ), this.timeUnit), targetUnit);
    }

    public HDF5TimeDuration get(HDF5TimeUnit targetUnit, int ... indices) {
        if (targetUnit == this.timeUnit) {
            return new HDF5TimeDuration(this.timeDurations.get(indices), this.timeUnit);
        }
        return new HDF5TimeDuration(targetUnit.convert(this.timeDurations.get(indices), this.timeUnit), targetUnit);
    }

    public long getValue(int index) {
        return this.timeDurations.get(index);
    }

    public long getValue(int indexX, int indexY) {
        return this.timeDurations.get(indexX, indexY);
    }

    public long getValue(int indexX, int indexY, int indexZ) {
        return this.timeDurations.get(indexX, indexY, indexZ);
    }

    public long getValue(int ... indices) {
        return this.timeDurations.get(indices);
    }

    public long getValue(HDF5TimeUnit targetUnit, int index) {
        return targetUnit == this.timeUnit ? this.timeDurations.get(index) : targetUnit.convert(this.timeDurations.get(index), this.timeUnit);
    }

    public long getValue(HDF5TimeUnit targetUnit, int indexX, int indexY) {
        return targetUnit == this.timeUnit ? this.timeDurations.get(indexX, indexY) : targetUnit.convert(this.timeDurations.get(indexX, indexY), this.timeUnit);
    }

    public long getValue(HDF5TimeUnit targetUnit, int indexX, int indexY, int indexZ) {
        return targetUnit == this.timeUnit ? this.timeDurations.get(indexX, indexY, indexZ) : targetUnit.convert(this.timeDurations.get(indexX, indexY, indexZ), this.timeUnit);
    }

    public long getValue(HDF5TimeUnit targetUnit, int ... indices) {
        return targetUnit == this.timeUnit ? this.timeDurations.get(indices) : targetUnit.convert(this.timeDurations.get(indices), this.timeUnit);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.timeDurations.hashCode();
        result = 31 * result + (this.timeUnit == null ? 0 : this.timeUnit.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        HDF5TimeDurationMDArray other = (HDF5TimeDurationMDArray)((Object)obj);
        if (!this.timeDurations.equals((Object)other.timeDurations)) {
            return false;
        }
        return this.timeUnit == other.timeUnit;
    }

    public String toString() {
        return "HDF5TimeDurationArray [timeDurations=" + this.timeDurations.toString() + ", timeUnit=" + (Object)((Object)this.timeUnit) + "]";
    }

    public Long getAsObject(int linearIndex) {
        return this.timeDurations.getAsObject(linearIndex);
    }

    public Long getAsObject(int ... indices) {
        return this.timeDurations.getAsObject(indices);
    }

    public void setToObject(Long value, int ... indices) {
        this.timeDurations.setToObject(value, indices);
    }

    public void setToObject(Long value, int linearIndex) {
        this.timeDurations.setToObject(value, linearIndex);
    }

    public long[] getCopyAsFlatArray() {
        return this.timeDurations.getCopyAsFlatArray();
    }

    protected void adaptCapacityHyperRows() {
    }

    public int capacity() {
        return this.timeDurations.capacity();
    }

    public int incNumberOfHyperRows(int count) {
        return this.timeDurations.incNumberOfHyperRows(count);
    }

    public int rank() {
        return this.timeDurations.rank();
    }

    public int size(int dim) {
        return this.timeDurations.size(dim);
    }

    public int size() {
        return this.timeDurations.size();
    }

    public int numberOfHyperRows() {
        return this.timeDurations.numberOfHyperRows();
    }

    public int decNumberOfHyperRows(int count) {
        return this.timeDurations.decNumberOfHyperRows(count);
    }

    public int computeIndex(int ... indices) {
        return this.timeDurations.computeIndex(indices);
    }

    public int[] computeReverseIndex(int linearIndex) {
        return this.timeDurations.computeReverseIndex(linearIndex);
    }

    public int computeIndex(int indexX, int indexY) {
        return this.timeDurations.computeIndex(indexX, indexY);
    }

    public int computeIndex(int indexX, int indexY, int indexZ) {
        return this.timeDurations.computeIndex(indexX, indexY, indexZ);
    }

    public Iterator<MDAbstractArray.ArrayEntry> iterator() {
        return this.timeDurations.iterator();
    }

    public long get(int index) {
        return this.timeDurations.get(index);
    }

    public long get(int indexX, int indexY) {
        return this.timeDurations.get(indexX, indexY);
    }

    public long get(int indexX, int indexY, int indexZ) {
        return this.timeDurations.get(indexX, indexY, indexZ);
    }

    public long get(int ... indices) {
        return this.timeDurations.get(indices);
    }

    public void set(long value, int index) {
        this.timeDurations.set(value, index);
    }

    public void set(long value, int indexX, int indexY) {
        this.timeDurations.set(value, indexX, indexY);
    }

    public void set(long value, int indexX, int indexY, int indexZ) {
        this.timeDurations.set(value, indexX, indexY, indexZ);
    }

    public void set(long value, int ... indices) {
        this.timeDurations.set(value, indices);
    }

    public long[][] toMatrix() {
        return this.timeDurations.toMatrix();
    }
}

