/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.sybit.imageviewer.connectors;

import ch.systemsx.sybit.imageviewer.connectors.DataConnector;
import ch.systemsx.sybit.imageviewer.data.ImageHandler;
import ch.systemsx.sybit.imageviewer.data.ImageViewerParameters;
import ch.systemsx.sybit.imageviewer.data.MinMaxInChannel;
import ch.systemsx.sybit.imageviewer.gui.ImageViewer;
import ch.systemsx.sybit.imageviewer.processors.ImageUtil;
import ch.systemsx.sybit.imageviewer.utils.ImageViewerUtils;
import ij.ImagePlus;
import java.awt.EventQueue;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;

public class LocalSystemConnector
implements DataConnector {
    private ImageViewer imageViewer;
    private String[] files;
    private Thread loadingThread;

    public LocalSystemConnector(ImageViewer imageViewer, String[] files) {
        this.imageViewer = imageViewer;
        this.files = files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImageViewerParameters getParameters() throws Throwable {
        FileInputStream fileInputStream = null;
        Properties properties = new Properties();
        ImageViewerParameters imageViewerParameters = null;
        try {
            File file = new File("imageviewer.properties");
            if (!file.exists()) {
                file.createNewFile();
            }
            fileInputStream = new FileInputStream("imageviewer.properties");
            properties.load(fileInputStream);
            imageViewerParameters = new ImageViewerParameters();
            if (properties.containsKey("lut")) {
                imageViewerParameters.setLutOperation(properties.getProperty("lut"));
            } else {
                imageViewerParameters.setLutOperation("");
            }
            if (properties.containsKey("min")) {
                imageViewerParameters.setMin(Double.parseDouble(properties.getProperty("min")));
            } else {
                imageViewerParameters.setMin(0.0);
            }
            if (properties.containsKey("max")) {
                imageViewerParameters.setMax(Double.parseDouble(properties.getProperty("max")));
            } else {
                imageViewerParameters.setMax(255.0);
            }
            if (properties.containsKey("slice")) {
                imageViewerParameters.setSlice(Integer.parseInt(properties.getProperty("slice")));
            } else {
                imageViewerParameters.setSlice(1);
            }
            HashMap<Integer, MinMaxInChannel> minmax = new HashMap<Integer, MinMaxInChannel>();
            for (int i = 0; i < 3; ++i) {
                String param = String.valueOf(i + 1);
                if (properties.getProperty("min" + param) == null || properties.getProperty("max" + param) == null) continue;
                MinMaxInChannel minMaxInChannel = new MinMaxInChannel(Double.parseDouble(properties.getProperty("min" + param)), Double.parseDouble(properties.getProperty("max" + param)));
                minmax.put(i, minMaxInChannel);
            }
            imageViewerParameters.setMinMaxInChannels(minmax);
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return imageViewerParameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(ImageViewerParameters imageViewerParameters) throws Throwable {
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        Properties properties = new Properties();
        try {
            fileInputStream = new FileInputStream("imageviewer.properties");
            properties.load(fileInputStream);
            properties.remove("min1");
            properties.remove("min2");
            properties.remove("min3");
            properties.remove("max1");
            properties.remove("max2");
            properties.remove("max3");
            properties.setProperty("min", String.valueOf(imageViewerParameters.getMin()));
            properties.setProperty("max", String.valueOf(imageViewerParameters.getMax()));
            properties.setProperty("lut", imageViewerParameters.getLutOperation());
            properties.setProperty("slice", String.valueOf(imageViewerParameters.getSlice()));
            for (Integer key : imageViewerParameters.getMinMaxInChannels().keySet()) {
                int value = key + 1;
                properties.setProperty("min" + value, String.valueOf(imageViewerParameters.getMinMaxInChannels().get(key).getMin()));
                properties.setProperty("max" + value, String.valueOf(imageViewerParameters.getMinMaxInChannels().get(key).getMax()));
            }
            fileOutputStream = new FileOutputStream("imageviewer.properties");
            properties.store(fileOutputStream, "");
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void loadImages(String filter) throws Throwable {
        if (this.files != null && this.files.length > 0) {
            final ArrayList<String> filesToAdd = new ArrayList<String>();
            for (int i = 0; i < this.files.length; ++i) {
                File fileToInsert = new File(this.files[i]);
                if (fileToInsert.isDirectory()) {
                    List<File> filesInDirectory = ImageViewerUtils.listImagesInDirectory(fileToInsert, filter);
                    if (filesInDirectory == null) continue;
                    for (File fileInDirectory : filesInDirectory) {
                        filesToAdd.add(fileInDirectory.getAbsolutePath());
                    }
                    continue;
                }
                if (!fileToInsert.exists()) continue;
                filesToAdd.add(this.files[i]);
            }
            this.loadingThread = new Thread(new Runnable(){

                public void run() {
                    for (String fileToAdd : filesToAdd) {
                        ImagePlus imagePlus = ImageUtil.createScaledImagePlus(fileToAdd);
                        final ImageHandler imageHandler = new ImageHandler(imagePlus, null);
                        imageHandler.setPath(fileToAdd);
                        EventQueue.invokeLater(new Runnable(){

                            public void run() {
                                LocalSystemConnector.this.imageViewer.getImagesList().initList(imageHandler);
                            }
                        });
                    }
                }
            });
            this.loadingThread.start();
            if (filesToAdd.size() == 0) {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        LocalSystemConnector.this.imageViewer.cleanImage();
                        LocalSystemConnector.this.imageViewer.setImageName("No images found in specified path");
                    }
                });
            }
        }
    }

    public ImageHandler loadFullSizeImage(String path) {
        ImagePlus imagePlus = new ImagePlus(path);
        ImageHandler imageHandler = new ImageHandler(imagePlus, null);
        imageHandler.setPath(path);
        return imageHandler;
    }

    public String[] getFiles() {
        return this.files;
    }

    public void setFiles(String[] files) {
        this.files = files;
    }

    public void stopLoading() {
        if (this.loadingThread != null && this.loadingThread.isAlive() && !this.loadingThread.isInterrupted()) {
            this.loadingThread.interrupt();
        }
    }
}

