/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cifex.client.application;

import ch.systemsx.cisd.cifex.client.application.AbstractFileShareUserDialog;
import ch.systemsx.cisd.cifex.client.application.ViewContext;
import ch.systemsx.cisd.cifex.client.application.model.FileShareUserGridModel;
import ch.systemsx.cisd.cifex.client.application.utils.MessageDictionary;
import ch.systemsx.cisd.cifex.shared.basic.dto.UserInfoDTO;
import ch.systemsx.cisd.common.shared.basic.string.StringUtils;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.google.gwt.user.client.rpc.AsyncCallback;
import java.util.ArrayList;
import java.util.List;

public class FileShareUpdateUserDialog
extends AbstractFileShareUserDialog {
    private final List<String> usersToAdd = new ArrayList<String>();
    private final List<UserInfoDTO> initialSharingUsers;
    private final List<String> usersToRemove = new ArrayList<String>();
    private final AsyncCallback<Void> refreshCallback;
    private final long fileId;

    public FileShareUpdateUserDialog(ViewContext context, List<UserInfoDTO> existingUsers, List<UserInfoDTO> newUsers, String name, long fileId, AsyncCallback<Void> refreshCallback) {
        super(context, existingUsers, newUsers, name);
        this.initialSharingUsers = new ArrayList<UserInfoDTO>(existingUsers);
        this.refreshCallback = refreshCallback;
        this.createUpdateButton();
        this.fileId = fileId;
    }

    public FileShareUpdateUserDialog(ViewContext context, List<UserInfoDTO> existingUsers, String name, long fileId, AsyncCallback<Void> refreshCallback) {
        this(context, existingUsers, new ArrayList<UserInfoDTO>(), name, fileId, refreshCallback);
    }

    public FileShareUpdateUserDialog(ViewContext context, UserInfoDTO[] existingUsers, UserInfoDTO[] newUsers, String name, long fileId, AsyncCallback<Void> refreshCallback) {
        super(context, existingUsers, newUsers, name);
        this.initialSharingUsers = FileShareUpdateUserDialog.getArrayList(existingUsers);
        this.refreshCallback = refreshCallback;
        this.createUpdateButton();
        this.fileId = fileId;
    }

    @Override
    void checkboxChangeAction() {
        int i = 0;
        while (i < this.existingUsers.size()) {
            UserInfoDTO tmpUser = (UserInfoDTO)this.existingUsers.get(i);
            String userIdentifierWithPrefix = "id:" + tmpUser.getUserCode();
            String userIdentifier = ((UserInfoDTO)this.existingUsers.get(i)).getUserCode();
            if (!((Boolean)((FileShareUserGridModel)this.existingUserGrid.getGrid().getStore().getAt(i)).get("shareFile")).booleanValue()) {
                if (this.usersToAdd.contains(userIdentifierWithPrefix)) {
                    this.usersToAdd.remove(userIdentifierWithPrefix);
                } else if (!this.usersToRemove.contains(userIdentifier)) {
                    this.usersToRemove.add(userIdentifier);
                }
            } else {
                if (this.usersToRemove.contains(userIdentifier)) {
                    this.usersToRemove.remove(userIdentifier);
                }
                if (!this.initialSharingUsers.contains(tmpUser) && !this.usersToAdd.contains(userIdentifierWithPrefix)) {
                    this.usersToAdd.add(userIdentifierWithPrefix);
                }
            }
            ++i;
        }
        i = 0;
        while (i < this.newUsers.size()) {
            String userIdentifier = ((UserInfoDTO)this.newUsers.get(i)).getEmail();
            if (!((Boolean)((FileShareUserGridModel)this.newUserGrid.getGrid().getStore().getAt(i)).get("shareFile")).booleanValue()) {
                if (this.usersToAdd.contains(userIdentifier)) {
                    this.usersToAdd.remove(userIdentifier);
                }
            } else if (!this.usersToAdd.contains(userIdentifier)) {
                this.usersToAdd.add(userIdentifier);
            }
            ++i;
        }
    }

    @Override
    protected void addUserToFileShare(UserInfoDTO user) {
        if (!StringUtils.isBlank(user.getUserCode())) {
            this.usersToAdd.add("id:" + user.getUserCode());
        } else if (!StringUtils.isBlank(user.getEmail())) {
            this.usersToAdd.add(user.getEmail());
        }
    }

    private final void createUpdateButton() {
        Button button = new Button(MessageDictionary.msg(MessageDictionary.SHARE_FILE_SUBMIT_BUTTON_LABEL));
        this.addButton(button);
        button.addSelectionListener((SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent ce) {
                FileShareUpdateUserDialog.this.viewContext.getCifexService().updateSharingLinks(FileShareUpdateUserDialog.this.fileId, FileShareUpdateUserDialog.this.usersToAdd, FileShareUpdateUserDialog.this.usersToRemove, (AsyncCallback<Void>)FileShareUpdateUserDialog.this.refreshCallback);
                FileShareUpdateUserDialog.this.hide();
            }
        });
    }
}

