/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5;

import ch.systemsx.cisd.base.mdarray.MDArray;
import ch.systemsx.cisd.base.mdarray.MDLongArray;
import ch.systemsx.cisd.hdf5.HDF5BaseWriter;
import ch.systemsx.cisd.hdf5.HDF5DataTypeVariant;
import ch.systemsx.cisd.hdf5.HDF5DateTimeReader;
import ch.systemsx.cisd.hdf5.HDF5GenericStorageFeatures;
import ch.systemsx.cisd.hdf5.HDF5IntStorageFeatures;
import ch.systemsx.cisd.hdf5.HDF5LongReader;
import ch.systemsx.cisd.hdf5.IHDF5DateTimeWriter;
import ch.systemsx.cisd.hdf5.cleanup.ICallableWithCleanUp;
import ch.systemsx.cisd.hdf5.cleanup.ICleanUpRegistry;
import ch.systemsx.cisd.hdf5.hdf5lib.H5D;
import ch.systemsx.cisd.hdf5.hdf5lib.HDF5Constants;
import ch.systemsx.cisd.hdf5.hdf5lib.HDFNativeData;
import java.util.Date;

public class HDF5DateTimeWriter
extends HDF5DateTimeReader
implements IHDF5DateTimeWriter {
    private final HDF5BaseWriter baseWriter;

    HDF5DateTimeWriter(HDF5BaseWriter baseWriter, HDF5LongReader longReader) {
        super(baseWriter, longReader);
        assert (baseWriter != null);
        this.baseWriter = baseWriter;
    }

    @Override
    public void setAttr(String objectPath, String name, long timeStamp) {
        assert (objectPath != null);
        assert (name != null);
        this.baseWriter.checkOpen();
        this.baseWriter.setAttribute(objectPath, name, HDF5DataTypeVariant.TIMESTAMP_MILLISECONDS_SINCE_START_OF_THE_EPOCH, HDF5Constants.H5T_STD_I64LE, HDF5Constants.H5T_NATIVE_INT64, new long[]{timeStamp});
    }

    @Override
    public void setAttr(String objectPath, String name, Date date) {
        this.setAttr(objectPath, name, date.getTime());
    }

    @Override
    public void setArrayAttr(String objectPath, String name, Date[] dates) {
        this.setArrayAttr(objectPath, name, HDF5DateTimeWriter.datesToTimeStamps(dates));
    }

    @Override
    public void setArrayAttr(final String objectPath, final String name, final long[] timeStamps) {
        assert (objectPath != null);
        assert (name != null);
        assert (timeStamps != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> setAttributeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                int memoryTypeId = ((HDF5DateTimeWriter)HDF5DateTimeWriter.this).baseWriter.h5.createArrayType(HDF5Constants.H5T_NATIVE_INT64, timeStamps.length, registry);
                int storageTypeId = ((HDF5DateTimeWriter)HDF5DateTimeWriter.this).baseWriter.h5.createArrayType(HDF5Constants.H5T_STD_I64LE, timeStamps.length, registry);
                HDF5DateTimeWriter.this.baseWriter.setAttribute(objectPath, name, HDF5DataTypeVariant.TIMESTAMP_MILLISECONDS_SINCE_START_OF_THE_EPOCH, storageTypeId, memoryTypeId, timeStamps);
                return null;
            }
        };
        this.baseWriter.runner.call(setAttributeRunnable);
    }

    @Override
    public void setMDArrayAttr(final String objectPath, final String name, final MDLongArray value) {
        assert (objectPath != null);
        assert (name != null);
        assert (value != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> addAttributeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                int memoryTypeId = ((HDF5DateTimeWriter)HDF5DateTimeWriter.this).baseWriter.h5.createArrayType(HDF5Constants.H5T_NATIVE_INT64, value.dimensions(), registry);
                int storageTypeId = ((HDF5DateTimeWriter)HDF5DateTimeWriter.this).baseWriter.h5.createArrayType(HDF5Constants.H5T_STD_I64LE, value.dimensions(), registry);
                HDF5DateTimeWriter.this.baseWriter.setAttribute(objectPath, name, HDF5DataTypeVariant.TIMESTAMP_MILLISECONDS_SINCE_START_OF_THE_EPOCH, storageTypeId, memoryTypeId, value.getAsFlatArray());
                return null;
            }
        };
        this.baseWriter.runner.call(addAttributeRunnable);
    }

    @Override
    public void setMDArrayAttr(String objectPath, String name, MDArray<Date> value) {
        this.setMDArrayAttr(objectPath, name, HDF5DateTimeWriter.datesToTimeStamps(value));
    }

    @Override
    public void write(final String objectPath, final long timeStamp) {
        assert (objectPath != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Object> writeScalarRunnable = new ICallableWithCleanUp<Object>(){

            @Override
            public Object call(ICleanUpRegistry registry) {
                int dataSetId = HDF5DateTimeWriter.this.baseWriter.writeScalar(objectPath, HDF5Constants.H5T_STD_I64LE, HDF5Constants.H5T_NATIVE_INT64, HDFNativeData.longToByte(timeStamp), true, true, registry);
                HDF5DateTimeWriter.this.baseWriter.setTypeVariant(dataSetId, HDF5DataTypeVariant.TIMESTAMP_MILLISECONDS_SINCE_START_OF_THE_EPOCH, registry);
                return null;
            }
        };
        this.baseWriter.runner.call(writeScalarRunnable);
    }

    @Override
    public void createArray(String objectPath, int size) {
        this.createArray(objectPath, size, HDF5GenericStorageFeatures.GENERIC_NO_COMPRESSION);
    }

    @Override
    public void createArray(String objectPath, long size, int blockSize) {
        this.createArray(objectPath, size, blockSize, HDF5GenericStorageFeatures.GENERIC_NO_COMPRESSION);
    }

    @Override
    public void createArray(final String objectPath, final int size, final HDF5GenericStorageFeatures features) {
        assert (objectPath != null);
        assert (size >= 0);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> writeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                int dataSetId = features.requiresChunking() ? HDF5DateTimeWriter.this.baseWriter.createDataSet(objectPath, HDF5Constants.H5T_STD_I64LE, features, new long[1], new long[]{size}, 8, registry) : HDF5DateTimeWriter.this.baseWriter.createDataSet(objectPath, HDF5Constants.H5T_STD_I64LE, features, new long[]{size}, null, 8, registry);
                HDF5DateTimeWriter.this.baseWriter.setTypeVariant(dataSetId, HDF5DataTypeVariant.TIMESTAMP_MILLISECONDS_SINCE_START_OF_THE_EPOCH, registry);
                return null;
            }
        };
        this.baseWriter.runner.call(writeRunnable);
    }

    @Override
    public void createArray(final String objectPath, final long length, final int blockSize, final HDF5GenericStorageFeatures features) {
        assert (objectPath != null);
        assert (length >= 0L);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> writeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                int dataSetId = HDF5DateTimeWriter.this.baseWriter.createDataSet(objectPath, HDF5Constants.H5T_STD_I64LE, features, new long[]{length}, new long[]{blockSize}, 8, registry);
                HDF5DateTimeWriter.this.baseWriter.setTypeVariant(dataSetId, HDF5DataTypeVariant.TIMESTAMP_MILLISECONDS_SINCE_START_OF_THE_EPOCH, registry);
                return null;
            }
        };
        this.baseWriter.runner.call(writeRunnable);
    }

    @Override
    public void writeArray(String objectPath, long[] timeStamps) {
        this.writeArray(objectPath, timeStamps, HDF5GenericStorageFeatures.GENERIC_NO_COMPRESSION);
    }

    @Override
    public void writeArray(final String objectPath, final long[] timeStamps, final HDF5GenericStorageFeatures features) {
        assert (objectPath != null);
        assert (timeStamps != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> writeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                int dataSetId = HDF5DateTimeWriter.this.baseWriter.getOrCreateDataSetId(objectPath, HDF5Constants.H5T_STD_I64LE, new long[]{timeStamps.length}, 8, features, registry);
                H5D.H5Dwrite(dataSetId, HDF5Constants.H5T_NATIVE_INT64, HDF5Constants.H5S_ALL, HDF5Constants.H5S_ALL, HDF5Constants.H5P_DEFAULT, timeStamps);
                HDF5DateTimeWriter.this.baseWriter.setTypeVariant(dataSetId, HDF5DataTypeVariant.TIMESTAMP_MILLISECONDS_SINCE_START_OF_THE_EPOCH, registry);
                return null;
            }
        };
        this.baseWriter.runner.call(writeRunnable);
    }

    @Override
    public void writeArrayBlock(final String objectPath, final long[] data, final long blockNumber) {
        assert (objectPath != null);
        assert (data != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> writeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                long[] dimensions = new long[]{data.length};
                long[] slabStartOrNull = new long[]{(long)data.length * blockNumber};
                int dataSetId = ((HDF5DateTimeWriter)HDF5DateTimeWriter.this).baseWriter.h5.openAndExtendDataSet(((HDF5DateTimeWriter)HDF5DateTimeWriter.this).baseWriter.fileId, objectPath, ((HDF5DateTimeWriter)HDF5DateTimeWriter.this).baseWriter.fileFormat, new long[]{(long)data.length * (blockNumber + 1L)}, -1, registry);
                HDF5DateTimeWriter.this.baseWriter.checkIsTimeStamp(objectPath, dataSetId, registry);
                int dataSpaceId = ((HDF5DateTimeWriter)HDF5DateTimeWriter.this).baseWriter.h5.getDataSpaceForDataSet(dataSetId, registry);
                ((HDF5DateTimeWriter)HDF5DateTimeWriter.this).baseWriter.h5.setHyperslabBlock(dataSpaceId, slabStartOrNull, dimensions);
                int memorySpaceId = ((HDF5DateTimeWriter)HDF5DateTimeWriter.this).baseWriter.h5.createSimpleDataSpace(dimensions, registry);
                H5D.H5Dwrite(dataSetId, HDF5Constants.H5T_NATIVE_INT64, memorySpaceId, dataSpaceId, HDF5Constants.H5P_DEFAULT, data);
                return null;
            }
        };
        this.baseWriter.runner.call(writeRunnable);
    }

    @Override
    public void writeArrayBlockWithOffset(final String objectPath, final long[] data, final int dataSize, final long offset) {
        assert (objectPath != null);
        assert (data != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> writeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                long[] blockDimensions = new long[]{dataSize};
                long[] slabStartOrNull = new long[]{offset};
                int dataSetId = ((HDF5DateTimeWriter)HDF5DateTimeWriter.this).baseWriter.h5.openAndExtendDataSet(((HDF5DateTimeWriter)HDF5DateTimeWriter.this).baseWriter.fileId, objectPath, ((HDF5DateTimeWriter)HDF5DateTimeWriter.this).baseWriter.fileFormat, new long[]{offset + (long)dataSize}, -1, registry);
                HDF5DateTimeWriter.this.baseWriter.checkIsTimeStamp(objectPath, dataSetId, registry);
                int dataSpaceId = ((HDF5DateTimeWriter)HDF5DateTimeWriter.this).baseWriter.h5.getDataSpaceForDataSet(dataSetId, registry);
                ((HDF5DateTimeWriter)HDF5DateTimeWriter.this).baseWriter.h5.setHyperslabBlock(dataSpaceId, slabStartOrNull, blockDimensions);
                int memorySpaceId = ((HDF5DateTimeWriter)HDF5DateTimeWriter.this).baseWriter.h5.createSimpleDataSpace(blockDimensions, registry);
                H5D.H5Dwrite(dataSetId, HDF5Constants.H5T_NATIVE_INT64, memorySpaceId, dataSpaceId, HDF5Constants.H5P_DEFAULT, data);
                return null;
            }
        };
        this.baseWriter.runner.call(writeRunnable);
    }

    @Override
    public void write(String objectPath, Date date) {
        this.write(objectPath, date.getTime());
    }

    @Override
    public void writeArray(String objectPath, Date[] dates) {
        this.writeArray(objectPath, HDF5DateTimeWriter.datesToTimeStamps(dates));
    }

    @Override
    public void writeArray(String objectPath, Date[] dates, HDF5GenericStorageFeatures features) {
        this.writeArray(objectPath, HDF5DateTimeWriter.datesToTimeStamps(dates), features);
    }

    @Override
    public void writeMDArray(final String objectPath, final MDLongArray data, final HDF5IntStorageFeatures features) {
        assert (objectPath != null);
        assert (data != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> writeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                int dataSetId = HDF5DateTimeWriter.this.baseWriter.getOrCreateDataSetId(objectPath, features.isSigned() ? HDF5Constants.H5T_STD_I64LE : HDF5Constants.H5T_STD_U64LE, data.longDimensions(), 8, features, registry);
                H5D.H5Dwrite(dataSetId, HDF5Constants.H5T_NATIVE_INT64, HDF5Constants.H5S_ALL, HDF5Constants.H5S_ALL, HDF5Constants.H5P_DEFAULT, data.getAsFlatArray());
                HDF5DateTimeWriter.this.baseWriter.setTypeVariant(dataSetId, HDF5DataTypeVariant.TIMESTAMP_MILLISECONDS_SINCE_START_OF_THE_EPOCH, registry);
                return null;
            }
        };
        this.baseWriter.runner.call(writeRunnable);
    }

    @Override
    public void createMDArray(String objectPath, int[] dimensions) {
        this.createMDArray(objectPath, dimensions, HDF5IntStorageFeatures.INT_NO_COMPRESSION);
    }

    @Override
    public void createMDArray(String objectPath, long[] dimensions, int[] blockDimensions) {
        this.createMDArray(objectPath, dimensions, blockDimensions, HDF5IntStorageFeatures.INT_NO_COMPRESSION);
    }

    @Override
    public void createMDArray(final String objectPath, final int[] dimensions, final HDF5IntStorageFeatures features) {
        assert (objectPath != null);
        assert (dimensions != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> createRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                int dataSetId;
                if (features.requiresChunking()) {
                    long[] nullDimensions = new long[dimensions.length];
                    dataSetId = HDF5DateTimeWriter.this.baseWriter.createDataSet(objectPath, features.isSigned() ? HDF5Constants.H5T_STD_I64LE : HDF5Constants.H5T_STD_U64LE, features, nullDimensions, MDArray.toLong((int[])dimensions), 8, registry);
                } else {
                    dataSetId = HDF5DateTimeWriter.this.baseWriter.createDataSet(objectPath, features.isSigned() ? HDF5Constants.H5T_STD_I64LE : HDF5Constants.H5T_STD_U64LE, features, MDArray.toLong((int[])dimensions), null, 8, registry);
                }
                HDF5DateTimeWriter.this.baseWriter.setTypeVariant(dataSetId, HDF5DataTypeVariant.TIMESTAMP_MILLISECONDS_SINCE_START_OF_THE_EPOCH, registry);
                return null;
            }
        };
        this.baseWriter.runner.call(createRunnable);
    }

    @Override
    public void createMDArray(final String objectPath, final long[] dimensions, final int[] blockDimensions, final HDF5IntStorageFeatures features) {
        assert (objectPath != null);
        assert (dimensions != null);
        assert (blockDimensions != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> createRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                int dataSetId = HDF5DateTimeWriter.this.baseWriter.createDataSet(objectPath, features.isSigned() ? HDF5Constants.H5T_STD_I64LE : HDF5Constants.H5T_STD_U64LE, features, dimensions, MDArray.toLong((int[])blockDimensions), 8, registry);
                HDF5DateTimeWriter.this.baseWriter.setTypeVariant(dataSetId, HDF5DataTypeVariant.TIMESTAMP_MILLISECONDS_SINCE_START_OF_THE_EPOCH, registry);
                return null;
            }
        };
        this.baseWriter.runner.call(createRunnable);
    }

    @Override
    public void writeMDArrayBlock(String objectPath, MDLongArray data, long[] blockNumber) {
        assert (blockNumber != null);
        long[] dimensions = data.longDimensions();
        long[] offset = new long[dimensions.length];
        int i = 0;
        while (i < offset.length) {
            offset[i] = blockNumber[i] * dimensions[i];
            ++i;
        }
        this.writeMDArrayBlockWithOffset(objectPath, data, offset);
    }

    @Override
    public void writeMDArrayBlockWithOffset(final String objectPath, final MDLongArray data, final long[] offset) {
        assert (objectPath != null);
        assert (data != null);
        assert (offset != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> writeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                long[] dimensions = data.longDimensions();
                if (!$assertionsDisabled && dimensions.length != offset.length) {
                    throw new AssertionError();
                }
                long[] dataSetDimensions = new long[dimensions.length];
                int i = 0;
                while (i < offset.length) {
                    dataSetDimensions[i] = offset[i] + dimensions[i];
                    ++i;
                }
                int dataSetId = ((HDF5DateTimeWriter)HDF5DateTimeWriter.this).baseWriter.h5.openAndExtendDataSet(((HDF5DateTimeWriter)HDF5DateTimeWriter.this).baseWriter.fileId, objectPath, ((HDF5DateTimeWriter)HDF5DateTimeWriter.this).baseWriter.fileFormat, dataSetDimensions, -1, registry);
                int dataSpaceId = ((HDF5DateTimeWriter)HDF5DateTimeWriter.this).baseWriter.h5.getDataSpaceForDataSet(dataSetId, registry);
                ((HDF5DateTimeWriter)HDF5DateTimeWriter.this).baseWriter.h5.setHyperslabBlock(dataSpaceId, offset, dimensions);
                int memorySpaceId = ((HDF5DateTimeWriter)HDF5DateTimeWriter.this).baseWriter.h5.createSimpleDataSpace(dimensions, registry);
                H5D.H5Dwrite(dataSetId, HDF5Constants.H5T_NATIVE_INT64, memorySpaceId, dataSpaceId, HDF5Constants.H5P_DEFAULT, data.getAsFlatArray());
                HDF5DateTimeWriter.this.baseWriter.setTypeVariant(dataSetId, HDF5DataTypeVariant.TIMESTAMP_MILLISECONDS_SINCE_START_OF_THE_EPOCH, registry);
                return null;
            }
        };
        this.baseWriter.runner.call(writeRunnable);
    }

    @Override
    public void writeMDArrayBlockWithOffset(final String objectPath, final MDLongArray data, final int[] blockDimensions, final long[] offset, final int[] memoryOffset) {
        assert (objectPath != null);
        assert (data != null);
        assert (offset != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> writeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                long[] memoryDimensions = data.longDimensions();
                if (!$assertionsDisabled && memoryDimensions.length != offset.length) {
                    throw new AssertionError();
                }
                long[] longBlockDimensions = MDArray.toLong((int[])blockDimensions);
                if (!$assertionsDisabled && longBlockDimensions.length != offset.length) {
                    throw new AssertionError();
                }
                long[] dataSetDimensions = new long[blockDimensions.length];
                int i = 0;
                while (i < offset.length) {
                    dataSetDimensions[i] = offset[i] + (long)blockDimensions[i];
                    ++i;
                }
                int dataSetId = ((HDF5DateTimeWriter)HDF5DateTimeWriter.this).baseWriter.h5.openAndExtendDataSet(((HDF5DateTimeWriter)HDF5DateTimeWriter.this).baseWriter.fileId, objectPath, ((HDF5DateTimeWriter)HDF5DateTimeWriter.this).baseWriter.fileFormat, dataSetDimensions, -1, registry);
                int dataSpaceId = ((HDF5DateTimeWriter)HDF5DateTimeWriter.this).baseWriter.h5.getDataSpaceForDataSet(dataSetId, registry);
                ((HDF5DateTimeWriter)HDF5DateTimeWriter.this).baseWriter.h5.setHyperslabBlock(dataSpaceId, offset, longBlockDimensions);
                int memorySpaceId = ((HDF5DateTimeWriter)HDF5DateTimeWriter.this).baseWriter.h5.createSimpleDataSpace(memoryDimensions, registry);
                ((HDF5DateTimeWriter)HDF5DateTimeWriter.this).baseWriter.h5.setHyperslabBlock(memorySpaceId, MDArray.toLong((int[])memoryOffset), longBlockDimensions);
                H5D.H5Dwrite(dataSetId, HDF5Constants.H5T_NATIVE_INT64, memorySpaceId, dataSpaceId, HDF5Constants.H5P_DEFAULT, data.getAsFlatArray());
                HDF5DateTimeWriter.this.baseWriter.setTypeVariant(dataSetId, HDF5DataTypeVariant.TIMESTAMP_MILLISECONDS_SINCE_START_OF_THE_EPOCH, registry);
                return null;
            }
        };
        this.baseWriter.runner.call(writeRunnable);
    }

    @Override
    public void writeMDArray(String objectPath, MDArray<Date> data, HDF5IntStorageFeatures features) {
        this.writeMDArray(objectPath, HDF5DateTimeWriter.datesToTimeStamps(data), features);
    }

    @Override
    public void writeMDArrayBlock(String objectPath, MDArray<Date> data, long[] blockNumber) {
        this.writeMDArrayBlock(objectPath, HDF5DateTimeWriter.datesToTimeStamps(data), blockNumber);
    }

    @Override
    public void writeMDArrayBlockWithOffset(String objectPath, MDArray<Date> data, int[] blockDimensions, long[] offset, int[] memoryOffset) {
        this.writeMDArrayBlockWithOffset(objectPath, HDF5DateTimeWriter.datesToTimeStamps(data), offset);
    }

    private static long[] datesToTimeStamps(Date[] dates) {
        assert (dates != null);
        long[] timestamps = new long[dates.length];
        int i = 0;
        while (i < timestamps.length) {
            timestamps[i] = dates[i].getTime();
            ++i;
        }
        return timestamps;
    }

    private static MDLongArray datesToTimeStamps(MDArray<Date> dates) {
        assert (dates != null);
        Date[] datesFlat = (Date[])dates.getAsFlatArray();
        MDLongArray timestamps = new MDLongArray(dates.dimensions());
        long[] timestampsFlat = timestamps.getAsFlatArray();
        int i = 0;
        while (i < timestampsFlat.length) {
            timestampsFlat[i] = datesFlat[i].getTime();
            ++i;
        }
        return timestamps;
    }
}

