/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5.h5ar;

import ch.systemsx.cisd.base.exceptions.IErrorStrategy;
import ch.systemsx.cisd.base.exceptions.IOExceptionUnchecked;
import ch.systemsx.cisd.hdf5.IHDF5Reader;
import ch.systemsx.cisd.hdf5.h5ar.DirectoryIndex;
import ch.systemsx.cisd.hdf5.h5ar.IDirectoryIndex;
import ch.systemsx.cisd.hdf5.h5ar.IDirectoryIndexProvider;
import java.util.HashMap;
import java.util.Map;

class DirectoryIndexProvider
implements IDirectoryIndexProvider {
    private final Map<String, DirectoryIndex> cacheMap = new HashMap<String, DirectoryIndex>();
    private final IHDF5Reader reader;
    private final IErrorStrategy errorStrategy;

    DirectoryIndexProvider(IHDF5Reader reader, IErrorStrategy errorStrategy) {
        this.reader = reader;
        this.errorStrategy = errorStrategy;
    }

    @Override
    public IDirectoryIndex get(String normalizedGroupPath, boolean withLinkTargets) {
        String nonEmptyGroupPath = normalizedGroupPath.length() == 0 ? "/" : normalizedGroupPath;
        DirectoryIndex index = this.cacheMap.get(nonEmptyGroupPath);
        if (index == null) {
            index = new DirectoryIndex(this.reader, nonEmptyGroupPath, this.errorStrategy, withLinkTargets);
            this.cacheMap.put(nonEmptyGroupPath, index);
        } else if (withLinkTargets) {
            index.amendLinkTargets();
        }
        return index;
    }

    @Override
    public IErrorStrategy getErrorStrategy() {
        return this.errorStrategy;
    }

    @Override
    public void close() throws IOExceptionUnchecked {
        IOExceptionUnchecked exeptionOrNull = null;
        for (DirectoryIndex index : this.cacheMap.values()) {
            try {
                index.close();
            }
            catch (IOExceptionUnchecked ex) {
                if (exeptionOrNull != null) continue;
                exeptionOrNull = ex;
            }
        }
        if (exeptionOrNull != null) {
            throw exeptionOrNull;
        }
    }
}

