/*
 * Decompiled with CFR 0.152.
 */
package loci.common;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import loci.common.StreamHandle;

public class URLHandle
extends StreamHandle {
    private String url;
    private URLConnection conn;

    public URLHandle(String url) throws IOException {
        if (!url.startsWith("http") && !url.startsWith("file:")) {
            url = "http://" + url;
        }
        this.url = url;
        this.resetStream();
    }

    public void seek(long pos) throws IOException {
        if (pos < this.fp && pos >= this.mark) {
            this.stream.reset();
            this.fp = this.mark;
            this.skip(pos - this.fp);
        } else {
            super.seek(pos);
        }
    }

    protected void resetStream() throws IOException {
        this.conn = new URL(this.url).openConnection();
        this.stream = new DataInputStream(new BufferedInputStream(this.conn.getInputStream(), 0x100000));
        this.fp = 0L;
        this.mark = 0L;
        this.length = this.conn.getContentLength();
        if (this.stream != null) {
            this.stream.mark(0x100000);
        }
    }

    private void skip(long bytes) throws IOException {
        int n;
        while (bytes >= Integer.MAX_VALUE) {
            bytes -= (long)this.skipBytes(Integer.MAX_VALUE);
        }
        int skipped = this.skipBytes((int)bytes);
        while ((long)skipped < bytes && (n = this.skipBytes((int)(bytes - (long)skipped))) != 0) {
            skipped += n;
        }
    }
}

