/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.openbis.dss.generic.server.IStreamRepository;
import ch.systemsx.cisd.openbis.dss.generic.server.InputStreamWithPath;
import ch.systemsx.cisd.openbis.dss.generic.server.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.web.context.WebApplicationContext;

public class IdentifiedStreamHandlingServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    public static final String SERVLET_NAME = "stream-content";
    public static final String STREAM_REPOSITORY_BEAN_ID = "stream-repository";
    public static final String STREAM_ID_PARAMETER_KEY = "streamID";
    protected static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, IdentifiedStreamHandlingServlet.class);
    private IStreamRepository streamRepository;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        ServletContext context = servletConfig.getServletContext();
        BeanFactory applicationContext = (BeanFactory)context.getAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE);
        this.streamRepository = (IStreamRepository)applicationContext.getBean(STREAM_REPOSITORY_BEAN_ID);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String path;
        String streamID = req.getParameter(STREAM_ID_PARAMETER_KEY);
        InputStreamWithPath streamWithPath = this.streamRepository.getStream(streamID);
        String fileName = path = streamWithPath.getPath();
        int indexOfLastSeparator = path.lastIndexOf(47);
        if (indexOfLastSeparator >= 0) {
            fileName = path.substring(indexOfLastSeparator + 1);
        }
        resp.setHeader("Content-Disposition", "inline; filename=" + fileName);
        resp.setContentType(Utils.getMimeType(fileName, true));
        InputStream stream = streamWithPath.getInputStream();
        ServletOutputStream outputStream = resp.getOutputStream();
        try {
            IOUtils.copyLarge((InputStream)stream, (OutputStream)outputStream);
        }
        finally {
            IOUtils.closeQuietly((InputStream)stream);
            IOUtils.closeQuietly((OutputStream)outputStream);
        }
    }
}

