/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.business.bo;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.server.business.bo.AbstractBusinessObject;
import ch.systemsx.cisd.openbis.generic.server.business.bo.IAuthorizationGroupBO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AuthorizationGroupUpdates;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewAuthorizationGroup;
import ch.systemsx.cisd.openbis.generic.shared.dto.AuthorizationGroupPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatabaseInstancePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.EventPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.EventType;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.Session;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.IManagedPropertyEvaluatorFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataRetrievalFailureException;

public class AuthorizationGroupBO
extends AbstractBusinessObject
implements IAuthorizationGroupBO {
    private final IAuthorizationGroupFactory groupFactory;
    private AuthorizationGroupPE authorizationGroup;
    private boolean dataChanged;

    @Private
    AuthorizationGroupBO(IDAOFactory daoFactory, Session session, IAuthorizationGroupFactory factory, IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory) {
        super(daoFactory, session, managedPropertyEvaluatorFactory);
        this.groupFactory = factory;
    }

    public AuthorizationGroupBO(IDAOFactory daoFactory, Session session, IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory) {
        this(daoFactory, session, new AuthorizationGroupFactory(), managedPropertyEvaluatorFactory);
    }

    @Override
    public void define(NewAuthorizationGroup newAuthorizationGroup) throws UserFailureException {
        assert (newAuthorizationGroup != null) : "Undefined new authorization group";
        assert (this.authorizationGroup == null) : "Authorization group already defined";
        this.authorizationGroup = this.groupFactory.create(newAuthorizationGroup, this.findPerson(), this.getHomeDatabaseInstance());
        this.dataChanged = true;
    }

    @Override
    public void save() throws UserFailureException {
        assert (this.authorizationGroup != null) : "Authorization group not loaded.";
        if (this.dataChanged) {
            try {
                this.getAuthorizationGroupDAO().create(this.authorizationGroup);
            }
            catch (DataAccessException ex) {
                AuthorizationGroupBO.throwException(ex, String.format("Authorization group '%s'", this.authorizationGroup.getCode()));
            }
            this.dataChanged = false;
        }
    }

    @Override
    public void deleteByTechId(TechId authGroupId, String reason) {
        this.loadByTechId(authGroupId);
        String code = this.authorizationGroup.getCode();
        try {
            this.getAuthorizationGroupDAO().delete(this.authorizationGroup);
            this.getEventDAO().persist(AuthorizationGroupBO.createDeletionEvent(code, this.session.tryGetPerson(), reason));
        }
        catch (DataAccessException ex) {
            AuthorizationGroupBO.throwException(ex, String.format("Authorization group '%s'", code));
        }
    }

    @Override
    public void loadByTechId(TechId techId) {
        try {
            this.authorizationGroup = (AuthorizationGroupPE)this.getAuthorizationGroupDAO().getByTechId(techId);
        }
        catch (DataRetrievalFailureException dataRetrievalFailureException) {
            throw new UserFailureException(String.format("Authorization group with ID '%s' does not exist.", techId));
        }
        this.dataChanged = false;
    }

    public static EventPE createDeletionEvent(String groupCode, PersonPE registrator, String reason) {
        EventPE event = new EventPE();
        event.setEventType(EventType.DELETION);
        event.setEntityType(EventPE.EntityType.AUTHORIZATION_GROUP);
        event.setIdentifiers(Collections.singletonList(groupCode));
        event.setDescription(groupCode);
        event.setReason(reason);
        event.setRegistrator(registrator);
        return event;
    }

    @Override
    public AuthorizationGroupPE getAuthorizationGroup() {
        return this.authorizationGroup;
    }

    @Override
    public void update(AuthorizationGroupUpdates updates) {
        this.loadByTechId(updates.getId());
        if (!this.authorizationGroup.getModificationDate().equals(updates.getVersion())) {
            AuthorizationGroupBO.throwModifiedEntityException("User group");
        }
        this.authorizationGroup.setDescription(updates.getDescription());
        this.dataChanged = true;
    }

    @Override
    public List<String> addPersons(List<String> personsCodes) {
        assert (this.authorizationGroup != null) : "Not initialized";
        ArrayList<String> inexistent = new ArrayList<String>(personsCodes);
        List<PersonPE> users = this.getPersonDAO().listByCodes(personsCodes);
        for (PersonPE person : users) {
            inexistent.remove(person.getUserId());
            if (!person.isActive()) continue;
            this.authorizationGroup.addPerson(person);
        }
        return inexistent;
    }

    @Override
    public void removePersons(List<String> personsCodes) {
        assert (this.authorizationGroup != null) : "Not initialized";
        List<PersonPE> users = this.getPersonDAO().listByCodes(personsCodes);
        for (PersonPE person : users) {
            this.authorizationGroup.removePerson(person);
        }
    }

    @Private
    static class AuthorizationGroupFactory
    implements IAuthorizationGroupFactory {
        AuthorizationGroupFactory() {
        }

        @Override
        public AuthorizationGroupPE create(NewAuthorizationGroup newAuthorizationGroup, PersonPE registrator, DatabaseInstancePE homeDBInstance) {
            AuthorizationGroupPE authorizationGroup = new AuthorizationGroupPE();
            authorizationGroup.setCode(newAuthorizationGroup.getCode());
            authorizationGroup.setDescription(newAuthorizationGroup.getDescription());
            authorizationGroup.setDatabaseInstance(homeDBInstance);
            authorizationGroup.setRegistrator(registrator);
            return authorizationGroup;
        }
    }

    static interface IAuthorizationGroupFactory {
        public AuthorizationGroupPE create(NewAuthorizationGroup var1, PersonPE var2, DatabaseInstancePE var3);
    }
}

