/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.dataaccess.db.search.detailed;

import ch.systemsx.cisd.common.exceptions.InternalErr;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.MetaprojectSearch;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.search.LuceneQueryBuilder;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.search.detailed.IndexFieldNameHelper;
import ch.systemsx.cisd.openbis.generic.shared.basic.AttributeSearchFieldKindProvider;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DetailedSearchAssociationCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DetailedSearchCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DetailedSearchCriterion;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DetailedSearchField;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DetailedSearchFieldKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IAttributeSearchFieldKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SearchCriteriaConnection;
import ch.systemsx.cisd.openbis.generic.shared.search.IgnoreCaseAnalyzer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.TimeZone;
import org.apache.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermRangeQuery;
import org.hibernate.search.annotations.Resolution;
import org.hibernate.search.bridge.builtin.DateBridge;

public class DetailedQueryBuilder {
    private static final String[] DATE_FORMATS = new String[]{"y-M-d HH:mm:ss", "y-M-d HH:mm", "y-M-d"};
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, DetailedQueryBuilder.class);
    private final EntityKind entityKind;
    private static final EnumSet<DetailedSearchFieldKind> simpleFieldKinds = EnumSet.of(DetailedSearchFieldKind.ATTRIBUTE, DetailedSearchFieldKind.PROPERTY);

    public static Query createQuery(String userId, DetailedSearchCriteria searchCriteria, EntityKind entityKind, List<DetailedSearchAssociationCriteria> associations) throws UserFailureException {
        DetailedQueryBuilder builder = new DetailedQueryBuilder(entityKind);
        Query resultQuery = builder.createQuery(userId, searchCriteria, associations);
        operationLog.debug((Object)("Lucene detailed query: " + resultQuery.toString()));
        return resultQuery;
    }

    private DetailedQueryBuilder(EntityKind entityKind) {
        this.entityKind = entityKind;
    }

    private Query createQuery(String userId, DetailedSearchCriteria searchCriteria, List<DetailedSearchAssociationCriteria> associations) {
        boolean useWildcardSearchMode = searchCriteria.isUseWildcardSearchMode();
        List<DetailedSearchCriterion> criteria = searchCriteria.getCriteria();
        BooleanClause.Occur occureCondition = this.createOccureCondition(searchCriteria.getConnection());
        Analyzer searchAnalyzer = LuceneQueryBuilder.createSearchAnalyzer();
        BooleanQuery resultQuery = new BooleanQuery();
        for (DetailedSearchCriterion criterion : criteria) {
            List<String> fieldNames = this.getIndexFieldNames(criterion.getField());
            if (criterion.getTimeZone() == null) {
                ArrayList<String> fieldPatterns = new ArrayList<String>(fieldNames.size());
                ArrayList<Analyzer> fieldAnalyzers = new ArrayList<Analyzer>(fieldNames.size());
                for (String fieldName : fieldNames) {
                    String fieldPattern = null;
                    Analyzer fieldAnalyzer = null;
                    if (MetaprojectSearch.isMetaprojectField(fieldName)) {
                        String fieldUserQuery = MetaprojectSearch.getMetaprojectUserQuery(criterion.getValue(), userId);
                        fieldPattern = LuceneQueryBuilder.adaptQuery(fieldUserQuery, useWildcardSearchMode, false);
                        fieldAnalyzer = new IgnoreCaseAnalyzer();
                    } else {
                        fieldPattern = LuceneQueryBuilder.adaptQuery(criterion.getValue(), useWildcardSearchMode);
                        fieldAnalyzer = searchAnalyzer;
                    }
                    fieldPatterns.add(fieldPattern);
                    fieldAnalyzers.add(fieldAnalyzer);
                }
                Query luceneQuery = LuceneQueryBuilder.parseQuery(fieldNames, fieldPatterns, fieldAnalyzers);
                resultQuery.add(luceneQuery, occureCondition);
                continue;
            }
            Date lower = this.parseDate(criterion.getValue());
            int offset = this.getTimeZoneOffset(criterion, lower);
            lower.setTime(lower.getTime() + (long)offset);
            Date upper = new Date(lower.getTime() + 86400000L);
            switch (criterion.getType()) {
                case EQUALS: {
                    break;
                }
                case LESS_THAN_OR_EQUAL: {
                    lower = new Date(0L);
                    break;
                }
                case MORE_THAN_OR_EQUAL: {
                    upper = new Date(Long.MAX_VALUE);
                }
            }
            String fieldName = fieldNames.get(0);
            DateBridge bridge = new DateBridge(Resolution.SECOND);
            TermRangeQuery q = new TermRangeQuery(fieldName, bridge.objectToString((Object)lower), bridge.objectToString((Object)upper), true, true);
            resultQuery.add((Query)q, occureCondition);
        }
        for (DetailedSearchAssociationCriteria association : associations) {
            String fieldName = this.getIndexFieldName(association);
            List<String> searchPatterns = this.extractAssociationPatterns(association);
            Query luceneQuery = LuceneQueryBuilder.parseQuery(fieldName, searchPatterns, searchAnalyzer);
            resultQuery.add(luceneQuery, occureCondition);
        }
        return resultQuery;
    }

    private int getTimeZoneOffset(DetailedSearchCriterion criterion, Date lower) {
        int offset;
        String tzs = criterion.getTimeZone();
        if (tzs.equals("server")) {
            return -TimeZone.getDefault().getOffset(lower.getTime());
        }
        if (tzs.startsWith("+")) {
            tzs = tzs.substring(1);
        } else if (tzs.equals("Z")) {
            tzs = "0";
        }
        try {
            offset = (int)(-Double.parseDouble(tzs) * 3600000.0);
        }
        catch (NumberFormatException numberFormatException) {
            offset = 0;
        }
        return offset;
    }

    private Date parseDate(String dateAsString) {
        String[] stringArray = DATE_FORMATS;
        int n = DATE_FORMATS.length;
        int n2 = 0;
        while (n2 < n) {
            String format = stringArray[n2];
            SimpleDateFormat sdf = new SimpleDateFormat(format);
            sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
            try {
                return sdf.parse(dateAsString);
            }
            catch (ParseException parseException) {
                ++n2;
            }
        }
        throw new UserFailureException("Couldn't parse date '" + dateAsString + "'. It has to match one of the following formats: " + Arrays.asList(DATE_FORMATS));
    }

    private List<String> extractAssociationPatterns(DetailedSearchAssociationCriteria association) {
        ArrayList<String> result = new ArrayList<String>();
        for (Long id : association.getIds()) {
            result.add(id.toString());
        }
        return result;
    }

    private BooleanClause.Occur createOccureCondition(SearchCriteriaConnection connection) {
        switch (connection) {
            case MATCH_ALL: {
                return BooleanClause.Occur.MUST;
            }
            case MATCH_ANY: {
                return BooleanClause.Occur.SHOULD;
            }
        }
        throw InternalErr.error("unknown enum " + connection);
    }

    private List<String> getIndexFieldNames(DetailedSearchField searchField) {
        DetailedSearchFieldKind fieldKind = searchField.getKind();
        switch (fieldKind) {
            case ANY_PROPERTY: {
                return this.getPropertyIndexFields(searchField);
            }
            case ANY_FIELD: {
                ArrayList<String> fields = new ArrayList<String>();
                fields.addAll(this.getPropertyIndexFields(searchField));
                fields.addAll(this.getAllAttributeIndexFieldNames());
                return fields;
            }
            case REGISTRATOR: {
                return Arrays.asList("registrator User Id");
            }
        }
        return Arrays.asList(this.getSimpleFieldIndexName(searchField));
    }

    private String getIndexFieldName(DetailedSearchAssociationCriteria association) {
        return IndexFieldNameHelper.getAssociationIndexField(this.entityKind, association.getEntityKind());
    }

    private String getSimpleFieldIndexName(DetailedSearchField searchField) {
        assert (simpleFieldKinds.contains(searchField.getKind())) : "simple field kind required";
        String indexFieldName = this.tryGetIndexFieldName(searchField);
        assert (indexFieldName != null);
        return indexFieldName;
    }

    private List<String> getAllAttributeIndexFieldNames() {
        IAttributeSearchFieldKind[] attributeFieldKinds;
        ArrayList<String> indexFieldNames = new ArrayList<String>();
        IAttributeSearchFieldKind[] iAttributeSearchFieldKindArray = attributeFieldKinds = DetailedQueryBuilder.getAllAttributeFieldKinds(this.entityKind);
        int n = attributeFieldKinds.length;
        int n2 = 0;
        while (n2 < n) {
            IAttributeSearchFieldKind attributeFieldKind = iAttributeSearchFieldKindArray[n2];
            DetailedSearchField attributeField = DetailedSearchField.createAttributeField(attributeFieldKind);
            indexFieldNames.add(this.getSimpleFieldIndexName(attributeField));
            ++n2;
        }
        return indexFieldNames;
    }

    private static IAttributeSearchFieldKind[] getAllAttributeFieldKinds(EntityKind entityKind) {
        return AttributeSearchFieldKindProvider.getAllAttributeFieldKinds(entityKind);
    }

    private List<String> getPropertyIndexFields(DetailedSearchField searchField) {
        assert (searchField.getKind() != DetailedSearchFieldKind.ATTRIBUTE) : "attribute field kind not allowed";
        return this.getPropertyIndexFieldNames(searchField.getAllEntityPropertyCodesOrNull());
    }

    private List<String> getPropertyIndexFieldNames(List<String> allPropertyCodes) {
        ArrayList<String> indexFieldNames = new ArrayList<String>();
        assert (allPropertyCodes != null);
        for (String propertyCode : allPropertyCodes) {
            DetailedSearchField searchField = DetailedSearchField.createPropertyField(propertyCode);
            String indexFieldName = this.tryGetIndexFieldName(searchField);
            assert (indexFieldName != null);
            indexFieldNames.add(indexFieldName);
        }
        return indexFieldNames;
    }

    private String tryGetIndexFieldName(DetailedSearchField searchField) {
        DetailedSearchFieldKind fieldKind = searchField.getKind();
        switch (fieldKind) {
            case ATTRIBUTE: {
                return IndexFieldNameHelper.getAttributeIndexField(this.entityKind, searchField.getAttributeCode());
            }
            case PROPERTY: {
                return IndexFieldNameHelper.getPropertyIndexField(searchField.getPropertyCode());
            }
            case ANY_FIELD: 
            case ANY_PROPERTY: {
                return null;
            }
        }
        throw InternalErr.error("unknown enum " + fieldKind);
    }
}

