/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.proteomics.client.web.client.application;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.TypedTableGrid;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.IDisposableComponent;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.DefaultResultSetConfig;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.TableExportCriteria;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.TypedTableResultSet;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseModificationKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelRowWithObject;
import ch.systemsx.cisd.openbis.plugin.proteomics.client.web.client.IPhosphoNetXClientServiceAsync;
import ch.systemsx.cisd.openbis.plugin.proteomics.client.web.client.application.PhosphoNetXDisplayTypeIDGenerator;
import ch.systemsx.cisd.openbis.plugin.proteomics.client.web.client.dto.ListProteinSummaryByExperimentCriteria;
import ch.systemsx.cisd.openbis.plugin.proteomics.shared.basic.dto.ProteinSummary;
import java.util.Arrays;
import java.util.List;

class ProteinSummaryGrid
extends TypedTableGrid<ProteinSummary> {
    private static final String PREFIX = "openbis_protein-summary";
    public static final String BROWSER_ID = "openbis_protein-summary_main";
    public static final String GRID_ID = "openbis_protein-summary-grid";
    private final IViewContext<IPhosphoNetXClientServiceAsync> specificViewContext;
    private ListProteinSummaryByExperimentCriteria criteria;

    static IDisposableComponent create(IViewContext<IPhosphoNetXClientServiceAsync> viewContext) {
        return new ProteinSummaryGrid(viewContext).asDisposableWithoutToolbar();
    }

    ProteinSummaryGrid(IViewContext<IPhosphoNetXClientServiceAsync> viewContext) {
        super(viewContext.getCommonViewContext(), BROWSER_ID, true, PhosphoNetXDisplayTypeIDGenerator.PROTEIN_SUMMARY_BROWSER_GRID);
        this.specificViewContext = viewContext;
    }

    void update(TechId experimentID) {
        this.criteria = new ListProteinSummaryByExperimentCriteria();
        this.criteria.setExperimentID(experimentID);
        this.refresh(true);
    }

    @Override
    protected String translateColumnIdToDictionaryKey(String columnID) {
        return "FDR".equals(columnID) ? "false_discovery_rate_column" : columnID.toLowerCase();
    }

    @Override
    protected List<String> getColumnIdsOfFilters() {
        return Arrays.asList("FDR");
    }

    @Override
    protected void listTableRows(DefaultResultSetConfig<String, TableModelRowWithObject<ProteinSummary>> resultSetConfig, AbstractAsyncCallback<TypedTableResultSet<ProteinSummary>> callback) {
        if (this.criteria != null) {
            this.criteria.copyPagingConfig(resultSetConfig);
            this.specificViewContext.getService().listProteinSummariesByExperiment(this.criteria, callback);
        }
    }

    @Override
    protected void prepareExportEntities(TableExportCriteria<TableModelRowWithObject<ProteinSummary>> exportCriteria, AbstractAsyncCallback<String> callback) {
        this.specificViewContext.getService().prepareExportProteinSummary(exportCriteria, callback);
    }

    @Override
    public DatabaseModificationKind[] getRelevantModifications() {
        return new DatabaseModificationKind[0];
    }
}

