/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.proteomics.server;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.authentication.ISessionManager;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.common.spring.IInvocationLoggerContext;
import ch.systemsx.cisd.openbis.generic.server.AbstractServer;
import ch.systemsx.cisd.openbis.generic.server.authorization.annotation.AuthorizationGuard;
import ch.systemsx.cisd.openbis.generic.server.authorization.annotation.RolesAllowed;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.AbstractTechIdPredicate;
import ch.systemsx.cisd.openbis.generic.server.business.IPropertiesBatchManager;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IVocabularyDAO;
import ch.systemsx.cisd.openbis.generic.server.plugin.IDataSetTypeSlaveServerPlugin;
import ch.systemsx.cisd.openbis.generic.server.plugin.ISampleTypeSlaveServerPlugin;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.RoleWithHierarchy;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Vocabulary;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.Session;
import ch.systemsx.cisd.openbis.generic.shared.dto.VocabularyPE;
import ch.systemsx.cisd.openbis.generic.shared.translator.VocabularyTranslator;
import ch.systemsx.cisd.openbis.plugin.proteomics.server.PhosphoNetXServerLogger;
import ch.systemsx.cisd.openbis.plugin.proteomics.server.business.AccessionNumberBuilder;
import ch.systemsx.cisd.openbis.plugin.proteomics.server.business.IAbundanceColumnDefinitionTable;
import ch.systemsx.cisd.openbis.plugin.proteomics.server.business.IBusinessObjectFactory;
import ch.systemsx.cisd.openbis.plugin.proteomics.server.business.IDataSetProteinTable;
import ch.systemsx.cisd.openbis.plugin.proteomics.server.business.IProteinDetailsBO;
import ch.systemsx.cisd.openbis.plugin.proteomics.server.business.IProteinInfoTable;
import ch.systemsx.cisd.openbis.plugin.proteomics.server.business.IProteinRelatedSampleTable;
import ch.systemsx.cisd.openbis.plugin.proteomics.server.business.IProteinSequenceTable;
import ch.systemsx.cisd.openbis.plugin.proteomics.server.business.IProteinSummaryTable;
import ch.systemsx.cisd.openbis.plugin.proteomics.server.business.ISampleProvider;
import ch.systemsx.cisd.openbis.plugin.proteomics.server.dataaccess.IPhosphoNetXDAOFactory;
import ch.systemsx.cisd.openbis.plugin.proteomics.server.dataaccess.IProteinQueryDAO;
import ch.systemsx.cisd.openbis.plugin.proteomics.shared.IPhosphoNetXServer;
import ch.systemsx.cisd.openbis.plugin.proteomics.shared.basic.dto.AbundanceColumnDefinition;
import ch.systemsx.cisd.openbis.plugin.proteomics.shared.basic.dto.AggregateFunction;
import ch.systemsx.cisd.openbis.plugin.proteomics.shared.basic.dto.DataSetProtein;
import ch.systemsx.cisd.openbis.plugin.proteomics.shared.basic.dto.ProteinByExperiment;
import ch.systemsx.cisd.openbis.plugin.proteomics.shared.basic.dto.ProteinDetails;
import ch.systemsx.cisd.openbis.plugin.proteomics.shared.basic.dto.ProteinInfo;
import ch.systemsx.cisd.openbis.plugin.proteomics.shared.basic.dto.ProteinRelatedSample;
import ch.systemsx.cisd.openbis.plugin.proteomics.shared.basic.dto.ProteinSequence;
import ch.systemsx.cisd.openbis.plugin.proteomics.shared.basic.dto.ProteinSummary;
import ch.systemsx.cisd.openbis.plugin.proteomics.shared.dto.ProteinReference;
import java.util.List;
import javax.annotation.Resource;
import net.lemnik.eodsql.DataSet;
import org.springframework.stereotype.Component;

@Component(value="proteomics-plugin-server")
public class PhosphoNetXServer
extends AbstractServer<IPhosphoNetXServer>
implements IPhosphoNetXServer {
    @Resource(name="proteomics-dao-factory")
    private IPhosphoNetXDAOFactory specificDAOFactory;
    @Resource(name="proteomics-bo-factory")
    private IBusinessObjectFactory specificBOFactory;

    public PhosphoNetXServer() {
    }

    @Private
    PhosphoNetXServer(ISessionManager<Session> sessionManager, IDAOFactory daoFactory, IPropertiesBatchManager propertiesBatchManager, IPhosphoNetXDAOFactory specificDAOFactory, IBusinessObjectFactory specificBOFactory, ISampleTypeSlaveServerPlugin sampleTypeSlaveServerPlugin, IDataSetTypeSlaveServerPlugin dataSetTypeSlaveServerPlugin) {
        super(sessionManager, daoFactory, propertiesBatchManager, sampleTypeSlaveServerPlugin, dataSetTypeSlaveServerPlugin);
        this.specificDAOFactory = specificDAOFactory;
        this.specificBOFactory = specificBOFactory;
    }

    @Override
    public IPhosphoNetXServer createLogger(IInvocationLoggerContext context) {
        return new PhosphoNetXServerLogger(this.getSessionManager(), context);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public Vocabulary getTreatmentTypeVocabulary(String sessionToken) throws UserFailureException {
        IVocabularyDAO vocabularyDAO = this.getDAOFactory().getVocabularyDAO();
        VocabularyPE vocabulary = vocabularyDAO.tryFindVocabularyByCode("TREATMENT_TYPE");
        return VocabularyTranslator.translate(vocabulary);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public List<AbundanceColumnDefinition> getAbundanceColumnDefinitionsForProteinByExperiment(String sessionToken, @AuthorizationGuard(guardClass=AbstractTechIdPredicate.ExperimentTechIdPredicate.class) TechId experimentID, String treatmentTypeOrNull) throws UserFailureException {
        Session session = this.getSession(sessionToken);
        ISampleProvider sampleProvider = this.specificBOFactory.createSampleProvider(session);
        sampleProvider.loadByExperimentID(experimentID);
        return this.getAbundanceColumnDefinitions(session, sampleProvider, experimentID, treatmentTypeOrNull);
    }

    private List<AbundanceColumnDefinition> getAbundanceColumnDefinitions(Session session, ISampleProvider sampleProvider, TechId experimentID, String treatmentTypeOrNull) {
        String experimentPermID = this.getExperimentPermIDFor(experimentID);
        IProteinQueryDAO dao = this.specificDAOFactory.getProteinQueryDAO(experimentID);
        DataSet<String> samplePermIDs = dao.listAbundanceRelatedSamplePermIDsByExperiment(experimentPermID);
        try {
            IAbundanceColumnDefinitionTable table = this.specificBOFactory.createAbundanceColumnDefinitionTable(session);
            for (String samplePermID : samplePermIDs) {
                table.add(sampleProvider.getSample(samplePermID));
            }
            List<AbundanceColumnDefinition> list = table.getSortedAndAggregatedDefinitions(treatmentTypeOrNull);
            return list;
        }
        finally {
            samplePermIDs.close();
        }
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public List<ProteinInfo> listProteinsByExperiment(String sessionToken, @AuthorizationGuard(guardClass=AbstractTechIdPredicate.ExperimentTechIdPredicate.class) TechId experimentId, double falseDiscoveryRate, AggregateFunction function, String treatmentTypeCode, boolean aggregateOnOriginal) throws UserFailureException {
        Session session = this.getSession(sessionToken);
        ISampleProvider sampleProvider = this.specificBOFactory.createSampleProvider(session);
        sampleProvider.loadByExperimentID(experimentId);
        List<AbundanceColumnDefinition> definitions = this.getAbundanceColumnDefinitions(session, sampleProvider, experimentId, treatmentTypeCode);
        IProteinInfoTable table = this.specificBOFactory.createProteinInfoTable(session, sampleProvider);
        table.load(definitions, experimentId, falseDiscoveryRate, function, aggregateOnOriginal);
        return table.getProteinInfos();
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public List<ProteinSummary> listProteinSummariesByExperiment(String sessionToken, @AuthorizationGuard(guardClass=AbstractTechIdPredicate.ExperimentTechIdPredicate.class) TechId experimentId) throws UserFailureException {
        Session session = this.getSession(sessionToken);
        IProteinSummaryTable summaryTable = this.specificBOFactory.createProteinSummaryTable(session);
        summaryTable.load(experimentId);
        return summaryTable.getProteinSummaries();
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public ProteinByExperiment getProteinByExperiment(String sessionToken, @AuthorizationGuard(guardClass=AbstractTechIdPredicate.ExperimentTechIdPredicate.class) TechId experimentID, TechId proteinReferenceID) throws UserFailureException {
        Session session = this.getSession(sessionToken);
        IProteinQueryDAO proteinQueryDAO = this.specificDAOFactory.getProteinQueryDAO(experimentID);
        ProteinByExperiment proteinByExperiment = new ProteinByExperiment();
        ProteinReference proteinReference = proteinQueryDAO.tryToGetProteinReference(proteinReferenceID.getId());
        if (proteinReference == null) {
            throw new UserFailureException("No protein reference found for ID: " + proteinReferenceID);
        }
        proteinByExperiment.setId(proteinReferenceID);
        AccessionNumberBuilder builder = new AccessionNumberBuilder(proteinReference.getAccessionNumber());
        proteinByExperiment.setAccessionNumber(builder.getAccessionNumber());
        proteinByExperiment.setAccessionNumberType(builder.getTypeOrNull());
        proteinByExperiment.setDescription(proteinReference.getDescription());
        IProteinDetailsBO proteinDetailsBO = this.specificBOFactory.createProteinDetailsBO(session);
        proteinDetailsBO.loadByExperimentAndReference(experimentID, proteinReferenceID);
        proteinByExperiment.setDetails(proteinDetailsBO.getDetailsOrNull());
        return proteinByExperiment;
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public List<ProteinSequence> listProteinSequencesByProteinReference(String sessionToken, TechId experimentID, TechId proteinReferenceID) throws UserFailureException {
        Session session = this.getSession(sessionToken);
        IProteinSequenceTable sequenceTable = this.specificBOFactory.createProteinSequenceTable(session);
        sequenceTable.loadByReference(experimentID, proteinReferenceID);
        return sequenceTable.getSequences();
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public List<DataSetProtein> listProteinsByExperimentAndReference(String sessionToken, @AuthorizationGuard(guardClass=AbstractTechIdPredicate.ExperimentTechIdPredicate.class) TechId experimentId, TechId proteinReferenceID) throws UserFailureException {
        Session session = this.getSession(sessionToken);
        IProteinSequenceTable sequenceTable = this.specificBOFactory.createProteinSequenceTable(session);
        sequenceTable.loadByReference(experimentId, proteinReferenceID);
        IDataSetProteinTable dataSetProteinTable = this.specificBOFactory.createDataSetProteinTable(session);
        dataSetProteinTable.load(this.getExperimentPermIDFor(experimentId), proteinReferenceID, sequenceTable);
        return dataSetProteinTable.getDataSetProteins();
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public List<ProteinRelatedSample> listProteinRelatedSamplesByProtein(String sessionToken, TechId experimentID, TechId proteinReferenceID) throws UserFailureException {
        Session session = this.getSession(sessionToken);
        IProteinDetailsBO proteinDetailsBO = this.specificBOFactory.createProteinDetailsBO(session);
        proteinDetailsBO.loadByExperimentAndReference(experimentID, proteinReferenceID);
        ProteinDetails detailsOrNull = proteinDetailsBO.getDetailsOrNull();
        String sequenceOrNull = detailsOrNull == null ? null : detailsOrNull.getSequence();
        IProteinRelatedSampleTable proteinRelatedSampleTable = this.specificBOFactory.createProteinRelatedSampleTable(session);
        proteinRelatedSampleTable.load(experimentID, proteinReferenceID, sequenceOrNull);
        return proteinRelatedSampleTable.getSamples();
    }

    private String getExperimentPermIDFor(TechId experimentId) {
        ExperimentPE experiment = (ExperimentPE)this.getDAOFactory().getExperimentDAO().getByTechId(experimentId);
        return experiment.getPermId();
    }
}

