/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.proteomics.server.api.v1;

import ch.systemsx.cisd.authentication.ISessionManager;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.common.spring.IInvocationLoggerContext;
import ch.systemsx.cisd.openbis.generic.server.AbstractServer;
import ch.systemsx.cisd.openbis.generic.server.authorization.annotation.RolesAllowed;
import ch.systemsx.cisd.openbis.generic.server.business.IPropertiesBatchManager;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataStoreServiceKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataTypeCode;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PropertyType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.RoleWithHierarchy;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataSetTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataStorePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataStoreServicePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.Session;
import ch.systemsx.cisd.openbis.generic.shared.dto.SessionContextDTO;
import ch.systemsx.cisd.openbis.generic.shared.util.DataTypeUtils;
import ch.systemsx.cisd.openbis.plugin.proteomics.server.api.v1.ProteomicsDataServiceLogger;
import ch.systemsx.cisd.openbis.plugin.proteomics.shared.IProteomicsDataServiceInternal;
import ch.systemsx.cisd.openbis.plugin.proteomics.shared.api.v1.IProteomicsDataService;
import ch.systemsx.cisd.openbis.plugin.proteomics.shared.api.v1.dto.DataSet;
import ch.systemsx.cisd.openbis.plugin.proteomics.shared.api.v1.dto.DataStoreServerProcessingPluginInfo;
import ch.systemsx.cisd.openbis.plugin.proteomics.shared.api.v1.dto.MsInjectionDataInfo;
import ch.systemsx.cisd.openbis.plugin.proteomics.shared.api.v1.dto.PropertyKey;
import ch.systemsx.cisd.openbis.plugin.proteomics.shared.dto.MsInjectionSample;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component(value="proteomics-data-service")
public class ProteomicsDataService
extends AbstractServer<IProteomicsDataService>
implements IProteomicsDataService {
    private static final String MS_SEARCH = "MS_SEARCH";
    @Resource(name="proteomics-data-service-internal")
    private IProteomicsDataServiceInternal service;

    public ProteomicsDataService() {
    }

    public ProteomicsDataService(ISessionManager<Session> sessionManager, IDAOFactory daoFactory, IPropertiesBatchManager propertiesBatchManager, IProteomicsDataServiceInternal service) {
        super(sessionManager, daoFactory, propertiesBatchManager);
        this.service = service;
    }

    @Override
    public String tryToAuthenticateAtRawDataServer(String userID, String userPassword) {
        SessionContextDTO session = this.tryAuthenticate(userID, userPassword);
        return session == null ? null : session.getSessionToken();
    }

    @Override
    public IProteomicsDataService createLogger(IInvocationLoggerContext context) {
        return new ProteomicsDataServiceLogger(this.getSessionManager(), context);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_OBSERVER})
    public List<MsInjectionDataInfo> listRawDataSamples(String sessionToken, String userID) {
        this.checkSession(sessionToken);
        SessionContextDTO session = this.login(userID);
        try {
            List<MsInjectionSample> list = this.service.listRawDataSamples(session.getSessionToken());
            ArrayList<MsInjectionDataInfo> result = new ArrayList<MsInjectionDataInfo>();
            for (MsInjectionSample sample : list) {
                result.add(this.translate(sample));
            }
            ArrayList<MsInjectionDataInfo> arrayList = result;
            return arrayList;
        }
        finally {
            this.service.logout(session.getSessionToken());
        }
    }

    private MsInjectionDataInfo translate(MsInjectionSample sample) {
        MsInjectionDataInfo info = new MsInjectionDataInfo();
        Sample msiSample = sample.getSample();
        info.setMsInjectionSampleID(msiSample.getId());
        info.setMsInjectionSampleCode(msiSample.getCode());
        info.setMsInjectionSampleRegistrationDate(msiSample.getRegistrationDate());
        info.setMsInjectionSampleProperties(this.translate(msiSample.getProperties()));
        Sample bioSample = msiSample.getGeneratedFrom();
        info.setBiologicalSampleID(bioSample.getId());
        info.setBiologicalSampleIdentifier(bioSample.getIdentifier());
        Experiment experiment = bioSample.getExperiment();
        if (experiment != null) {
            info.setBiologicalExperimentIdentifier(experiment.getIdentifier());
            info.setBiologicalExperiment(this.translate(experiment));
        }
        info.setBiologicalSampleProperties(this.translate(bioSample.getProperties()));
        List<AbstractExternalData> dataSets = sample.getDataSets();
        HashSet<DataSet> transformedDataSets = new HashSet<DataSet>();
        for (AbstractExternalData dataSet : dataSets) {
            DataSet transformedDataSet = this.transform(dataSet);
            transformedDataSets.add(transformedDataSet);
        }
        info.setDataSets(transformedDataSets);
        HashMap<String, Date> latestDataSetRegistrationDates = new HashMap<String, Date>();
        for (Map.Entry<String, AbstractExternalData> entry : sample.getLatestDataSets().entrySet()) {
            latestDataSetRegistrationDates.put(entry.getKey(), entry.getValue().getRegistrationDate());
        }
        info.setLatestDataSetRegistrationDates(latestDataSetRegistrationDates);
        return info;
    }

    private DataSet transform(AbstractExternalData dataSet) {
        DataSet transformedDataSet = new DataSet();
        transformedDataSet.setId(dataSet.getId());
        transformedDataSet.setCode(dataSet.getCode());
        transformedDataSet.setType(dataSet.getDataSetType().getCode());
        transformedDataSet.setRegistrationDate(dataSet.getRegistrationDate());
        transformedDataSet.setProperties(this.translate(dataSet.getProperties()));
        Collection<AbstractExternalData> children = dataSet.getChildren();
        if (children != null && !children.isEmpty()) {
            for (AbstractExternalData child : children) {
                transformedDataSet.addChild(this.transform(child));
            }
        }
        return transformedDataSet;
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_OBSERVER})
    public List<DataStoreServerProcessingPluginInfo> listDataStoreServerProcessingPluginInfos(String sessionToken) {
        this.checkSession(sessionToken);
        ArrayList<DataStoreServerProcessingPluginInfo> result = new ArrayList<DataStoreServerProcessingPluginInfo>();
        List<DataStorePE> dataStores = this.getDAOFactory().getDataStoreDAO().listDataStores();
        for (DataStorePE dataStore : dataStores) {
            Set<DataStoreServicePE> services = dataStore.getServices();
            for (DataStoreServicePE dataStoreService : services) {
                if (dataStoreService.getKind() != DataStoreServiceKind.PROCESSING) continue;
                result.add(this.translate(dataStoreService));
            }
        }
        return result;
    }

    private DataStoreServerProcessingPluginInfo translate(DataStoreServicePE dataStoreService) {
        String key = dataStoreService.getKey();
        String label = dataStoreService.getLabel();
        ArrayList<String> translatedCodes = new ArrayList<String>();
        Set<DataSetTypePE> datasetTypes = dataStoreService.getDatasetTypes();
        for (DataSetTypePE dataSetType : datasetTypes) {
            translatedCodes.add(dataSetType.getCode());
        }
        return new DataStoreServerProcessingPluginInfo(key, label, translatedCodes);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_OBSERVER})
    public void processingRawData(String sessionToken, String userID, String dataSetProcessingKey, long[] rawDataSampleIDs, String dataSetType) {
        this.checkSession(sessionToken);
        SessionContextDTO session = this.login(userID);
        try {
            this.service.processRawData(session.getSessionToken(), dataSetProcessingKey, rawDataSampleIDs, dataSetType);
        }
        finally {
            this.service.logout(session.getSessionToken());
        }
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_OBSERVER})
    public void processDataSets(String sessionToken, String userID, String dataSetProcessingKey, List<String> dataSetCodes) {
        this.checkSession(sessionToken);
        SessionContextDTO session = this.login(userID);
        try {
            this.service.processDataSets(session.getSessionToken(), dataSetProcessingKey, dataSetCodes);
        }
        finally {
            this.service.logout(session.getSessionToken());
        }
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_OBSERVER})
    public List<ch.systemsx.cisd.openbis.plugin.proteomics.shared.api.v1.dto.Experiment> listSearchExperiments(String sessionToken, String userID) {
        return this.listExperiments(sessionToken, userID, MS_SEARCH);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_OBSERVER})
    public List<ch.systemsx.cisd.openbis.plugin.proteomics.shared.api.v1.dto.Experiment> listExperiments(String sessionToken, String userID, String experimentTypeCode) {
        this.checkSession(sessionToken);
        SessionContextDTO session = this.login(userID);
        try {
            List<Experiment> experiments = this.service.listExperiments(session.getSessionToken(), experimentTypeCode);
            ArrayList<ch.systemsx.cisd.openbis.plugin.proteomics.shared.api.v1.dto.Experiment> result = new ArrayList<ch.systemsx.cisd.openbis.plugin.proteomics.shared.api.v1.dto.Experiment>();
            for (Experiment experiment : experiments) {
                ch.systemsx.cisd.openbis.plugin.proteomics.shared.api.v1.dto.Experiment e = this.translate(experiment);
                result.add(e);
            }
            ArrayList<ch.systemsx.cisd.openbis.plugin.proteomics.shared.api.v1.dto.Experiment> arrayList = result;
            return arrayList;
        }
        finally {
            this.service.logout(session.getSessionToken());
        }
    }

    private ch.systemsx.cisd.openbis.plugin.proteomics.shared.api.v1.dto.Experiment translate(Experiment experiment) {
        ch.systemsx.cisd.openbis.plugin.proteomics.shared.api.v1.dto.Experiment e = new ch.systemsx.cisd.openbis.plugin.proteomics.shared.api.v1.dto.Experiment();
        e.setId(experiment.getId());
        e.setCode(experiment.getCode());
        e.setProjectCode(experiment.getProject().getCode());
        e.setSpaceCode(experiment.getProject().getSpace().getCode());
        e.setRegistrationDate(experiment.getRegistrationDate());
        e.setProperties(this.translate(experiment.getProperties()));
        return e;
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_OBSERVER})
    public List<DataSet> listDataSetsByExperiment(String sessionToken, String userID, long experimentID) {
        this.checkSession(sessionToken);
        SessionContextDTO session = this.login(userID);
        try {
            ArrayList<DataSet> result = new ArrayList<DataSet>();
            List<AbstractExternalData> dataSets = this.service.listDataSetsByExperiment(session.getSessionToken(), new TechId(experimentID));
            for (AbstractExternalData dataSet : dataSets) {
                DataSet ds = new DataSet();
                ds.setId(dataSet.getId());
                ds.setCode(dataSet.getCode());
                ds.setType(dataSet.getDataSetType().getCode());
                ds.setProperties(this.translate(dataSet.getProperties()));
                result.add(ds);
            }
            ArrayList<DataSet> arrayList = result;
            return arrayList;
        }
        finally {
            this.service.logout(session.getSessionToken());
        }
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_OBSERVER})
    public void processSearchData(String sessionToken, String userID, String dataSetProcessingKey, long[] searchExperimentIDs) {
        this.processProteinResultDataSets(sessionToken, userID, dataSetProcessingKey, MS_SEARCH, searchExperimentIDs);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_OBSERVER})
    public void processProteinResultDataSets(String sessionToken, String userID, String dataSetProcessingKey, String experimentTypeCode, long[] experimentIDs) {
        this.checkSession(sessionToken);
        SessionContextDTO session = this.login(userID);
        try {
            this.service.processProteinResultDataSets(session.getSessionToken(), dataSetProcessingKey, experimentTypeCode, experimentIDs);
        }
        finally {
            this.service.logout(session.getSessionToken());
        }
    }

    private Map<PropertyKey, Serializable> translate(List<IEntityProperty> properties) {
        if (properties == null) {
            return null;
        }
        HashMap<PropertyKey, Serializable> map = new HashMap<PropertyKey, Serializable>();
        for (IEntityProperty property : properties) {
            PropertyType propertyType = property.getPropertyType();
            PropertyKey key = new PropertyKey(propertyType.getCode(), propertyType.getLabel());
            DataTypeCode dataTypeCode = propertyType.getDataType().getCode();
            map.put(key, DataTypeUtils.convertValueTo(dataTypeCode, property.tryGetAsString()));
        }
        return map;
    }

    private SessionContextDTO login(String userID) {
        SessionContextDTO session = this.service.tryAuthenticate(userID, "dummy-password");
        if (session == null) {
            throw new UserFailureException("Unknown user ID: " + userID);
        }
        return session;
    }

    @Override
    public int getMajorVersion() {
        return 1;
    }

    @Override
    public int getMinorVersion() {
        return 3;
    }
}

