/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.proteomics.server.business;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.ISampleDAO;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePE;
import ch.systemsx.cisd.openbis.generic.shared.util.HibernateUtils;
import ch.systemsx.cisd.openbis.plugin.proteomics.server.business.ISampleIDProvider;
import java.util.LinkedHashMap;
import java.util.Map;

public class SampleIDProvider
implements ISampleIDProvider {
    private final ISampleDAO sampleDAO;
    private final Map<String, SamplePE> samples = new LinkedHashMap<String, SamplePE>();

    public SampleIDProvider(ISampleDAO sampleDAO) {
        this.sampleDAO = sampleDAO;
    }

    @Override
    public long getSampleIDOrParentSampleID(String samplePermID) {
        return HibernateUtils.getId(this.getSampleOrParentSample(samplePermID));
    }

    @Override
    public SamplePE getSampleOrParentSample(String samplePermID) {
        SamplePE sample = this.samples.get(samplePermID);
        if (sample == null) {
            sample = this.sampleDAO.tryToFindByPermID(samplePermID);
            if (sample == null) {
                throw new UserFailureException("No sample found for permID " + samplePermID);
            }
            SamplePE parentSample = sample.getGeneratedFrom();
            if (parentSample != null) {
                sample = parentSample;
            }
            this.samples.put(samplePermID, sample);
        }
        return sample;
    }
}

