/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.server;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.authentication.ISessionManager;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.multiplexer.IMultiplexer;
import ch.systemsx.cisd.openbis.common.spring.IInvocationLoggerContext;
import ch.systemsx.cisd.openbis.dss.screening.shared.api.internal.DssServiceRpcScreeningHolder;
import ch.systemsx.cisd.openbis.dss.screening.shared.api.internal.DssServiceRpcScreeningMultiplexer;
import ch.systemsx.cisd.openbis.dss.screening.shared.api.internal.IDssServiceRpcScreeningBatchHandler;
import ch.systemsx.cisd.openbis.dss.screening.shared.api.internal.IDssServiceRpcScreeningFactory;
import ch.systemsx.cisd.openbis.dss.screening.shared.api.internal.IDssServiceRpcScreeningMultiplexer;
import ch.systemsx.cisd.openbis.generic.server.AbstractServer;
import ch.systemsx.cisd.openbis.generic.server.authorization.annotation.AuthorizationGuard;
import ch.systemsx.cisd.openbis.generic.server.authorization.annotation.Capability;
import ch.systemsx.cisd.openbis.generic.server.authorization.annotation.ReturnValueFilter;
import ch.systemsx.cisd.openbis.generic.server.authorization.annotation.RolesAllowed;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.AbstractTechIdPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.DataSetCodeCollectionPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.DataSetCodePredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.SampleTechIdPredicate;
import ch.systemsx.cisd.openbis.generic.server.business.IPropertiesBatchManager;
import ch.systemsx.cisd.openbis.generic.server.business.bo.ISampleBO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IVocabularyDAO;
import ch.systemsx.cisd.openbis.generic.server.plugin.IDataSetTypeSlaveServerPlugin;
import ch.systemsx.cisd.openbis.generic.server.plugin.ISampleTypeSlaveServerPlugin;
import ch.systemsx.cisd.openbis.generic.shared.ICommonServer;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.Sample;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.BasicProjectIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.CodeAndLabel;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ListMaterialCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Material;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MaterialType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewMaterial;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewSamplesWithTypes;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Project;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.RoleWithHierarchy;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleParentWithDerived;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Vocabulary;
import ch.systemsx.cisd.openbis.generic.shared.dto.MetaprojectPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.Session;
import ch.systemsx.cisd.openbis.generic.shared.dto.SessionContextDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.VocabularyPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ProjectIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.IManagedPropertyEvaluatorFactory;
import ch.systemsx.cisd.openbis.generic.shared.translator.MetaprojectTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.SampleTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.VocabularyTranslator;
import ch.systemsx.cisd.openbis.plugin.generic.shared.IGenericServer;
import ch.systemsx.cisd.openbis.plugin.screening.server.IAnalysisSettingSetter;
import ch.systemsx.cisd.openbis.plugin.screening.server.IScreeningBusinessObjectFactory;
import ch.systemsx.cisd.openbis.plugin.screening.server.LibraryRegistrationTask;
import ch.systemsx.cisd.openbis.plugin.screening.server.ScreeningServerLogger;
import ch.systemsx.cisd.openbis.plugin.screening.server.authorization.DatasetReferencePredicate;
import ch.systemsx.cisd.openbis.plugin.screening.server.authorization.ExperimentIdentifierPredicate;
import ch.systemsx.cisd.openbis.plugin.screening.server.authorization.ExperimentSearchCriteriaPredicate;
import ch.systemsx.cisd.openbis.plugin.screening.server.authorization.MaterialExperimentFeatureVectorSummaryValidator;
import ch.systemsx.cisd.openbis.plugin.screening.server.authorization.MaterialFeaturesOneExpPredicate;
import ch.systemsx.cisd.openbis.plugin.screening.server.authorization.PlateIdentifierPredicate;
import ch.systemsx.cisd.openbis.plugin.screening.server.authorization.PlateWellReferenceWithDatasetsValidator;
import ch.systemsx.cisd.openbis.plugin.screening.server.authorization.ScreeningExperimentValidator;
import ch.systemsx.cisd.openbis.plugin.screening.server.authorization.ScreeningPlateListReadOnlyPredicate;
import ch.systemsx.cisd.openbis.plugin.screening.server.authorization.ScreeningPlateValidator;
import ch.systemsx.cisd.openbis.plugin.screening.server.authorization.WellContentValidator;
import ch.systemsx.cisd.openbis.plugin.screening.server.authorization.WellIdentifierPredicate;
import ch.systemsx.cisd.openbis.plugin.screening.server.authorization.WellSearchCriteriaPredicate;
import ch.systemsx.cisd.openbis.plugin.screening.server.dataaccess.AnalysisProcedureResult;
import ch.systemsx.cisd.openbis.plugin.screening.server.dataaccess.IScreeningQuery;
import ch.systemsx.cisd.openbis.plugin.screening.server.logic.AnalysisSettings;
import ch.systemsx.cisd.openbis.plugin.screening.server.logic.ExperimentFeatureVectorSummaryLoader;
import ch.systemsx.cisd.openbis.plugin.screening.server.logic.FeatureVectorValuesLoader;
import ch.systemsx.cisd.openbis.plugin.screening.server.logic.LogicalImageLoader;
import ch.systemsx.cisd.openbis.plugin.screening.server.logic.MaterialFeatureVectorSummaryLoader;
import ch.systemsx.cisd.openbis.plugin.screening.server.logic.MaterialFeaturesFromAllExperimentsLoader;
import ch.systemsx.cisd.openbis.plugin.screening.server.logic.PlateContentLoader;
import ch.systemsx.cisd.openbis.plugin.screening.server.logic.ScreeningApiImpl;
import ch.systemsx.cisd.openbis.plugin.screening.server.logic.ScreeningUtils;
import ch.systemsx.cisd.openbis.plugin.screening.server.logic.WellContentLoader;
import ch.systemsx.cisd.openbis.plugin.screening.shared.IScreeningServer;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.IScreeningApiServer;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.DatasetImageRepresentationFormats;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.ExperimentIdentifier;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.ExperimentImageMetadata;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.FeatureInformation;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.FeatureVectorDataset;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.FeatureVectorDatasetReference;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.FeatureVectorDatasetWellReference;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.FeatureVectorWithDescription;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.IDatasetIdentifier;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.IFeatureVectorDatasetIdentifier;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.IImageDatasetIdentifier;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.IImageRepresentationFormatSelectionCriterion;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.ImageDatasetMetadata;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.ImageDatasetReference;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.ImageRepresentationFormat;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.ImageSize;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.LoadImageConfiguration;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.MaterialIdentifier;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.MaterialTypeIdentifier;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.Plate;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.PlateIdentifier;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.PlateImageReference;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.PlateMetadata;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.PlateWellMaterialMapping;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.PlateWellReferenceWithDatasets;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.WellIdentifier;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.AnalysisProcedures;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.DatasetReference;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.ExperimentFeatureVectorSummary;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.FeatureVectorValues;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.ImageDatasetEnrichedReference;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.ImageResolution;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.ImageSampleContent;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.LogicalImageInfo;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.MaterialReplicaFeatureSummaryResult;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.MaterialReplicaSummaryAggregationType;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.MaterialSimpleFeatureVectorSummary;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.MaterialSummarySettings;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.PlateContent;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.PlateImages;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.WellContent;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.WellLocation;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.WellReplicaImage;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.WellSearchCriteria;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.IImageResolutionLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import net.lemnik.eodsql.DataIterator;
import net.lemnik.eodsql.QueryTool;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Component;

@Component(value="screening-plugin-server")
public final class ScreeningServer
extends AbstractServer<IScreeningServer>
implements IScreeningServer,
IScreeningApiServer,
InitializingBean,
IAnalysisSettingSetter {
    public static final int MINOR_VERSION = 10;
    @Resource(name="screening-bo-factory")
    private IScreeningBusinessObjectFactory businessObjectFactory;
    @Resource(name="common-server")
    private ICommonServer commonServer;
    @Resource(name="generic-plugin-server")
    private IGenericServer genericServer;
    @Resource(name="managed-property-evaluator-factory")
    private IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory;
    private AnalysisSettings analysisSettings;
    @Resource(name="multiplexer")
    private IMultiplexer multiplexer;
    private IDssServiceRpcScreeningMultiplexer dssMultiplexer;

    public ScreeningServer() {
    }

    @Private
    ScreeningServer(ISessionManager<Session> sessionManager, IDAOFactory daoFactory, IPropertiesBatchManager propertiesBatchManager, IScreeningBusinessObjectFactory businessObjectFactory, ISampleTypeSlaveServerPlugin sampleTypeSlaveServerPlugin, IDataSetTypeSlaveServerPlugin dataSetTypeSlaveServerPlugin, IDssServiceRpcScreeningMultiplexer dssMultiplexer) {
        super(sessionManager, daoFactory, propertiesBatchManager, sampleTypeSlaveServerPlugin, dataSetTypeSlaveServerPlugin);
        this.businessObjectFactory = businessObjectFactory;
        this.dssMultiplexer = dssMultiplexer;
    }

    public void afterPropertiesSet() throws Exception {
        this.setAnalysisSettings(new AnalysisSettings(this.configurer.getResolvedProps()));
    }

    @Override
    public void setAnalysisSettings(AnalysisSettings analysisSettings) {
        this.analysisSettings = analysisSettings;
    }

    @Override
    public final IScreeningServer createLogger(IInvocationLoggerContext context) {
        return new ScreeningServerLogger(this.getSessionManager(), context);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public SampleParentWithDerived getSampleInfo(String sessionToken, @AuthorizationGuard(guardClass=SampleTechIdPredicate.class) TechId sampleId) throws UserFailureException {
        Session session = this.getSession(sessionToken);
        ISampleBO sampleBO = this.businessObjectFactory.createSampleBO(session);
        sampleBO.loadDataByTechId(sampleId);
        SamplePE sample = sampleBO.getSample();
        Collection<MetaprojectPE> metaprojectPEs = this.getDAOFactory().getMetaprojectDAO().listMetaprojectsForEntity(session.tryGetPerson(), sample);
        return SampleTranslator.translate(this.getSampleTypeSlaveServerPlugin(sample.getSampleType()).getSampleInfo(session, sample), session.getBaseIndexURL(), MetaprojectTranslator.translate(metaprojectPEs), this.managedPropertyEvaluatorFactory);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public PlateContent getPlateContent(String sessionToken, @AuthorizationGuard(guardClass=SampleTechIdPredicate.class) TechId plateId) {
        Session session = this.getSession(sessionToken);
        return PlateContentLoader.loadImagesAndMetadata(session, this.businessObjectFactory, this.managedPropertyEvaluatorFactory, plateId);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.FeatureVectorDataset getFeatureVectorDataset(String sessionToken, @AuthorizationGuard(guardClass=DatasetReferencePredicate.class) DatasetReference dataset, CodeAndLabel featureName) {
        Session session = this.getSession(sessionToken);
        return PlateContentLoader.loadFeatureVectorDataset(session, this.businessObjectFactory, this.managedPropertyEvaluatorFactory, dataset, featureName);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public PlateImages getPlateContentForDataset(String sessionToken, @AuthorizationGuard(guardClass=AbstractTechIdPredicate.DataSetTechIdPredicate.class) TechId datasetId) {
        Session session = this.getSession(sessionToken);
        return PlateContentLoader.loadImagesAndMetadataForDataset(session, this.businessObjectFactory, this.managedPropertyEvaluatorFactory, datasetId);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    @ReturnValueFilter(validatorClass=WellContentValidator.class)
    public List<WellContent> listPlateWells(String sessionToken, @AuthorizationGuard(guardClass=WellSearchCriteriaPredicate.class) WellSearchCriteria materialCriteria) {
        Session session = this.getSession(sessionToken);
        return WellContentLoader.load(session, this.businessObjectFactory, this.getDAOFactory(), materialCriteria);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public List<WellReplicaImage> listWellImages(String sessionToken, TechId materialId, @AuthorizationGuard(guardClass=AbstractTechIdPredicate.ExperimentTechIdPredicate.class) TechId experimentId) {
        Session session = this.getSession(sessionToken);
        return WellContentLoader.loadWithImages(session, this.businessObjectFactory, this.getDAOFactory(), materialId, experimentId, ScreeningServer.createDefaultSettings());
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public List<Material> listMaterials(String sessionToken, @AuthorizationGuard(guardClass=WellSearchCriteriaPredicate.class) WellSearchCriteria materialCriteria) {
        Session session = this.getSession(sessionToken);
        return WellContentLoader.loadMaterials(session, this.businessObjectFactory, this.getDAOFactory(), materialCriteria);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public FeatureVectorValues getWellFeatureVectorValues(String sessionToken, @AuthorizationGuard(guardClass=DataSetCodePredicate.class) String datasetCode, String datastoreCode, WellLocation wellLocation) {
        Session session = this.getSession(sessionToken);
        return FeatureVectorValuesLoader.loadFeatureVectorValues(session, this.businessObjectFactory, datasetCode, datastoreCode, wellLocation);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public LogicalImageInfo getImageDatasetInfo(String sessionToken, @AuthorizationGuard(guardClass=DataSetCodePredicate.class) String datasetCode, String datastoreCode, WellLocation wellLocationOrNull) {
        Session session = this.getSession(sessionToken);
        return LogicalImageLoader.loadLogicalImageInfo(session, this.businessObjectFactory, this.managedPropertyEvaluatorFactory, datasetCode, datastoreCode, wellLocationOrNull);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public ImageDatasetEnrichedReference getImageDatasetReference(String sessionToken, @AuthorizationGuard(guardClass=DataSetCodePredicate.class) String datasetCode, String datastoreCode) {
        Session session = this.getSession(sessionToken);
        return LogicalImageLoader.getImageDatasetReference(session, this.businessObjectFactory, this.managedPropertyEvaluatorFactory, datasetCode, datastoreCode);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public List<ImageResolution> getImageDatasetResolutions(String sessionToken, @AuthorizationGuard(guardClass=DataSetCodePredicate.class) String datasetCode, String datastoreCode) {
        this.checkSession(sessionToken);
        IImageResolutionLoader loader = this.businessObjectFactory.tryCreateImageResolutionLoader(datasetCode, datastoreCode);
        return loader.getImageResolutions();
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public ImageSampleContent getImageDatasetInfosForSample(String sessionToken, @AuthorizationGuard(guardClass=SampleTechIdPredicate.class) TechId sampleId, WellLocation wellLocationOrNull) {
        Session session = this.getSession(sessionToken);
        return PlateContentLoader.getImageDatasetInfosForSample(session, this.businessObjectFactory, this.managedPropertyEvaluatorFactory, sampleId, wellLocationOrNull);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public AbstractExternalData getDataSetInfo(String sessionToken, @AuthorizationGuard(guardClass=AbstractTechIdPredicate.DataSetTechIdPredicate.class) TechId datasetId) {
        return this.commonServer.getDataSetInfo(sessionToken, datasetId);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public Material getMaterialInfo(String sessionToken, TechId materialId) {
        return this.commonServer.getMaterialInfo(sessionToken, materialId);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public Vocabulary getVocabulary(String sessionToken, String code) throws UserFailureException {
        this.checkSession(sessionToken);
        IVocabularyDAO vocabularyDAO = this.getDAOFactory().getVocabularyDAO();
        VocabularyPE vocabulary = vocabularyDAO.tryFindVocabularyByCode(code);
        return VocabularyTranslator.translate(vocabulary);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ADMIN})
    @Capability(value="WRITE_EXPERIMENT_SAMPLE_MATERIAL")
    public void registerLibrary(String sessionToken, String userEmail, List<NewMaterial> newGenesOrNull, List<NewMaterial> newOligosOrNull, List<NewSamplesWithTypes> newSamplesWithType) {
        this.executeASync(userEmail, new LibraryRegistrationTask(sessionToken, newGenesOrNull, newOligosOrNull, newSamplesWithType, this.commonServer, this.genericServer, this.getDAOFactory()));
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public List<Material> listExperimentMaterials(String sessionToken, @AuthorizationGuard(guardClass=AbstractTechIdPredicate.ExperimentTechIdPredicate.class) TechId experimentId, MaterialType materialType) {
        IScreeningQuery dao = ScreeningServer.createDAO(this.getDAOFactory());
        DataIterator<Long> materialIdsIterator = dao.getMaterialsForExperimentWells(experimentId.getId(), materialType.getId());
        ArrayList<Long> materialIds = new ArrayList<Long>();
        for (Long id : materialIdsIterator) {
            materialIds.add(id);
        }
        return this.commonServer.listMaterials(sessionToken, ListMaterialCriteria.createFromMaterialIds(materialIds), true);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public ExperimentFeatureVectorSummary getExperimentFeatureVectorSummary(String sessionToken, @AuthorizationGuard(guardClass=AbstractTechIdPredicate.ExperimentTechIdPredicate.class) TechId experimentId, WellSearchCriteria.AnalysisProcedureCriteria analysisProcedureCriteria) {
        Session session = this.getSession(sessionToken);
        MaterialSummarySettings settings = ScreeningServer.createDefaultSettings();
        ExperimentFeatureVectorSummaryLoader experimentFeatureVectorSummaryLoader = new ExperimentFeatureVectorSummaryLoader(session, this.businessObjectFactory, this.getDAOFactory(), null, settings);
        return experimentFeatureVectorSummaryLoader.loadExperimentFeatureVectors(experimentId, analysisProcedureCriteria, this.analysisSettings);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    @ReturnValueFilter(validatorClass=MaterialExperimentFeatureVectorSummaryValidator.class)
    public List<MaterialSimpleFeatureVectorSummary> getMaterialFeatureVectorsFromAllExperiments(String sessionToken, WellSearchCriteria.MaterialFeaturesManyExpCriteria criteria) {
        Session session = this.getSession(sessionToken);
        MaterialSummarySettings settings = ScreeningServer.createDefaultSettings();
        TechId projectTechIdOrNull = this.tryFetchProjectId(sessionToken, criteria.getExperimentSearchCriteria());
        return MaterialFeaturesFromAllExperimentsLoader.loadMaterialFeatureVectorsFromAllAssays(session, this.businessObjectFactory, this.getDAOFactory(), criteria.getMaterialId(), criteria.getAnalysisProcedureCriteria(), criteria.isComputeRanks(), projectTechIdOrNull, settings);
    }

    private TechId tryFetchProjectId(String sessionToken, WellSearchCriteria.ExperimentSearchByProjectCriteria experimentCriteria) {
        if (experimentCriteria == null || experimentCriteria.isAllExperiments()) {
            return null;
        }
        return this.fetchProjectId(sessionToken, experimentCriteria.tryGetProjectIdentifier());
    }

    private TechId fetchProjectId(String sessionToken, BasicProjectIdentifier basicProjectIdentifier) {
        ProjectIdentifier projectIdentifier = new ProjectIdentifier(basicProjectIdentifier);
        Project project = this.commonServer.getProjectInfo(sessionToken, projectIdentifier);
        return new TechId(project);
    }

    public static MaterialSummarySettings createDefaultSettings() {
        MaterialSummarySettings settings = new MaterialSummarySettings();
        settings.setAggregationType(MaterialReplicaSummaryAggregationType.MEDIAN);
        settings.setFeatureCodes(new ArrayList<String>());
        settings.setReplicaMatrialTypePatterns(new String[]{"GENE", "CONTROL", "COMPOUND"});
        settings.setMaterialDetailsPropertyType("GENE_SYMBOLS");
        settings.setBiologicalReplicatePropertyTypeCodes("CONCENTRATION", "SIRNA");
        return settings;
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public MaterialReplicaFeatureSummaryResult getMaterialFeatureVectorSummary(String sessionToken, @AuthorizationGuard(guardClass=MaterialFeaturesOneExpPredicate.class) WellSearchCriteria.MaterialFeaturesOneExpCriteria criteria) {
        Session session = this.getSession(sessionToken);
        MaterialSummarySettings settings = ScreeningServer.createDefaultSettings();
        return MaterialFeatureVectorSummaryLoader.loadMaterialFeatureVectors(session, this.businessObjectFactory, this.getDAOFactory(), criteria, settings);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public List<FeatureVectorDatasetReference> listFeatureVectorDatasets(String sessionToken, @AuthorizationGuard(guardClass=ScreeningPlateListReadOnlyPredicate.class) List<? extends PlateIdentifier> plates) throws IllegalArgumentException {
        return this.createScreeningApiImpl(sessionToken).listFeatureVectorDatasets(plates);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public List<ImageDatasetReference> listImageDatasets(String sessionToken, @AuthorizationGuard(guardClass=ScreeningPlateListReadOnlyPredicate.class) List<? extends PlateIdentifier> plates) throws IllegalArgumentException {
        return this.createScreeningApiImpl(sessionToken).listImageDatasets(plates);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public List<ImageDatasetReference> listRawImageDatasets(String sessionToken, @AuthorizationGuard(guardClass=ScreeningPlateListReadOnlyPredicate.class) List<? extends PlateIdentifier> plates) throws IllegalArgumentException {
        return this.createScreeningApiImpl(sessionToken).listRawImageDatasets(plates);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public List<ImageDatasetReference> listSegmentationImageDatasets(String sessionToken, @AuthorizationGuard(guardClass=ScreeningPlateListReadOnlyPredicate.class) List<? extends PlateIdentifier> plates) throws IllegalArgumentException {
        return this.createScreeningApiImpl(sessionToken).listSegmentationImageDatasets(plates);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public List<PlateWellReferenceWithDatasets> listPlateWells(String sessionToken, @AuthorizationGuard(guardClass=ExperimentIdentifierPredicate.class) ExperimentIdentifier experimentIdentifer, MaterialIdentifier materialIdentifier, boolean findDatasets) {
        return this.createScreeningApiImpl(sessionToken).listPlateWells(experimentIdentifer, materialIdentifier, findDatasets);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    @ReturnValueFilter(validatorClass=PlateWellReferenceWithDatasetsValidator.class)
    public List<PlateWellReferenceWithDatasets> listPlateWells(String sessionToken, MaterialIdentifier materialIdentifier, boolean findDatasets) {
        return this.createScreeningApiImpl(sessionToken).listPlateWells(materialIdentifier, findDatasets);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public List<WellIdentifier> listPlateWells(String sessionToken, @AuthorizationGuard(guardClass=PlateIdentifierPredicate.class) PlateIdentifier plateIdentifier) {
        return this.createScreeningApiImpl(sessionToken).listPlateWells(plateIdentifier);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public Sample getWellSample(String sessionToken, @AuthorizationGuard(guardClass=WellIdentifierPredicate.class) WellIdentifier wellIdentifier) {
        return this.createScreeningApiImpl(sessionToken).getWellSample(wellIdentifier, true);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public Sample getPlateSample(String sessionToken, @AuthorizationGuard(guardClass=PlateIdentifierPredicate.class) PlateIdentifier plateIdentifier) {
        return this.createScreeningApiImpl(sessionToken).getPlateSample(plateIdentifier);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    @ReturnValueFilter(validatorClass=ScreeningPlateValidator.class)
    public List<Plate> listPlates(String sessionToken) throws IllegalArgumentException {
        return this.createScreeningApiImpl(sessionToken).listPlates();
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public List<Plate> listPlates(String sessionToken, @AuthorizationGuard(guardClass=ExperimentIdentifierPredicate.class) ExperimentIdentifier experiment) throws IllegalArgumentException {
        return this.createScreeningApiImpl(sessionToken).listPlates(experiment);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    @ReturnValueFilter(validatorClass=ScreeningExperimentValidator.class)
    public List<ExperimentIdentifier> listExperiments(String sessionToken) {
        return this.createScreeningApiImpl(sessionToken).listExperiments();
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_OBSERVER})
    public List<ExperimentIdentifier> listExperiments(String sessionToken, String userId) {
        return this.createScreeningApiImpl(sessionToken).listExperiments(userId);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public List<IDatasetIdentifier> getDatasetIdentifiers(String sessionToken, @AuthorizationGuard(guardClass=DataSetCodeCollectionPredicate.class) List<String> datasetCodes) {
        return this.createScreeningApiImpl(sessionToken).getDatasetIdentifiers(datasetCodes);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public AnalysisProcedures listNumericalDatasetsAnalysisProcedures(String sessionToken, @AuthorizationGuard(guardClass=ExperimentSearchCriteriaPredicate.class) WellSearchCriteria.ExperimentSearchCriteria experimentSearchCriteria) {
        this.checkSession(sessionToken);
        IScreeningQuery dao = ScreeningServer.createDAO(this.getDAOFactory());
        WellSearchCriteria.SingleExperimentSearchCriteria singleExpCriteria = experimentSearchCriteria != null ? experimentSearchCriteria.tryGetExperiment() : null;
        List<AnalysisProcedureResult> analysisProcedures = singleExpCriteria == null ? dao.listAllAnalysisProcedures() : dao.listAnalysisProceduresForExperiment(singleExpCriteria.getExperimentId().getId());
        return ScreeningUtils.filterNumericalDatasetsAnalysisProcedures(analysisProcedures);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public List<PlateWellMaterialMapping> listPlateMaterialMapping(String sessionToken, @AuthorizationGuard(guardClass=ScreeningPlateListReadOnlyPredicate.class) List<? extends PlateIdentifier> plates, MaterialTypeIdentifier materialTypeIdentifierOrNull) {
        return this.createScreeningApiImpl(sessionToken).listPlateMaterialMapping(plates, materialTypeIdentifierOrNull);
    }

    private static IScreeningQuery createDAO(IDAOFactory daoFactory) {
        return (IScreeningQuery)QueryTool.getManagedQuery(IScreeningQuery.class);
    }

    private ScreeningApiImpl createScreeningApiImpl(String sessionToken) {
        Session session = this.getSession(sessionToken);
        return new ScreeningApiImpl(session, this.businessObjectFactory, this.getDAOFactory(), this.managedPropertyEvaluatorFactory);
    }

    @Override
    public void logoutScreening(String sessionToken) {
        this.logout(sessionToken);
    }

    @Override
    public String tryLoginScreening(String userId, String userPassword) {
        SessionContextDTO sessionContext = this.tryAuthenticate(userId, userPassword);
        if (sessionContext != null) {
            return sessionContext.getSessionToken();
        }
        return null;
    }

    @Override
    public int getMajorVersion() {
        return 1;
    }

    @Override
    public int getMinorVersion() {
        return 10;
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public List<PlateMetadata> getPlateMetadataList(String sessionToken, @AuthorizationGuard(guardClass=ScreeningPlateListReadOnlyPredicate.class) List<? extends PlateIdentifier> plateIdentifiers) throws IllegalArgumentException {
        return this.createScreeningApiImpl(sessionToken).getPlateMetadata(plateIdentifiers);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public ExperimentImageMetadata getExperimentImageMetadata(String sessionToken, @AuthorizationGuard(guardClass=ExperimentIdentifierPredicate.class) ExperimentIdentifier experimentIdentifer) {
        this.checkSession(sessionToken);
        return this.createScreeningApiImpl(sessionToken).getExperimentImageMetadata(experimentIdentifer);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public List<String> listAvailableFeatureCodes(final String sessionToken, List<? extends IFeatureVectorDatasetIdentifier> featureDatasets) {
        this.checkSession(sessionToken);
        IDssServiceRpcScreeningBatchHandler<IFeatureVectorDatasetIdentifier, String> handler = new IDssServiceRpcScreeningBatchHandler<IFeatureVectorDatasetIdentifier, String>(){

            @Override
            public List<String> handle(DssServiceRpcScreeningHolder dssService, List<IFeatureVectorDatasetIdentifier> references) {
                return dssService.getService().listAvailableFeatureCodes(sessionToken, references);
            }
        };
        return this.getDssMultiplexer().process(featureDatasets, handler).getMergedBatchResultsWithoutDuplicates();
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public List<FeatureInformation> listAvailableFeatures(final String sessionToken, List<? extends IFeatureVectorDatasetIdentifier> featureDatasets) {
        this.checkSession(sessionToken);
        IDssServiceRpcScreeningBatchHandler<IFeatureVectorDatasetIdentifier, FeatureInformation> handler = new IDssServiceRpcScreeningBatchHandler<IFeatureVectorDatasetIdentifier, FeatureInformation>(){

            @Override
            public List<FeatureInformation> handle(DssServiceRpcScreeningHolder dssService, List<IFeatureVectorDatasetIdentifier> references) {
                return dssService.getService().listAvailableFeatures(sessionToken, references);
            }
        };
        return this.getDssMultiplexer().process(featureDatasets, handler).getMergedBatchResultsWithoutDuplicates();
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public List<FeatureVectorDataset> loadFeatures(final String sessionToken, List<FeatureVectorDatasetReference> featureDatasets, final List<String> featureCodes) {
        this.checkSession(sessionToken);
        IDssServiceRpcScreeningBatchHandler<FeatureVectorDatasetReference, FeatureVectorDataset> handler = new IDssServiceRpcScreeningBatchHandler<FeatureVectorDatasetReference, FeatureVectorDataset>(){

            @Override
            public List<FeatureVectorDataset> handle(DssServiceRpcScreeningHolder dssService, List<FeatureVectorDatasetReference> references) {
                return dssService.getService().loadFeatures(sessionToken, references, featureCodes);
            }
        };
        return this.getDssMultiplexer().process(featureDatasets, handler).getMergedBatchResultsWithDuplicates();
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public List<FeatureVectorWithDescription> loadFeaturesForDatasetWellReferences(final String sessionToken, List<FeatureVectorDatasetWellReference> datasetWellReferences, final List<String> featureCodes) {
        this.checkSession(sessionToken);
        IDssServiceRpcScreeningBatchHandler<FeatureVectorDatasetWellReference, FeatureVectorWithDescription> handler = new IDssServiceRpcScreeningBatchHandler<FeatureVectorDatasetWellReference, FeatureVectorWithDescription>(){

            @Override
            public List<FeatureVectorWithDescription> handle(DssServiceRpcScreeningHolder dssService, List<FeatureVectorDatasetWellReference> references) {
                return dssService.getService().loadFeaturesForDatasetWellReferences(sessionToken, references, featureCodes);
            }
        };
        return this.getDssMultiplexer().process(datasetWellReferences, handler).getMergedBatchResultsWithDuplicates();
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public List<String> loadImagesBase64(final String sessionToken, List<PlateImageReference> imageReferences, final boolean convertToPng) {
        this.checkSession(sessionToken);
        IDssServiceRpcScreeningBatchHandler<PlateImageReference, String> handler = new IDssServiceRpcScreeningBatchHandler<PlateImageReference, String>(){

            @Override
            public List<String> handle(DssServiceRpcScreeningHolder dssService, List<PlateImageReference> references) {
                return dssService.getService().loadImagesBase64(sessionToken, references, convertToPng);
            }
        };
        return this.getDssMultiplexer().process(imageReferences, handler).getMergedBatchResultsWithDuplicates();
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public List<String> loadThumbnailImagesBase64(final String sessionToken, List<PlateImageReference> imageReferences) {
        this.checkSession(sessionToken);
        IDssServiceRpcScreeningBatchHandler<PlateImageReference, String> handler = new IDssServiceRpcScreeningBatchHandler<PlateImageReference, String>(){

            @Override
            public List<String> handle(DssServiceRpcScreeningHolder dssService, List<PlateImageReference> references) {
                return dssService.getService().loadThumbnailImagesBase64(sessionToken, references);
            }
        };
        return this.getDssMultiplexer().process(imageReferences, handler).getMergedBatchResultsWithDuplicates();
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public List<String> loadImagesBase64(final String sessionToken, List<PlateImageReference> imageReferences, final ImageSize size) {
        this.checkSession(sessionToken);
        IDssServiceRpcScreeningBatchHandler<PlateImageReference, String> handler = new IDssServiceRpcScreeningBatchHandler<PlateImageReference, String>(){

            @Override
            public List<String> handle(DssServiceRpcScreeningHolder dssService, List<PlateImageReference> references) {
                return dssService.getService().loadImagesBase64(sessionToken, references, size);
            }
        };
        return this.getDssMultiplexer().process(imageReferences, handler).getMergedBatchResultsWithDuplicates();
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public List<String> loadImagesBase64(final String sessionToken, List<PlateImageReference> imageReferences) {
        this.checkSession(sessionToken);
        IDssServiceRpcScreeningBatchHandler<PlateImageReference, String> handler = new IDssServiceRpcScreeningBatchHandler<PlateImageReference, String>(){

            @Override
            public List<String> handle(DssServiceRpcScreeningHolder dssService, List<PlateImageReference> references) {
                return dssService.getService().loadImagesBase64(sessionToken, references);
            }
        };
        return this.getDssMultiplexer().process(imageReferences, handler).getMergedBatchResultsWithDuplicates();
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public List<String> loadImagesBase64(final String sessionToken, List<PlateImageReference> imageReferences, final LoadImageConfiguration configuration) {
        IDssServiceRpcScreeningBatchHandler<PlateImageReference, String> handler = new IDssServiceRpcScreeningBatchHandler<PlateImageReference, String>(){

            @Override
            public List<String> handle(DssServiceRpcScreeningHolder dssService, List<PlateImageReference> references) {
                return dssService.getService().loadImagesBase64(sessionToken, references, configuration);
            }
        };
        return this.getDssMultiplexer().process(imageReferences, handler).getMergedBatchResultsWithDuplicates();
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public List<String> loadImagesBase64(final String sessionToken, List<PlateImageReference> imageReferences, final ImageRepresentationFormat format) {
        IDssServiceRpcScreeningBatchHandler<PlateImageReference, String> handler = new IDssServiceRpcScreeningBatchHandler<PlateImageReference, String>(){

            @Override
            public List<String> handle(DssServiceRpcScreeningHolder dssService, List<PlateImageReference> references) {
                return dssService.getService().loadImagesBase64(sessionToken, references, format);
            }
        };
        return this.getDssMultiplexer().process(imageReferences, handler).getMergedBatchResultsWithDuplicates();
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public List<String> loadImagesBase64(final String sessionToken, List<PlateImageReference> imageReferences, final IImageRepresentationFormatSelectionCriterion ... criteria) {
        IDssServiceRpcScreeningBatchHandler<PlateImageReference, String> handler = new IDssServiceRpcScreeningBatchHandler<PlateImageReference, String>(){

            @Override
            public List<String> handle(DssServiceRpcScreeningHolder dssService, List<PlateImageReference> references) {
                return dssService.getService().loadImagesBase64(sessionToken, references, criteria);
            }
        };
        return this.getDssMultiplexer().process(imageReferences, handler).getMergedBatchResultsWithDuplicates();
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public List<ImageDatasetMetadata> listImageMetadata(final String sessionToken, List<? extends IImageDatasetIdentifier> imageDatasets) {
        IDssServiceRpcScreeningBatchHandler<IImageDatasetIdentifier, ImageDatasetMetadata> handler = new IDssServiceRpcScreeningBatchHandler<IImageDatasetIdentifier, ImageDatasetMetadata>(){

            @Override
            public List<ImageDatasetMetadata> handle(DssServiceRpcScreeningHolder dssService, List<IImageDatasetIdentifier> references) {
                return dssService.getService().listImageMetadata(sessionToken, references);
            }
        };
        return this.getDssMultiplexer().process(imageDatasets, handler).getMergedBatchResultsWithDuplicates();
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public List<DatasetImageRepresentationFormats> listAvailableImageRepresentationFormats(final String sessionToken, List<? extends IDatasetIdentifier> imageDatasets) {
        IDssServiceRpcScreeningBatchHandler<IDatasetIdentifier, DatasetImageRepresentationFormats> handler = new IDssServiceRpcScreeningBatchHandler<IDatasetIdentifier, DatasetImageRepresentationFormats>(){

            @Override
            public List<DatasetImageRepresentationFormats> handle(DssServiceRpcScreeningHolder dssService, List<IDatasetIdentifier> references) {
                return dssService.getService().listAvailableImageRepresentationFormats(sessionToken, references);
            }
        };
        return this.getDssMultiplexer().process(imageDatasets, handler).getMergedBatchResultsWithDuplicates();
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public List<String> loadPhysicalThumbnailsBase64(final String sessionToken, List<PlateImageReference> imageReferences, final ImageRepresentationFormat format) {
        IDssServiceRpcScreeningBatchHandler<PlateImageReference, String> handler = new IDssServiceRpcScreeningBatchHandler<PlateImageReference, String>(){

            @Override
            public List<String> handle(DssServiceRpcScreeningHolder dssService, List<PlateImageReference> references) {
                return dssService.getService().loadPhysicalThumbnailsBase64(sessionToken, references, format);
            }
        };
        return this.getDssMultiplexer().process(imageReferences, handler).getMergedBatchResultsWithDuplicates();
    }

    private IDssServiceRpcScreeningMultiplexer getDssMultiplexer() {
        if (this.dssMultiplexer == null) {
            this.dssMultiplexer = new DssServiceRpcScreeningMultiplexer(this.multiplexer, new IDssServiceRpcScreeningFactory(){

                @Override
                public DssServiceRpcScreeningHolder createDssService(String serverUrl) {
                    return new DssServiceRpcScreeningHolder(serverUrl, ScreeningServer.this.getMajorVersion(), 300000L);
                }
            });
        }
        return this.dssMultiplexer;
    }
}

