/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.server.logic;

import ch.systemsx.cisd.hcs.Location;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ContainerDataSet;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataStore;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PhysicalDataSet;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataPE;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.IManagedPropertyEvaluatorFactory;
import ch.systemsx.cisd.openbis.generic.shared.translator.DataStoreTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.ExperimentTranslator;
import ch.systemsx.cisd.openbis.generic.shared.util.EntityHelper;
import ch.systemsx.cisd.openbis.plugin.screening.server.IScreeningBusinessObjectFactory;
import ch.systemsx.cisd.openbis.plugin.screening.server.dataaccess.AnalysisProcedureResult;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.AnalysisProcedures;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.DatasetReference;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.ImageDatasetParameters;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.WellLocation;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.WellSearchCriteria;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.IImageDatasetLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;

public class ScreeningUtils {
    public static WellLocation tryCreateLocationFromMatrixCoordinate(String wellCode) {
        Location loc = Location.tryCreateLocationFromTransposedMatrixCoordinate(wellCode);
        if (loc == null) {
            return null;
        }
        return new WellLocation(loc.getY(), loc.getX());
    }

    public static DatasetReference createDatasetReference(DataPE dataset, String baseIndexURL, IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory) {
        DataStore dataStore = DataStoreTranslator.translate(dataset.getDataStore());
        String dataTypeCode = dataset.getDataSetType().getCode();
        String fileTypeCode = null;
        Experiment experiment = ExperimentTranslator.translate(dataset.getExperiment(), baseIndexURL, null, managedPropertyEvaluatorFactory, new ExperimentTranslator.LoadableFields[0]);
        String analysisProcedureOrNull = EntityHelper.tryFindPropertyValue(dataset, "$ANALYSIS_PROCEDURE");
        return ScreeningUtils.createDatasetReference(dataset.getId(), dataset.getCode(), analysisProcedureOrNull, dataStore, dataTypeCode, dataset.getRegistrationDate(), fileTypeCode, experiment);
    }

    public static DatasetReference createDatasetReference(AbstractExternalData dataset) {
        DataStore dataStore = dataset.getDataStore();
        String dataTypeCode = dataset.getDataSetType().getCode();
        String fileTypeCode = ScreeningUtils.tryGetFileTypeCode(dataset);
        Experiment experiment = dataset.getExperiment();
        String analysisProcedureOrNull = EntityHelper.tryFindPropertyValue(dataset, "$ANALYSIS_PROCEDURE");
        return ScreeningUtils.createDatasetReference(dataset.getId(), dataset.getCode(), analysisProcedureOrNull, dataStore, dataTypeCode, dataset.getRegistrationDate(), fileTypeCode, experiment);
    }

    private static String tryGetFileTypeCode(AbstractExternalData abstractDataSet) {
        String fileTypeCode;
        PhysicalDataSet dataSet = abstractDataSet.tryGetAsDataSet();
        if (dataSet != null && dataSet.getFileFormatType() != null && !"UNKNOWN".equalsIgnoreCase(fileTypeCode = dataSet.getFileFormatType().getCode())) {
            return fileTypeCode;
        }
        return null;
    }

    private static DatasetReference createDatasetReference(long datasetId, String datasetCode, String analysisProcedureOrNull, DataStore dataStore, String dataTypeCode, Date registrationDate, String fileTypeCode, Experiment experiment) {
        return new DatasetReference(datasetId, datasetCode, dataTypeCode, registrationDate, fileTypeCode, dataStore.getCode(), dataStore.getHostUrl(), experiment.getPermId(), experiment.getIdentifier(), analysisProcedureOrNull);
    }

    public static <T extends DataPE> List<T> filterImageAnalysisDatasetsPE(List<T> datasets) {
        return ScreeningUtils.filterDatasetsByTypePattern(datasets, "HCS_IMAGE_ANALYSIS_DATA|HCS_ANALYSIS_WELL.*|HCS_ANALYSIS_CONTAINER_WELL.*");
    }

    public static List<AbstractExternalData> filterImageAnalysisDatasets(List<AbstractExternalData> datasets) {
        return ScreeningUtils.filterExternalDataByTypePattern(datasets, "HCS_IMAGE_ANALYSIS_DATA|HCS_ANALYSIS_WELL.*|HCS_ANALYSIS_CONTAINER_WELL.*");
    }

    public static AnalysisProcedures filterNumericalDatasetsAnalysisProcedures(List<AnalysisProcedureResult> analysisProcedureResults) {
        HashSet<String> uniqueAnalysisProcedures = new HashSet<String>();
        for (AnalysisProcedureResult analysisProcedureResult : analysisProcedureResults) {
            if (!ScreeningUtils.isMatching(analysisProcedureResult, "HCS_IMAGE_ANALYSIS_DATA|HCS_ANALYSIS_WELL.*|HCS_ANALYSIS_CONTAINER_WELL.*")) continue;
            uniqueAnalysisProcedures.add(analysisProcedureResult.analysisProcedure);
        }
        return new AnalysisProcedures(uniqueAnalysisProcedures);
    }

    public static <T extends DataPE> List<T> filterImageOverlayDatasets(Collection<T> datasets) {
        return ScreeningUtils.filterNonContainedDatasets(datasets, "HCS_IMAGE.*OVERLAY.*|HCS_IMAGE.*_SEGMENTATION.*", ".*IMG.*.*OVERLAY.*|.*IMG.*.*SEGMENTATION.*");
    }

    public static <T extends DataPE> List<T> filterImageDatasets(List<T> datasets) {
        List<T> allDatasets = ScreeningUtils.filterNonContainedDatasets(datasets, "HCS_IMAGE($|[^_].*|_[^A].*|_A[^N].*|_AN[^A].*)", "MICROSCOPY_IMAGE|.*IMG.*");
        allDatasets = ScreeningUtils.excludeDatasetsByTypePattern(allDatasets, "HCS_IMAGE.*OVERLAY.*|HCS_IMAGE.*_SEGMENTATION.*", ".*IMG.*.*OVERLAY.*|.*IMG.*.*SEGMENTATION.*");
        return allDatasets;
    }

    private static <T extends DataPE> List<T> filterNonContainedDatasets(Collection<T> datasets, String ... datasetTypeCodePatterns) {
        List<DataPE> typeMatchingDatasets = ScreeningUtils.filterDatasetsByTypePattern(datasets, datasetTypeCodePatterns);
        ArrayList<DataPE> chosenDatasets = new ArrayList<DataPE>();
        for (DataPE dataset : typeMatchingDatasets) {
            if (ScreeningUtils.isContainerMatching(dataset, datasetTypeCodePatterns) || !ScreeningUtils.isNotEmpty(dataset)) continue;
            chosenDatasets.add(dataset);
        }
        return chosenDatasets;
    }

    private static boolean isContainerMatching(AbstractExternalData dataset, String ... datasetTypeCodePatterns) {
        ContainerDataSet container = dataset.tryGetContainer();
        return container != null && ScreeningUtils.isOneOfTypesMatching(container, datasetTypeCodePatterns);
    }

    private static <T extends DataPE> boolean isContainerMatching(T dataset, String ... datasetTypeCodePatterns) {
        DataPE container = dataset.getContainer();
        return container != null && ScreeningUtils.isOneOfTypesMatching(container, datasetTypeCodePatterns);
    }

    private static boolean isNotEmpty(AbstractExternalData dataset) {
        return !dataset.isContainer() || dataset.tryGetAsContainerDataSet().getContainedDataSets().size() > 0;
    }

    private static <T extends DataPE> boolean isNotEmpty(T dataset) {
        return !dataset.isContainer() || dataset.getContainedDataSets().size() > 0;
    }

    public static <T extends DataPE> List<T> filterUnknownDatasets(List<T> datasets) {
        return ScreeningUtils.excludeDatasetsByTypePattern(datasets, "HCS_IMAGE_ANALYSIS_DATA|HCS_ANALYSIS_WELL.*|HCS_ANALYSIS_CONTAINER_WELL.*", "HCS_IMAGE($|[^_].*|_[^A].*|_A[^N].*|_AN[^A].*)", "MICROSCOPY_IMAGE|.*IMG.*");
    }

    private static <T extends DataPE> List<T> excludeDatasetsByTypePattern(List<T> datasets, String ... datasetTypeCodePatterns) {
        return ScreeningUtils.filterDatasetsByTypePattern(datasets, false, datasetTypeCodePatterns);
    }

    public static <T extends DataPE> List<T> filterDatasetsByTypePattern(Collection<T> datasets, String ... datasetTypeCodePatterns) {
        return ScreeningUtils.filterDatasetsByTypePattern(datasets, true, datasetTypeCodePatterns);
    }

    private static <T extends DataPE> List<T> filterDatasetsByTypePattern(Collection<T> datasets, boolean doesMatch, String ... datasetTypeCodePatterns) {
        ArrayList<DataPE> chosenDatasets = new ArrayList<DataPE>();
        for (DataPE dataset : datasets) {
            if (ScreeningUtils.isOneOfTypesMatching(dataset, datasetTypeCodePatterns) != doesMatch) continue;
            chosenDatasets.add(dataset);
        }
        return chosenDatasets;
    }

    private static boolean isOneOfTypesMatching(DataPE dataset, String ... datasetTypeCodePatterns) {
        String[] stringArray = datasetTypeCodePatterns;
        int n = datasetTypeCodePatterns.length;
        int n2 = 0;
        while (n2 < n) {
            String datasetTypeCodePattern = stringArray[n2];
            if (ScreeningUtils.isTypeMatching(dataset, datasetTypeCodePattern)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static boolean isMatching(AnalysisProcedureResult analysisProcedureResult, String datasetTypeCodePattern) {
        String analysisProcedure = analysisProcedureResult.analysisProcedure;
        if (analysisProcedure == null) {
            return true;
        }
        return analysisProcedureResult.datasetTypeCode.matches(datasetTypeCodePattern);
    }

    private static boolean isTypeMatching(DataPE dataset, String datasetTypeCodePattern) {
        return dataset.getDataSetType().getCode().matches(datasetTypeCodePattern);
    }

    public static boolean isHcsImageDataset(AbstractExternalData externalData) {
        return ScreeningUtils.isTypeMatchingExcludingContainer(externalData, "HCS_IMAGE($|[^_].*|_[^A].*|_A[^N].*|_AN[^A].*)");
    }

    private static boolean isTypeMatchingExcludingContainer(AbstractExternalData externalData, String typePattern) {
        return ScreeningUtils.isOneOfTypesMatching(externalData, typePattern) && !ScreeningUtils.isContainerMatching(externalData, typePattern) && ScreeningUtils.isNotEmpty(externalData);
    }

    public static boolean isRawHcsImageDataset(AbstractExternalData externalData) {
        return ScreeningUtils.isTypeMatchingExcludingContainer(externalData, "HCS_IMAGE.*_RAW.*") || "HCS_IMAGE".equals(externalData.getDataSetType().getCode());
    }

    public static boolean isSegmentationHcsImageDataset(AbstractExternalData externalData) {
        return ScreeningUtils.isTypeMatchingExcludingContainer(externalData, "HCS_IMAGE.*OVERLAY.*|HCS_IMAGE.*_SEGMENTATION.*");
    }

    public static boolean isBasicHcsImageDataset(AbstractExternalData externalData) {
        return ScreeningUtils.isHcsImageDataset(externalData) && !ScreeningUtils.isSegmentationHcsImageDataset(externalData);
    }

    public static List<AbstractExternalData> filterExternalDataByTypePattern(Collection<AbstractExternalData> datasets, String ... datasetTypeCodePatterns) {
        ArrayList<AbstractExternalData> chosenDatasets = new ArrayList<AbstractExternalData>();
        for (AbstractExternalData dataset : datasets) {
            if (!ScreeningUtils.isOneOfTypesMatching(dataset, datasetTypeCodePatterns)) continue;
            chosenDatasets.add(dataset);
        }
        return chosenDatasets;
    }

    public static boolean isTypeMatching(AbstractExternalData dataset, String datasetTypeCodePattern) {
        return dataset.getDataSetType().getCode().matches(datasetTypeCodePattern);
    }

    private static boolean isOneOfTypesMatching(AbstractExternalData dataset, String ... datasetTypeCodePatterns) {
        String[] stringArray = datasetTypeCodePatterns;
        int n = datasetTypeCodePatterns.length;
        int n2 = 0;
        while (n2 < n) {
            String datasetTypeCodePattern = stringArray[n2];
            if (ScreeningUtils.isTypeMatching(dataset, datasetTypeCodePattern)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static ImageDatasetParameters tryLoadImageParameters(AbstractExternalData dataset, IScreeningBusinessObjectFactory businessObjectFactory) {
        IImageDatasetLoader loader = ScreeningUtils.tryCreateHCSDatasetLoader(dataset, businessObjectFactory);
        if (loader == null) {
            return null;
        }
        ImageDatasetParameters params = loader.getImageParameters();
        return params;
    }

    private static IImageDatasetLoader tryCreateHCSDatasetLoader(AbstractExternalData dataSet, IScreeningBusinessObjectFactory businessObjectFactory) {
        String datastoreCode = dataSet.getDataStore().getCode();
        String datasetCode = dataSet.getCode();
        return businessObjectFactory.tryCreateImageDatasetLoader(datasetCode, datastoreCode);
    }

    public static String asJavaRegExpr(String[] substrings) {
        return ScreeningUtils.asSubstringExpression(substrings, ".*");
    }

    public static String asSubstringExpression(String[] substrings, String starExpr) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < substrings.length) {
            if (sb.length() > 0) {
                sb.append("|");
            }
            sb.append(starExpr);
            sb.append(substrings[i]);
            sb.append(starExpr);
            ++i;
        }
        return sb.toString();
    }

    public static boolean isMatchingAnalysisProcedure(AbstractExternalData dataset, WellSearchCriteria.AnalysisProcedureCriteria analysisProcedureCriteria) {
        String dataSetAnalysisProcedure = EntityHelper.tryFindPropertyValue(dataset, "$ANALYSIS_PROCEDURE");
        return analysisProcedureCriteria.matches(dataSetAnalysisProcedure);
    }
}

