/*
 * Decompiled with CFR 0.152.
 */
package ar.com.hjg.pngj.chunks;

import ar.com.hjg.pngj.ImageInfo;
import ar.com.hjg.pngj.PngjException;
import ar.com.hjg.pngj.chunks.ChunkHelper;
import ar.com.hjg.pngj.chunks.ChunkRaw;
import ar.com.hjg.pngj.chunks.PngChunkBKGD;
import ar.com.hjg.pngj.chunks.PngChunkCHRM;
import ar.com.hjg.pngj.chunks.PngChunkGAMA;
import ar.com.hjg.pngj.chunks.PngChunkICCP;
import ar.com.hjg.pngj.chunks.PngChunkIDAT;
import ar.com.hjg.pngj.chunks.PngChunkIEND;
import ar.com.hjg.pngj.chunks.PngChunkIHDR;
import ar.com.hjg.pngj.chunks.PngChunkOTHER;
import ar.com.hjg.pngj.chunks.PngChunkPHYS;
import ar.com.hjg.pngj.chunks.PngChunkPLTE;
import ar.com.hjg.pngj.chunks.PngChunkSBIT;
import ar.com.hjg.pngj.chunks.PngChunkSRGB;
import ar.com.hjg.pngj.chunks.PngChunkTEXT;
import ar.com.hjg.pngj.chunks.PngChunkTIME;
import ar.com.hjg.pngj.chunks.PngChunkTRNS;
import java.io.OutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PngChunk {
    public final String id;
    public final boolean crit;
    public final boolean pub;
    public final boolean safe;
    public final boolean known;
    public final boolean beforeIDAT;
    public final boolean beforePLTE;
    private int lenori = -1;
    private int writeStatus = 0;
    protected final ImageInfo imgInfo;

    protected PngChunk(String id, ImageInfo imgInfo) {
        this.id = id;
        this.imgInfo = imgInfo;
        this.crit = ChunkHelper.isCritical(id);
        this.pub = ChunkHelper.isPublic(id);
        this.safe = ChunkHelper.isSafeToCopy(id);
        this.known = ChunkHelper.isKnown(id);
        this.beforeIDAT = ChunkHelper.beforeIDAT(id);
        this.beforePLTE = ChunkHelper.beforePLTE(id);
    }

    public abstract ChunkRaw createChunk();

    public abstract void parseFromChunk(ChunkRaw var1);

    public abstract void cloneDataFromRead(PngChunk var1);

    public static <T extends PngChunk> T cloneChunk(T chunk, ImageInfo info) {
        PngChunk cn = PngChunk.factoryFromId(chunk.id, info);
        if (cn.getClass() != chunk.getClass()) {
            throw new PngjException("bad class cloning chunk: " + cn.getClass() + " " + chunk.getClass());
        }
        cn.cloneDataFromRead(chunk);
        return (T)cn;
    }

    public static PngChunk factory(ChunkRaw chunk, ImageInfo info) {
        PngChunk c = PngChunk.factoryFromId(ChunkHelper.toString(chunk.idbytes), info);
        c.lenori = chunk.len;
        c.parseFromChunk(chunk);
        return c;
    }

    public static PngChunk factoryFromId(String cid, ImageInfo info) {
        PngChunk ctype = null;
        ctype = cid.equals("IDAT") ? new PngChunkIDAT(info) : (cid.equals("IHDR") ? new PngChunkIHDR(info) : (cid.equals("PLTE") ? new PngChunkPLTE(info) : (cid.equals("IEND") ? new PngChunkIEND(info) : (cid.equals("gAMA") ? new PngChunkGAMA(info) : (cid.equals("tEXt") ? new PngChunkTEXT(info) : (cid.equals("iTXt") ? new PngChunkOTHER(cid, info) : (cid.equals("zTXt") ? new PngChunkOTHER(cid, info) : (cid.equals("pHYs") ? new PngChunkPHYS(info) : (cid.equals("bKGD") ? new PngChunkBKGD(info) : (cid.equals("iCCP") ? new PngChunkICCP(info) : (cid.equals("tIME") ? new PngChunkTIME(info) : (cid.equals("tRNS") ? new PngChunkTRNS(info) : (cid.equals("cHRM") ? new PngChunkCHRM(info) : (cid.equals("sBIT") ? new PngChunkSBIT(info) : (cid.equals("sRGB") ? new PngChunkSRGB(info) : new PngChunkOTHER(cid, info))))))))))))))));
        return ctype;
    }

    protected ChunkRaw createEmptyChunk(int len, boolean alloc) {
        ChunkRaw c = new ChunkRaw(len, ChunkHelper.toBytes(this.id), alloc);
        return c;
    }

    public String toString() {
        return "chunk id= " + this.id + " (" + this.lenori + ") c=" + this.getClass().getSimpleName();
    }

    public int writeOrder() {
        if (this.id.equals(ChunkHelper.IHDR)) {
            return 0;
        }
        if (this.id.equals(ChunkHelper.PLTE)) {
            return 2;
        }
        if (this.id.equals(ChunkHelper.IDAT)) {
            return 4;
        }
        if (this.id.equals(ChunkHelper.IEND)) {
            return 6;
        }
        if (ChunkHelper.beforePLTE(this.id)) {
            return 1;
        }
        if (ChunkHelper.beforeIDAT(this.id)) {
            return 3;
        }
        return 5;
    }

    public int getWriteStatus() {
        return this.writeStatus;
    }

    public void setWriteStatus(int writeStatus) {
        this.writeStatus = writeStatus;
    }

    public void writeAndMarkAsWrite(OutputStream os) {
        if (this.getWriteStatus() >= 2) {
            throw new RuntimeException("bad write status");
        }
        ChunkRaw c = this.createChunk();
        if (c != null) {
            c.writeChunk(os);
        } else {
            System.err.println("null chunk ! for " + this);
        }
        this.setWriteStatus(3);
    }
}

