/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp.managed;

import java.sql.Connection;
import java.sql.SQLException;
import org.apache.commons.dbcp.DelegatingConnection;
import org.apache.commons.dbcp.managed.TransactionContext;
import org.apache.commons.dbcp.managed.TransactionContextListener;
import org.apache.commons.dbcp.managed.TransactionRegistry;
import org.apache.commons.pool.ObjectPool;

public class ManagedConnection
extends DelegatingConnection {
    private final ObjectPool pool;
    private final TransactionRegistry transactionRegistry;
    private final boolean accessToUnderlyingConnectionAllowed;
    private TransactionContext transactionContext;
    private boolean isSharedConnection;

    public ManagedConnection(ObjectPool objectPool, TransactionRegistry transactionRegistry, boolean bl) throws SQLException {
        super((Connection)null);
        this.pool = objectPool;
        this.transactionRegistry = transactionRegistry;
        this.accessToUnderlyingConnectionAllowed = bl;
        this.updateTransactionStatus();
    }

    protected void checkOpen() throws SQLException {
        super.checkOpen();
        this.updateTransactionStatus();
    }

    private void updateTransactionStatus() throws SQLException {
        if (this.transactionContext != null) {
            if (this.transactionContext.isActive()) {
                if (this.transactionContext != this.transactionRegistry.getActiveTransactionContext()) {
                    throw new SQLException("Connection can not be used while enlisted in another transaction");
                }
                return;
            }
            this.transactionComplete();
        }
        this.transactionContext = this.transactionRegistry.getActiveTransactionContext();
        if (this.transactionContext != null && this.transactionContext.getSharedConnection() != null) {
            Connection connection = this.getDelegateInternal();
            this.setDelegate(null);
            if (connection != null) {
                try {
                    this.pool.returnObject((Object)connection);
                }
                catch (Exception exception) {
                    try {
                        this.pool.invalidateObject((Object)connection);
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                }
            }
            this.transactionContext.addTransactionContextListener(new CompletionListener());
            this.setDelegate(this.transactionContext.getSharedConnection());
            this.isSharedConnection = true;
        } else {
            if (this.getDelegateInternal() == null) {
                try {
                    Connection connection = (Connection)this.pool.borrowObject();
                    this.setDelegate(connection);
                }
                catch (Exception exception) {
                    throw (SQLException)new SQLException("Unable to acquire a new connection from the pool").initCause(exception);
                }
            }
            if (this.transactionContext != null) {
                this.transactionContext.addTransactionContextListener(new CompletionListener());
                try {
                    this.transactionContext.setSharedConnection(this.getDelegateInternal());
                }
                catch (SQLException sQLException) {
                    this.transactionContext = null;
                    throw sQLException;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException {
        if (!this._closed) {
            try {
                if (this.transactionContext == null) {
                    this.getDelegateInternal().close();
                }
            }
            finally {
                this._closed = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void transactionComplete() {
        this.transactionContext = null;
        if (this.isSharedConnection) {
            this.setDelegate(null);
            this.isSharedConnection = false;
        }
        Connection connection = this.getDelegateInternal();
        if (this._closed && connection != null) {
            try {
                this.setDelegate(null);
                if (!connection.isClosed()) {
                    connection.close();
                }
            }
            catch (SQLException sQLException) {
            }
            finally {
                this._closed = true;
            }
        }
    }

    public void setAutoCommit(boolean bl) throws SQLException {
        if (this.transactionContext != null) {
            throw new SQLException("Auto-commit can not be set while enrolled in a transaction");
        }
        super.setAutoCommit(bl);
    }

    public void commit() throws SQLException {
        if (this.transactionContext != null) {
            throw new SQLException("Commit can not be set while enrolled in a transaction");
        }
        super.commit();
    }

    public void rollback() throws SQLException {
        if (this.transactionContext != null) {
            throw new SQLException("Commit can not be set while enrolled in a transaction");
        }
        super.rollback();
    }

    public void setReadOnly(boolean bl) throws SQLException {
        if (this.transactionContext != null) {
            throw new SQLException("Read-only can not be set while enrolled in a transaction");
        }
        super.setReadOnly(bl);
    }

    public boolean isAccessToUnderlyingConnectionAllowed() {
        return this.accessToUnderlyingConnectionAllowed;
    }

    public Connection getDelegate() {
        if (this.isAccessToUnderlyingConnectionAllowed()) {
            return this.getDelegateInternal();
        }
        return null;
    }

    public Connection getInnermostDelegate() {
        if (this.isAccessToUnderlyingConnectionAllowed()) {
            return super.getInnermostDelegateInternal();
        }
        return null;
    }

    protected class CompletionListener
    implements TransactionContextListener {
        protected CompletionListener() {
        }

        public void afterCompletion(TransactionContext transactionContext, boolean bl) {
            if (transactionContext == ManagedConnection.this.transactionContext) {
                ManagedConnection.this.transactionComplete();
            }
        }
    }
}

