/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.cisd.hotdeploy;

import ch.ethz.cisd.hotdeploy.PluginContainer;
import ch.ethz.cisd.hotdeploy.PluginContainerParameters;
import ch.ethz.cisd.hotdeploy.PluginDeploymentDesc;
import ch.ethz.cisd.hotdeploy.PluginDescriptor;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

final class PluginLoader
implements Runnable {
    private static final Log log = LogFactory.getLog(PluginLoader.class);
    private final long scanInterval;
    private final boolean requirePluginInfo;
    private PluginContainer container;
    private Map<File, PluginDeploymentDesc> pluginDescriptions;
    private Map<File, Set<File>> pluginDirToArchiveSetMap;
    private Map<String, Long> rejectedJarFiles;
    private volatile boolean keepRunning;
    private final Set<File> pluginDirectories;
    private final AtomicReference<CountDownLatch> syncRef;
    private Set<File> toBeDisabled;

    PluginLoader(PluginContainer container, PluginContainerParameters params) {
        this.scanInterval = params.getScanIntervalMillis();
        this.requirePluginInfo = params.isRequirePluginInfo();
        log.info((Object)("plugin scan interval set to: " + this.scanInterval + "ms."));
        this.container = container;
        this.pluginDescriptions = new HashMap<File, PluginDeploymentDesc>();
        this.pluginDirToArchiveSetMap = new HashMap<File, Set<File>>();
        this.rejectedJarFiles = new HashMap<String, Long>();
        this.toBeDisabled = Collections.synchronizedSet(new HashSet());
        this.keepRunning = true;
        this.syncRef = new AtomicReference();
        this.pluginDirectories = new LinkedHashSet<File>();
        this.pluginDirectories.addAll(params.getPluginDirs());
        log.info((Object)("plugin directories set to: " + this.pluginDirectories));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<File> getPluginDirectories() {
        HashSet<File> copy = new HashSet<File>();
        Set<File> set = this.pluginDirectories;
        synchronized (set) {
            copy.addAll(this.pluginDirectories);
        }
        return copy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addPluginDirectory(File pluginDirectory) {
        Set<File> set = this.pluginDirectories;
        synchronized (set) {
            this.pluginDirectories.add(pluginDirectory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addPluginDirectories(Collection<File> pluginDirectoriesToBeAdded) {
        Set<File> set = this.pluginDirectories;
        synchronized (set) {
            this.pluginDirectories.addAll(pluginDirectoriesToBeAdded);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removePluginDirectory(File pluginDirectory) {
        Set<File> set = this.pluginDirectories;
        synchronized (set) {
            this.pluginDirectories.remove(pluginDirectory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removePluginDirectories(Collection<File> pluginDirectoriesToBeRemoved) {
        Set<File> set = this.pluginDirectories;
        synchronized (set) {
            this.pluginDirectories.removeAll(pluginDirectoriesToBeRemoved);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setPluginDirectories(Collection<File> newPluginDirectories) {
        Set<File> set = this.pluginDirectories;
        synchronized (set) {
            this.pluginDirectories.clear();
            this.pluginDirectories.addAll(newPluginDirectories);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        log.info((Object)"PluginLoader thread started.");
        HashSet<File> archivesSeen = new HashSet<File>();
        CountDownLatch sync = this.syncRef.getAndSet(null);
        while (this.keepRunning) {
            try {
                long begin = System.nanoTime();
                archivesSeen.clear();
                List<File> currentPluginDirs = this.getPluginDirsWithCleanup();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("scanned plugin directories: " + currentPluginDirs));
                }
                for (File pluginDir : currentPluginDirs) {
                    Object[] pluginArchives = pluginDir.listFiles();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("entries found in directory " + pluginDir.getCanonicalPath() + ": " + Arrays.toString(pluginArchives)));
                    }
                    if (pluginArchives == null) continue;
                    for (Object pluginArchive : pluginArchives) {
                        if (this.checkArchiveIsRejected((File)pluginArchive) || this.checkArchiveIsDisabled((File)pluginArchive) || this.checkPathIsNoJarFile((File)pluginArchive)) continue;
                        archivesSeen.add((File)pluginArchive);
                        if (this.checkPathIsInvalidJarFile((File)pluginArchive)) continue;
                        this.processPlugin((File)pluginArchive);
                    }
                }
                this.unloadAndUnregisterVanishedArchives(archivesSeen);
                if (!log.isDebugEnabled()) continue;
                String ms = String.valueOf((double)(System.nanoTime() - begin) / 1000000.0);
                log.debug((Object)("plugin loader finished run in " + ms + "ms"));
            }
            catch (Throwable e) {
                if (e.getMessage() != null) {
                    log.error((Object)("Unhandled exception thrown in PluginLoader: " + e.getMessage()), e);
                    continue;
                }
                log.error((Object)"Unhandled exception thrown in PluginLoader: ", e);
            }
            finally {
                if (sync != null) {
                    sync.countDown();
                }
                if (!this.keepRunning) {
                    sync = this.syncRef.get();
                    if (sync == null) break;
                    sync.countDown();
                    break;
                }
                if (!Thread.interrupted()) {
                    this.sleep();
                }
                sync = this.syncRef.getAndSet(null);
            }
        }
        log.info((Object)"PluginLoader thread finished.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T tryRunLocked(File pluginArchive, ClassLoaderCallable<T> callable) {
        PluginDeploymentDesc desc = this.pluginDescriptions.get(pluginArchive);
        if (desc == null) {
            return null;
        }
        PluginDeploymentDesc pluginDeploymentDesc = desc;
        synchronized (pluginDeploymentDesc) {
            if (!desc.isLoaded()) {
                return null;
            }
            try {
                return callable.call(desc.getClassLoader());
            }
            catch (Exception ex) {
                log.error((Object)"Error running callable");
                return null;
            }
        }
    }

    private synchronized void sleep() {
        try {
            if (this.scanInterval < 0L) {
                while (true) {
                    this.wait();
                }
            }
            Thread.sleep(this.scanInterval);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<File> getPluginDirsWithCleanup() {
        ArrayList<File> currentPluginDirs = new ArrayList<File>(this.pluginDirectories.size());
        Set<File> set = this.pluginDirectories;
        synchronized (set) {
            currentPluginDirs.addAll(this.pluginDirectories);
            ArrayList<File> toBeRemoved = new ArrayList<File>();
            for (Map.Entry<File, Set<File>> p : this.pluginDirToArchiveSetMap.entrySet()) {
                File pluginDir = p.getKey();
                Set<File> archives = p.getValue();
                if (this.pluginDirectories.contains(pluginDir) || archives == null || archives.isEmpty()) continue;
                log.info((Object)("unregister all plugins in plugin directory " + pluginDir));
                for (File archive : archives) {
                    this.unloadAndUnregisterArchive(archive);
                }
                toBeRemoved.add(pluginDir);
            }
            if (!toBeRemoved.isEmpty()) {
                this.rejectedJarFiles.clear();
            }
            for (File pluginDir : toBeRemoved) {
                this.pluginDirToArchiveSetMap.remove(pluginDir);
            }
        }
        return currentPluginDirs;
    }

    private void unloadAndUnregisterVanishedArchives(Set<File> archivesSeen) {
        ArrayList<File> tmpToRemove = new ArrayList<File>();
        for (File archive : this.pluginDescriptions.keySet()) {
            if (archivesSeen.contains(archive)) continue;
            tmpToRemove.add(archive);
        }
        for (File archive : tmpToRemove) {
            this.unloadAndUnregisterArchive(archive);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unloadAndUnregisterArchive(File archive) {
        PluginDeploymentDesc desc = this.pluginDescriptions.remove(archive);
        if (desc == null) {
            return;
        }
        PluginDeploymentDesc pluginDeploymentDesc = desc;
        synchronized (pluginDeploymentDesc) {
            if (desc.isLoaded()) {
                try {
                    this.container.unregister(desc.getPluginDesc());
                    desc.unload();
                    log.info((Object)("remove archive " + archive));
                }
                catch (Exception pe) {
                    log.error((Object)("removal of plugin " + archive + " failed: " + pe.getMessage()), (Throwable)pe);
                }
            }
        }
    }

    private PluginDeploymentDesc processPlugin(File pluginArchive) {
        PluginDeploymentDesc desc = this.pluginDescriptions.get(pluginArchive);
        if (desc != null) {
            if (!pluginArchive.exists()) {
                this.unloadAndUnregisterArchive(pluginArchive);
            }
            this.processKnownPlugin(pluginArchive, desc);
        } else {
            this.processNewPlugin(pluginArchive);
        }
        return desc;
    }

    private void processNewPlugin(File pluginArchive) {
        PluginDeploymentDesc desc = new PluginDeploymentDesc(pluginArchive, this.requirePluginInfo);
        if (this.pluginConflicts(pluginArchive, desc)) {
            this.rejectedJarFiles.put(pluginArchive.getPath(), pluginArchive.lastModified());
            return;
        }
        log.info((Object)("load new archive " + pluginArchive));
        if (desc.isLoaded()) {
            try {
                this.container.register(desc.getPluginDesc(), true);
                this.pluginDescriptions.put(pluginArchive, desc);
                this.addArchiveToPluginDirMap(pluginArchive.getParentFile(), pluginArchive);
            }
            catch (Exception pe) {
                log.error((Object)("error registering plugin: " + pe.getMessage()), (Throwable)pe);
            }
        } else {
            log.error((Object)("no valid plugin found in: " + pluginArchive));
            this.rejectedJarFiles.put(pluginArchive.getPath(), pluginArchive.lastModified());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processKnownPlugin(File pluginArchive, PluginDeploymentDesc desc) {
        PluginDeploymentDesc pluginDeploymentDesc = desc;
        synchronized (pluginDeploymentDesc) {
            PluginDescriptor oldPluginDesc = desc.getPluginDesc();
            if (desc.updatePluginIfChanged()) {
                boolean newPlugin;
                PluginDescriptor newPluginDesc = desc.getPluginDesc();
                boolean bl = newPlugin = oldPluginDesc != null && !oldPluginDesc.getPluginClassname().equals(newPluginDesc.getPluginClassname());
                if (newPlugin) {
                    this.container.unregister(oldPluginDesc);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("archive " + pluginArchive.getName() + ": replacing plugin " + oldPluginDesc.getPluginClassname() + " with " + newPluginDesc.getPluginClassname()));
                    }
                }
                this.container.register(newPluginDesc, newPlugin);
            }
        }
    }

    private boolean pluginConflicts(File pluginArchive, PluginDeploymentDesc desc) {
        Class<?> pluginClass = desc.getPluginClass();
        if (pluginClass == null) {
            return false;
        }
        PluginDescriptor registeredPluginDesc = this.container.tryGetPluginDesc(pluginClass.getName(), true, false);
        if (registeredPluginDesc != null) {
            log.warn((Object)("ignoring new archive " + pluginArchive + " as plugin class " + desc.getPluginClass().getName() + " registered from " + registeredPluginDesc.getPluginArchive()));
            return true;
        }
        registeredPluginDesc = this.container.tryGetPluginDesc(desc.getPluginDesc().getPluginName(), false, false);
        if (registeredPluginDesc != null) {
            log.warn((Object)("ignoring new archive " + pluginArchive + " as plugin " + desc.getPluginDesc().getPluginName() + " (classname: " + desc.getPluginClass().getName() + ") is already registered from " + registeredPluginDesc.getPluginArchive()));
            return true;
        }
        return false;
    }

    private boolean checkPathIsInvalidJarFile(File pluginArchive) {
        if (!this.isValidJarArchive(pluginArchive)) {
            log.warn((Object)("archive is not a valid jar file: " + pluginArchive));
            this.rejectedJarFiles.put(pluginArchive.getPath(), pluginArchive.lastModified());
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isValidJarArchive(File file) {
        boolean isArchive = true;
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(file);
        }
        catch (ZipException zipCurrupted) {
            isArchive = false;
        }
        catch (IOException anyIOError) {
            isArchive = false;
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException ioe) {
                    log.error((Object)("Error while closing zip file: " + ioe.getMessage()), (Throwable)ioe);
                }
            }
        }
        return isArchive;
    }

    private boolean checkPathIsNoJarFile(File pluginArchive) {
        if (pluginArchive.isHidden() || !pluginArchive.isFile()) {
            return true;
        }
        return !pluginArchive.getName().endsWith(".jar");
    }

    private boolean checkArchiveIsRejected(File pluginArchive) {
        Long rejectedJarFileLastModified = this.rejectedJarFiles.get(pluginArchive.getPath());
        return rejectedJarFileLastModified != null && pluginArchive.lastModified() == rejectedJarFileLastModified.longValue();
    }

    private boolean checkArchiveIsDisabled(File pluginArchive) {
        if (this.toBeDisabled.contains(pluginArchive)) {
            if (pluginArchive.exists()) {
                System.runFinalization();
                System.gc();
                System.runFinalization();
                System.gc();
                if (this.disableArchiveFile(pluginArchive)) {
                    this.toBeDisabled.remove(pluginArchive);
                } else {
                    log.warn((Object)("plugin archive " + pluginArchive + " could not be disabled."));
                }
            } else {
                this.toBeDisabled.remove(pluginArchive);
            }
            return true;
        }
        return false;
    }

    private void addArchiveToPluginDirMap(File pluginDir, File archive) {
        Set<File> archivesInDir = this.pluginDirToArchiveSetMap.get(pluginDir);
        if (archivesInDir == null) {
            archivesInDir = new HashSet<File>();
            this.pluginDirToArchiveSetMap.put(pluginDir, archivesInDir);
        }
        archivesInDir.add(archive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean disablePlugin(File archive) {
        boolean disabled = false;
        if (archive == null) {
            log.warn((Object)"disable plugin called with null - ignoring.");
        } else {
            PluginDeploymentDesc desc = this.pluginDescriptions.get(archive.getName());
            if (desc == null) {
                log.warn((Object)("plugin with given archive name (" + archive + ") not found."));
            } else {
                PluginDeploymentDesc pluginDeploymentDesc = desc;
                synchronized (pluginDeploymentDesc) {
                    this.container.unregister(desc.getPluginDesc());
                    this.pluginDescriptions.remove(archive.getName());
                    log.info((Object)"plugin from plugin archive map removed.");
                    desc.unload();
                }
            }
            desc = null;
            System.gc();
            System.runFinalization();
            System.gc();
            System.runFinalization();
            if (this.disableArchiveFile(archive)) {
                this.toBeDisabled.remove(archive);
            } else {
                this.toBeDisabled.add(archive);
            }
            disabled = true;
        }
        return disabled;
    }

    private boolean disableArchiveFile(File archive) {
        if (!archive.isFile()) {
            return true;
        }
        return archive.renameTo(new File(archive.getAbsolutePath() + ".disabled"));
    }

    public boolean disablePlugin(Class<?> plugin) {
        if (plugin == null) {
            log.warn((Object)"disable plugin called with null - ignoring.");
            return false;
        }
        File archive = this.getArchive(plugin);
        if (archive == null) {
            String msg = "disable plugin: plugin not found (" + plugin.getName() + ").";
            log.error((Object)msg, (Throwable)new Exception(msg));
            return false;
        }
        return this.disablePlugin(archive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File getArchive(Class<?> pluginClass) {
        Iterator<PluginDeploymentDesc> i$ = this.pluginDescriptions.values().iterator();
        while (i$.hasNext()) {
            PluginDeploymentDesc desc;
            PluginDeploymentDesc pluginDeploymentDesc = desc = i$.next();
            synchronized (pluginDeploymentDesc) {
                if (desc.getPluginClass().getName().equals(pluginClass.getName())) {
                    return desc.getPluginArchive();
                }
            }
        }
        return null;
    }

    CountDownLatch getCycleFinishedBarrier() {
        CountDownLatch newSync;
        CountDownLatch sync;
        if (!this.keepRunning) {
            return new CountDownLatch(0);
        }
        do {
            if ((sync = this.syncRef.get()) == null) continue;
            return sync;
        } while (!this.syncRef.compareAndSet(sync, newSync = new CountDownLatch(1)));
        return newSync;
    }

    void notifyShutdown() {
        this.keepRunning = false;
    }

    void destroy() {
        for (PluginDeploymentDesc desc : this.pluginDescriptions.values()) {
            desc.unload();
        }
        log.info((Object)"All plugin archives unloaded.");
        this.pluginDescriptions.clear();
        this.pluginDescriptions = null;
        this.pluginDirToArchiveSetMap.clear();
        this.pluginDirToArchiveSetMap = null;
        this.toBeDisabled.clear();
        this.toBeDisabled = null;
        this.container = null;
        log.info((Object)"All resources released. PluginLoader finished.");
    }

    static interface ClassLoaderCallable<V> {
        public V call(ClassLoader var1) throws Exception;
    }
}

