/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.imagereaders.bioformats;

import ch.systemsx.cisd.imagereaders.bioformats.BioFormatsImageUtils;
import java.awt.FileDialog;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import javax.imageio.ImageIO;
import loci.formats.IFormatReader;
import loci.formats.gui.BufferedImageReader;

public class BioFormatsImageExtractor {
    public static void main(String[] args) throws Exception {
        String[] fileNames = args;
        if (args.length == 0) {
            FileDialog fileDialog = new FileDialog(null);
            fileDialog.setMode(0);
            fileDialog.setVisible(true);
            String dir = fileDialog.getDirectory();
            fileNames = new String[]{String.valueOf(dir) + "/" + fileDialog.getFile()};
        }
        String[] stringArray = fileNames;
        int n = fileNames.length;
        int n2 = 0;
        while (n2 < n) {
            String fileName = stringArray[n2];
            IFormatReader reader = BioFormatsImageUtils.tryToCreateReaderForFile(fileName);
            if (reader == null) {
                System.out.println("No reader found: " + fileName);
            } else {
                reader.setId(fileName);
                int seriesCount = reader.getSeriesCount();
                System.out.println("=========== file " + fileName + " has " + seriesCount + " series.");
                File imageFolder = new File(String.valueOf(fileName) + ".extracted-images");
                imageFolder.mkdirs();
                int s = 0;
                while (s < seriesCount) {
                    reader.setSeries(s);
                    File serieFolder = new File(imageFolder, "s" + s);
                    serieFolder.mkdirs();
                    int effectiveSizeC = reader.getEffectiveSizeC();
                    int sizeT = reader.getSizeT();
                    int sizeZ = reader.getSizeZ();
                    System.out.println(" Serie " + s + " has " + sizeT + " time points, " + sizeZ + " focal planes and " + effectiveSizeC + " color channels.");
                    int t = 0;
                    while (t < sizeT) {
                        int z = 0;
                        while (z < sizeZ) {
                            int c = 0;
                            while (c < effectiveSizeC) {
                                int index = reader.getIndex(z, c, t);
                                BufferedImageReader biReader = BufferedImageReader.makeBufferedImageReader((IFormatReader)reader);
                                BufferedImage image = biReader.openImage(index);
                                String imageName = "t" + t + "-z" + z + "-c" + c;
                                File imageFile = new File(serieFolder, String.valueOf(imageName) + ".png");
                                ImageIO.write((RenderedImage)image, "PNG", imageFile);
                                System.out.println("Image extracted into " + imageFile + " (" + index + ")");
                                ++c;
                            }
                            ++z;
                        }
                        ++t;
                    }
                    ++s;
                }
                reader.close();
            }
            ++n2;
        }
    }
}

