/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cina.dss.bundle.registrators;

import ch.systemsx.cisd.cina.dss.bundle.registrators.BundleDataSetHelper;
import ch.systemsx.cisd.cina.dss.bundle.registrators.BundleRegistrationState;
import ch.systemsx.cisd.cina.shared.metadata.CollectionMetadataExtractor;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.DataSetInformation;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample;
import ch.systemsx.cisd.openbis.generic.shared.dto.NewProperty;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifier;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class CollectionRawImagesRegistrator
extends BundleDataSetHelper {
    private final CollectionMetadataExtractor replicaMetadataExtractor;
    private final SampleIdentifier replicaSampleId;

    CollectionRawImagesRegistrator(BundleRegistrationState globalState, CollectionMetadataExtractor replicaMetadataExtractor, Sample replicaSample, SampleIdentifier replicaSampleId, File dataSet) {
        super(globalState, dataSet);
        this.replicaMetadataExtractor = replicaMetadataExtractor;
        this.replicaSampleId = replicaSampleId;
    }

    public List<DataSetInformation> register() {
        DataSetInformation rawDataDataSetInfo = this.createDataSetInformation();
        ArrayList<NewProperty> properties = this.createDataSetProperties(this.globalState.getRawImagesDataSetType(), this.replicaMetadataExtractor);
        rawDataDataSetInfo.setDataSetProperties(properties);
        this.registerDataSet(this.dataSet, rawDataDataSetInfo);
        return this.getDataSetInformation();
    }

    private DataSetInformation createDataSetInformation() {
        DataSetInformation imagesDataSetInfo = new DataSetInformation();
        imagesDataSetInfo.setSampleCode(this.replicaSampleId.getSampleCode());
        imagesDataSetInfo.setSpaceCode(this.replicaSampleId.getSpaceLevel().getSpaceCode());
        imagesDataSetInfo.setInstanceCode(this.replicaSampleId.getSpaceLevel().getDatabaseInstanceCode());
        imagesDataSetInfo.setDataSetType(this.globalState.getRawImagesDataSetType().getDataSetType());
        return imagesDataSetInfo;
    }
}

