/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cina.shared.metadata;

import ch.systemsx.cisd.cina.shared.labview.LVData;
import ch.systemsx.cisd.cina.shared.labview.LVDataParser;
import ch.systemsx.cisd.cina.shared.metadata.IMetadataExtractor;
import ch.systemsx.cisd.cina.shared.metadata.ImageMetadataExtractor;
import ch.systemsx.cisd.cina.shared.metadata.LabViewXMLToHashMap;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CollectionMetadataExtractor
implements IMetadataExtractor {
    private static final String REPLICA_METADATA_FILE_NAME = "CollectionMetadata.xml";
    private static final String REPLICA_SAMPLE_CODE_KEY = "database id";
    private static final String REPLICA_SAMPLE_DESCRIPTION_KEY = "description";
    private static final String REPLICA_SAMPLE_CREATOR_NAME = "author";
    private final ArrayList<ImageMetadataExtractor> metadataExtractors = new ArrayList();
    private final File folder;
    private final HashMap<String, String> metadataMap;
    private LVData lvdata;

    public static boolean doesFolderContainReplicaMetadata(File folder) {
        File metadataFile = new File(folder, REPLICA_METADATA_FILE_NAME);
        return metadataFile.exists();
    }

    public CollectionMetadataExtractor(File folder) {
        this.folder = folder;
        this.metadataMap = new HashMap();
    }

    public void prepare() {
        File[] collectionContents;
        if (this.lvdata != null) {
            return;
        }
        File metadataFile = new File(this.folder, REPLICA_METADATA_FILE_NAME);
        this.lvdata = LVDataParser.parse(metadataFile);
        if (this.lvdata == null) {
            throw new IllegalArgumentException("Could not parse metadata in file " + metadataFile.getAbsolutePath());
        }
        new LabViewXMLToHashMap(this.lvdata, this.metadataMap).appendIntoMap();
        File[] fileArray = collectionContents = this.folder.listFiles();
        int n = collectionContents.length;
        int n2 = 0;
        while (n2 < n) {
            File collectionFolder = fileArray[n2];
            if (collectionFolder.isDirectory()) {
                this.processCollectionItem(collectionFolder);
            }
            ++n2;
        }
    }

    @Override
    public Map<String, String> getMetadataMap() {
        this.checkPrepared();
        return this.metadataMap;
    }

    public List<ImageMetadataExtractor> getImageMetadataExtractors() {
        this.checkPrepared();
        return this.metadataExtractors;
    }

    public String tryReplicaSampleCode() {
        this.checkPrepared();
        return this.metadataMap.get(REPLICA_SAMPLE_CODE_KEY);
    }

    public String tryReplicaSampleDescription() {
        this.checkPrepared();
        return this.metadataMap.get(REPLICA_SAMPLE_DESCRIPTION_KEY);
    }

    public String tryReplicaSampleCreatorName() {
        this.checkPrepared();
        return this.metadataMap.get(REPLICA_SAMPLE_CREATOR_NAME);
    }

    public String getCollectionName() {
        return this.folder.getParentFile().getName();
    }

    public File getFolder() {
        return this.folder;
    }

    private void checkPrepared() {
        assert (this.lvdata != null);
    }

    private void processCollectionItem(File file) {
        if (!file.isDirectory()) {
            return;
        }
        if (!ImageMetadataExtractor.doesFolderContainImageMetadata(file)) {
            return;
        }
        ImageMetadataExtractor imageMetadataExtractor = new ImageMetadataExtractor(null, file);
        imageMetadataExtractor.prepare();
        this.metadataExtractors.add(imageMetadataExtractor);
    }
}

