/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.etl.dto;

import ch.systemsx.cisd.base.image.IImageTransformerFactory;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.transformations.IntensityRangeImageTransformerFactory;
import java.util.Map;

public class ImageTransfomationFactories {
    private Map<String, IImageTransformerFactory> singleChannelMap;
    private IImageTransformerFactory mergedChannels;
    private IImageTransformerFactory image;
    private IImageTransformerFactory defaultTransformationOrNull;
    private String defaultTransformationCodeOrNull;

    public IImageTransformerFactory tryGetForChannel(String transformationCodeOrNull) {
        if (transformationCodeOrNull == null) {
            return this.defaultTransformationOrNull;
        }
        if (transformationCodeOrNull.toLowerCase().startsWith("$USER_DEFINED_RESCALING$".toLowerCase())) {
            return this.getUserDefinedTransformationOrDefault(transformationCodeOrNull);
        }
        return this.singleChannelMap.get(transformationCodeOrNull);
    }

    public IImageTransformerFactory tryGetForMerged() {
        return this.mergedChannels;
    }

    public void setForChannel(Map<String, IImageTransformerFactory> singleChannelMap) {
        this.singleChannelMap = singleChannelMap;
    }

    public void setDefaultTransformation(String defaultTransformationCodeOrNull, IImageTransformerFactory defaultTransformationOrNull) {
        this.defaultTransformationCodeOrNull = defaultTransformationCodeOrNull;
        this.defaultTransformationOrNull = defaultTransformationOrNull;
    }

    public void setForMergedChannels(IImageTransformerFactory transformerFactoryForMergedChannels) {
        this.mergedChannels = transformerFactoryForMergedChannels;
    }

    public IImageTransformerFactory tryGetForImage() {
        return this.image;
    }

    public void setForImage(IImageTransformerFactory transformerFactoryForImage) {
        this.image = transformerFactoryForImage;
    }

    public String tryGetDefaultTransformationCode() {
        return this.defaultTransformationCodeOrNull;
    }

    private IImageTransformerFactory getUserDefinedTransformationOrDefault(String userDefinedTransformation) {
        String[] parameters = userDefinedTransformation.replaceAll("^.*\\(\\s*([0-9]+)\\s*,\\s*([0-9]+)\\s*\\)\\s*$", "$1,$2").split(",");
        if (parameters.length == 2) {
            try {
                int blackPoint = Integer.parseInt(parameters[0]);
                int whitePoint = Integer.parseInt(parameters[1]);
                return new IntensityRangeImageTransformerFactory(blackPoint, whitePoint);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return this.defaultTransformationOrNull;
    }
}

