/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.basic.dto.displaysettings;

import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ColumnSetting;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DisplaySettings;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.displaysettings.IDisplaySettingsUpdate;
import java.util.List;

public class ColumnDisplaySettingsUpdate
implements IDisplaySettingsUpdate {
    private static final long serialVersionUID = 1L;
    private String displayTypeId;
    private List<ColumnSetting> columnSettings;

    private ColumnDisplaySettingsUpdate() {
    }

    public ColumnDisplaySettingsUpdate(String displayTypeId, List<ColumnSetting> columnSettings) {
        if (displayTypeId == null) {
            throw new IllegalArgumentException("Display type id cannot be null");
        }
        this.displayTypeId = displayTypeId;
        this.columnSettings = columnSettings;
    }

    @Override
    public DisplaySettings update(DisplaySettings displaySettings) {
        displaySettings.getColumnSettings().put(this.displayTypeId, this.columnSettings);
        return displaySettings;
    }

    public String toString() {
        return "update of column settings for: " + this.displayTypeId;
    }
}

