/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.installer.izpack;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;

public class JarClassLoader
extends ClassLoader {
    private final List<JarFile> jarFiles = new ArrayList<JarFile>();
    private final Map<String, Class<?>> classes = new HashMap();

    public JarClassLoader(File jarFileOrFolder) {
        super(JarClassLoader.class.getClassLoader());
        this.addJarFile(jarFileOrFolder);
        if (jarFileOrFolder.isDirectory()) {
            File[] files;
            File[] fileArray = files = jarFileOrFolder.listFiles();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                this.addJarFile(file);
                ++n2;
            }
        }
    }

    private void addJarFile(File file) {
        if (file.isFile() && file.getName().endsWith(".jar")) {
            try {
                this.jarFiles.add(new JarFile(file));
            }
            catch (IOException ex) {
                throw CheckedExceptionTunnel.wrapIfNecessary(ex);
            }
        }
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        return this.findClass(name);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        Class<?> clazz = this.classes.get(name);
        if (clazz != null) {
            return clazz;
        }
        for (JarFile jarFile : this.jarFiles) {
            Class<?> clazz2;
            JarEntry jarEntry = jarFile.getJarEntry(String.valueOf(name.replace('.', '/')) + ".class");
            if (jarEntry == null) continue;
            InputStream inputStream = null;
            ByteArrayOutputStream outputStream = null;
            try {
                inputStream = jarFile.getInputStream(jarEntry);
                outputStream = new ByteArrayOutputStream();
                int b = inputStream.read();
                while (b >= 0) {
                    outputStream.write(b);
                    b = inputStream.read();
                }
                byte[] bytes = outputStream.toByteArray();
                clazz = this.defineClass(name, bytes, 0, bytes.length, null);
                this.classes.put(name, clazz);
                clazz2 = clazz;
                IOUtils.closeQuietly(inputStream);
            }
            catch (Exception exception) {
                continue;
            }
            finally {
                IOUtils.closeQuietly(inputStream);
                IOUtils.closeQuietly(outputStream);
            }
            IOUtils.closeQuietly(outputStream);
            return clazz2;
        }
        try {
            Class<?> systemClass = this.findSystemClass(name);
            return systemClass;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

