/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.merge.resolve;

import com.izforge.izpack.api.exception.IzPackException;
import com.izforge.izpack.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.ZipFile;

public class ResolveUtils {
    public static final String CLASSNAME_PREFIX = "com.izforge.izpack.panels";
    public static final String BASE_CLASSNAME_PATH = String.valueOf("com.izforge.izpack.panels".replaceAll("\\.", "/")) + "/";

    public static boolean isJar(URL url) {
        if ("jar".equals(url.getProtocol())) {
            return true;
        }
        String file = FileUtil.convertUrlToFilePath(url);
        if (file.contains("!")) {
            file = file.substring(0, file.lastIndexOf(33));
        }
        File classFile = new File(file);
        return ResolveUtils.isJar(classFile);
    }

    public static boolean isJar(File classFile) {
        ZipFile zipFile = null;
        try {
            try {
                zipFile = new ZipFile(classFile);
                zipFile.getName();
            }
            catch (IOException e) {
                if (zipFile != null) {
                    try {
                        zipFile.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                return false;
            }
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException iOException) {}
            }
        }
        return true;
    }

    public static boolean isFileInJar(URL resource) {
        return resource.getPath().matches(".*(\\.\\w+)");
    }

    public static String getCurrentClasspath() {
        StringBuilder stringBuilder = new StringBuilder();
        for (URL url : ResolveUtils.getClassPathUrl()) {
            stringBuilder.append(FileUtil.convertUrlToFilePath(url));
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }

    static Collection<URL> getClassPathUrl() {
        HashSet<URL> result = new HashSet<URL>();
        URLClassLoader loader = (URLClassLoader)Thread.currentThread().getContextClassLoader();
        result.addAll(Arrays.asList(loader.getURLs()));
        try {
            Enumeration<URL> urlEnumeration = loader.getResources("");
            result.addAll(Collections.list(urlEnumeration));
            urlEnumeration = loader.getResources("META-INF/");
            result.addAll(Collections.list(urlEnumeration));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    public static URL getFileFromPath(String path) {
        URL resource = ClassLoader.getSystemResource(path);
        if (resource != null) {
            return resource;
        }
        try {
            File file = new File(path);
            if (file.exists()) {
                return file.toURI().toURL();
            }
        }
        catch (MalformedURLException e) {
            throw new IzPackException(e);
        }
        return null;
    }

    public static Set<URL> getJarUrlForPackage(String packageName) {
        URLClassLoader loader = (URLClassLoader)Thread.currentThread().getContextClassLoader();
        HashSet<URL> result = new HashSet<URL>();
        try {
            Enumeration<URL> urls = loader.getResources(packageName);
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                JarURLConnection connection = (JarURLConnection)url.openConnection();
                result.add(connection.getJarFileURL());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    public static URL processUrlToJarUrl(URL url) throws MalformedURLException {
        return new URL("file", url.getHost(), ResolveUtils.processUrlToJarPath(url));
    }

    public static String processUrlToJarPath(URL resource) {
        String res = FileUtil.convertUrlToFilePath(resource);
        if ((res = res.replaceAll("file:", "")).contains("!")) {
            return res.substring(0, res.lastIndexOf("!"));
        }
        return res;
    }

    public static String processUrlToInsidePath(URL resource) {
        String path = resource.getPath();
        if (path.contains("!")) {
            return path.substring(path.lastIndexOf("!") + 2);
        }
        return path;
    }

    public static String processUrlToJarPackage(URL resource) {
        String res = FileUtil.convertUrlToFilePath(resource);
        res = res.replaceAll("file:", "");
        res = res.substring(res.lastIndexOf("!") + 1);
        if ((res = res.replaceAll("^/", "")).endsWith("/")) {
            return res;
        }
        return String.valueOf(res) + "/";
    }

    public static String getPanelsPackagePathFromClassName(String className) {
        if (className.contains(".")) {
            return String.valueOf(className.substring(0, className.lastIndexOf(".")).replaceAll("\\.", "/")) + "/";
        }
        return BASE_CLASSNAME_PATH;
    }

    public static boolean isFile(URL url) {
        return !FileUtil.convertUrlToFile(url).isDirectory();
    }

    public static String convertPathToPosixPath(String path) {
        return path.replaceAll("\\\\", "/");
    }

    public static String convertPathToPosixPath(File file) {
        return ResolveUtils.convertPathToPosixPath(file.getAbsolutePath());
    }
}

