/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.simplefinish;

import com.izforge.izpack.api.GuiId;
import com.izforge.izpack.api.data.ResourceManager;
import com.izforge.izpack.gui.IzPanelLayout;
import com.izforge.izpack.gui.LabelFactory;
import com.izforge.izpack.gui.log.Log;
import com.izforge.izpack.installer.base.InstallerFrame;
import com.izforge.izpack.installer.base.IzPanel;
import com.izforge.izpack.installer.data.GUIInstallData;
import com.izforge.izpack.installer.data.UninstallDataWriter;
import java.awt.Component;
import java.io.File;
import javax.swing.Icon;
import javax.swing.JLabel;

public class SimpleFinishPanel
extends IzPanel {
    private static final long serialVersionUID = 3689911781942572085L;
    private UninstallDataWriter uninstallDataWriter;

    public SimpleFinishPanel(InstallerFrame parent, GUIInstallData idata, ResourceManager resourceManager, UninstallDataWriter uninstallDataWriter) {
        super(parent, idata, new IzPanelLayout(), resourceManager);
        this.uninstallDataWriter = uninstallDataWriter;
    }

    @Override
    public boolean isValidated() {
        return true;
    }

    @Override
    public void panelActivate() {
        this.parent.lockNextButton();
        this.parent.lockPrevButton();
        this.parent.setQuitButtonText(this.installData.getLangpack().getString("FinishPanel.done"));
        this.parent.setQuitButtonIcon("done");
        if (this.installData.isInstallSuccess()) {
            this.add(LabelFactory.create((Icon)this.parent.getIcons().get("check")));
            this.add(IzPanelLayout.createVerticalStrut(5));
            JLabel jLabel = LabelFactory.create(this.installData.getLangpack().getString("FinishPanel.success"), (Icon)this.parent.getIcons().get("preferences"), 10);
            jLabel.setName(GuiId.SIMPLE_FINISH_LABEL.id);
            this.add((Component)jLabel, "nextLine");
            this.add(IzPanelLayout.createVerticalStrut(5));
            if (this.uninstallDataWriter.isUninstallShouldBeWriten()) {
                String path = this.translatePath(this.installData.getInfo().getUninstallerPath());
                JLabel uninstallJLabel = LabelFactory.create(this.installData.getLangpack().getString("FinishPanel.uninst.info"), (Icon)this.parent.getIcons().get("preferences"), 10);
                uninstallJLabel.setName(GuiId.SIMPLE_FINISH_UNINSTALL_LABEL.id);
                this.add((Component)uninstallJLabel, "nextLine");
                this.add((Component)LabelFactory.create(path, (Icon)this.parent.getIcons().get("empty"), 10), "nextLine");
            }
        } else {
            this.add(LabelFactory.create(this.installData.getLangpack().getString("FinishPanel.fail"), (Icon)this.parent.getIcons().get("stop"), 10));
        }
        this.getLayoutHelper().completeLayout();
        Log.getInstance().informUser();
    }

    private String translatePath(String destination) {
        try {
            destination = this.variableSubstitutor.substitute(destination);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return destination.replace('/', File.separatorChar);
    }
}

