/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util.file.types;

import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.file.DirectoryScanner;
import com.izforge.izpack.util.file.FileScanner;
import com.izforge.izpack.util.file.types.DataType;
import com.izforge.izpack.util.file.types.PatternSet;
import com.izforge.izpack.util.file.types.selectors.AndSelector;
import com.izforge.izpack.util.file.types.selectors.ContainsRegexpSelector;
import com.izforge.izpack.util.file.types.selectors.ContainsSelector;
import com.izforge.izpack.util.file.types.selectors.DateSelector;
import com.izforge.izpack.util.file.types.selectors.DependSelector;
import com.izforge.izpack.util.file.types.selectors.DepthSelector;
import com.izforge.izpack.util.file.types.selectors.DifferentSelector;
import com.izforge.izpack.util.file.types.selectors.ExtendSelector;
import com.izforge.izpack.util.file.types.selectors.FileSelector;
import com.izforge.izpack.util.file.types.selectors.FilenameSelector;
import com.izforge.izpack.util.file.types.selectors.MajoritySelector;
import com.izforge.izpack.util.file.types.selectors.NoneSelector;
import com.izforge.izpack.util.file.types.selectors.NotSelector;
import com.izforge.izpack.util.file.types.selectors.OrSelector;
import com.izforge.izpack.util.file.types.selectors.PresentSelector;
import com.izforge.izpack.util.file.types.selectors.SelectSelector;
import com.izforge.izpack.util.file.types.selectors.SelectorContainer;
import com.izforge.izpack.util.file.types.selectors.SelectorScanner;
import com.izforge.izpack.util.file.types.selectors.SizeSelector;
import com.izforge.izpack.util.file.types.selectors.TypeSelector;
import java.io.File;
import java.util.Enumeration;
import java.util.Vector;

public class FileSet
extends DataType
implements Cloneable,
SelectorContainer {
    private PatternSet defaultPatterns = new PatternSet();
    private Vector<PatternSet> additionalPatterns = new Vector();
    private Vector<FileSelector> selectors = new Vector();
    private File dir;
    private boolean useDefaultExcludes = true;
    private boolean isCaseSensitive = true;
    private boolean followSymlinks = true;

    public void setDir(File dir) throws Exception {
        this.dir = dir;
    }

    public File getDir() {
        return this.dir;
    }

    public PatternSet.NameEntry createInclude() {
        return this.defaultPatterns.createInclude();
    }

    public PatternSet.NameEntry createExclude() {
        return this.defaultPatterns.createExclude();
    }

    public void setFile(File file) throws Exception {
        this.setDir(file.getParentFile());
        this.createInclude().setName(file.getName());
    }

    public void setIncludes(String includes) {
        this.defaultPatterns.setIncludes(includes);
    }

    public void setExcludes(String excludes) {
        this.defaultPatterns.setExcludes(excludes);
    }

    public void setDefaultexcludes(boolean useDefaultExcludes) {
        this.useDefaultExcludes = useDefaultExcludes;
    }

    public boolean getDefaultexcludes() {
        return this.useDefaultExcludes;
    }

    public void setCaseSensitive(boolean isCaseSensitive) {
        this.isCaseSensitive = isCaseSensitive;
    }

    public void setFollowSymlinks(boolean followSymlinks) {
        this.followSymlinks = followSymlinks;
    }

    public boolean isFollowSymlinks() {
        return this.followSymlinks;
    }

    public DirectoryScanner getDirectoryScanner() throws Exception {
        if (this.dir == null) {
            throw new Exception("No directory specified for fileset");
        }
        if (!this.dir.exists()) {
            throw new Exception(String.valueOf(this.dir.getAbsolutePath()) + " not found.");
        }
        if (!this.dir.isDirectory()) {
            throw new Exception(String.valueOf(this.dir.getAbsolutePath()) + " is not a directory.");
        }
        DirectoryScanner ds = new DirectoryScanner();
        this.setupDirectoryScanner(ds);
        ds.setFollowSymlinks(this.followSymlinks);
        ds.scan();
        return ds;
    }

    public void setupDirectoryScanner(FileScanner ds) {
        if (ds == null) {
            throw new IllegalArgumentException("ds cannot be null");
        }
        ds.setBasedir(this.dir);
        int count = this.additionalPatterns.size();
        int i = 0;
        while (i < count) {
            PatternSet o = this.additionalPatterns.elementAt(i);
            this.defaultPatterns.append(o);
            ++i;
        }
        Debug.log("Fileset setup scanner in dir " + this.dir + " with " + this.defaultPatterns);
        ds.setIncludes(this.defaultPatterns.getIncludePatterns());
        ds.setExcludes(this.defaultPatterns.getExcludePatterns());
        if (ds instanceof SelectorScanner) {
            SelectorScanner ss = (SelectorScanner)((Object)ds);
            ss.setSelectors(this.getSelectors());
        }
        if (this.useDefaultExcludes) {
            ds.addDefaultExcludes();
        }
        ds.setCaseSensitive(this.isCaseSensitive);
    }

    @Override
    public boolean hasSelectors() {
        return !this.selectors.isEmpty();
    }

    public boolean hasPatterns() {
        if (this.defaultPatterns.hasPatterns()) {
            return true;
        }
        Enumeration<PatternSet> e = this.additionalPatterns.elements();
        while (e.hasMoreElements()) {
            PatternSet ps = e.nextElement();
            if (!ps.hasPatterns()) continue;
            return true;
        }
        return false;
    }

    @Override
    public int selectorCount() {
        return this.selectors.size();
    }

    @Override
    public FileSelector[] getSelectors() {
        return this.selectors.toArray(new FileSelector[this.selectors.size()]);
    }

    @Override
    public Enumeration<FileSelector> selectorElements() {
        return this.selectors.elements();
    }

    @Override
    public void appendSelector(FileSelector selector) {
        this.selectors.addElement(selector);
    }

    @Override
    public void addSelector(SelectSelector selector) {
        this.appendSelector(selector);
    }

    @Override
    public void addAnd(AndSelector selector) {
        this.appendSelector(selector);
    }

    @Override
    public void addOr(OrSelector selector) {
        this.appendSelector(selector);
    }

    @Override
    public void addNot(NotSelector selector) {
        this.appendSelector(selector);
    }

    @Override
    public void addNone(NoneSelector selector) {
        this.appendSelector(selector);
    }

    @Override
    public void addMajority(MajoritySelector selector) {
        this.appendSelector(selector);
    }

    @Override
    public void addDate(DateSelector selector) {
        this.appendSelector(selector);
    }

    @Override
    public void addSize(SizeSelector selector) {
        this.appendSelector(selector);
    }

    @Override
    public void addDifferent(DifferentSelector selector) {
        this.appendSelector(selector);
    }

    @Override
    public void addFilename(FilenameSelector selector) {
        this.appendSelector(selector);
    }

    @Override
    public void addType(TypeSelector selector) {
        this.appendSelector(selector);
    }

    @Override
    public void addCustom(ExtendSelector selector) {
        this.appendSelector(selector);
    }

    @Override
    public void addContains(ContainsSelector selector) {
        this.appendSelector(selector);
    }

    @Override
    public void addPresent(PresentSelector selector) {
        this.appendSelector(selector);
    }

    @Override
    public void addDepth(DepthSelector selector) {
        this.appendSelector(selector);
    }

    @Override
    public void addDepend(DependSelector selector) {
        this.appendSelector(selector);
    }

    @Override
    public void addContainsRegexp(ContainsRegexpSelector selector) {
        this.appendSelector(selector);
    }

    @Override
    public void add(FileSelector selector) {
        this.appendSelector(selector);
    }
}

