/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util.file.types.selectors;

import com.izforge.izpack.api.data.AutomatedInstallData;
import com.izforge.izpack.util.file.types.Parameter;
import com.izforge.izpack.util.file.types.selectors.BaseExtendSelector;
import com.izforge.izpack.util.file.types.selectors.SelectorUtils;
import java.io.File;

public class FilenameSelector
extends BaseExtendSelector {
    private String pattern = null;
    private boolean casesensitive = true;
    private boolean negated = false;
    public static final String NAME_KEY = "name";
    public static final String CASE_KEY = "casesensitive";
    public static final String NEGATE_KEY = "negate";

    public String toString() {
        StringBuffer buf = new StringBuffer("{filenameselector name: ");
        buf.append(this.pattern);
        buf.append(" negate: ");
        if (this.negated) {
            buf.append("true");
        } else {
            buf.append("false");
        }
        buf.append(" casesensitive: ");
        if (this.casesensitive) {
            buf.append("true");
        } else {
            buf.append("false");
        }
        buf.append("}");
        return buf.toString();
    }

    public void setName(String pattern) {
        if ((pattern = pattern.replace('/', File.separatorChar).replace('\\', File.separatorChar)).endsWith(File.separator)) {
            pattern = String.valueOf(pattern) + "**";
        }
        this.pattern = pattern;
    }

    public void setCasesensitive(boolean casesensitive) {
        this.casesensitive = casesensitive;
    }

    public void setNegate(boolean negated) {
        this.negated = negated;
    }

    @Override
    public void setParameters(Parameter[] parameters) {
        super.setParameters(parameters);
        if (parameters != null) {
            Parameter[] parameterArray = parameters;
            int n = parameters.length;
            int n2 = 0;
            while (n2 < n) {
                Parameter parameter = parameterArray[n2];
                String paramname = parameter.getName();
                if (NAME_KEY.equalsIgnoreCase(paramname)) {
                    this.setName(parameter.getValue());
                } else if (CASE_KEY.equalsIgnoreCase(paramname)) {
                    this.setCasesensitive(Boolean.parseBoolean(parameter.getValue()));
                } else if (NEGATE_KEY.equalsIgnoreCase(paramname)) {
                    this.setNegate(Boolean.parseBoolean(parameter.getValue()));
                } else {
                    this.setError("Invalid parameter " + paramname);
                }
                ++n2;
            }
        }
    }

    @Override
    public void verifySettings() {
        if (this.pattern == null) {
            this.setError("The name attribute is required");
        }
    }

    @Override
    public boolean isSelected(AutomatedInstallData idata, File basedir, String filename, File file) throws Exception {
        this.validate();
        return SelectorUtils.matchPath(this.pattern, filename, this.casesensitive) == !this.negated;
    }
}

