/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.api.v1.dto;

import ch.systemsx.cisd.base.annotation.JsonObject;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.EntityRegistrationDetails;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.MaterialIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.MaterialTypeIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.util.JsonPropertyUtil;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Metaproject;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

@JsonObject(value="MaterialGeneric")
public class Material
extends MaterialIdentifier
implements IIdHolder {
    private static final long serialVersionUID = 1L;
    private Long id;
    private Map<String, String> properties;
    private Map<String, Material> materialProperties;
    private EntityRegistrationDetails registrationDetails;
    private List<Metaproject> metaprojects;

    public Material(MaterialInitializer initializer) {
        super(initializer.getMaterialTypeIdentifier(), initializer.getMaterialCode());
        this.id = initializer.getId();
        this.properties = initializer.getProperties();
        this.materialProperties = initializer.getMaterialProperties();
        this.registrationDetails = initializer.getRegistrationDetails();
        this.metaprojects = initializer.getMetaprojects();
    }

    @JsonIgnore
    public Long getId() {
        return this.id;
    }

    public Map<String, String> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public Map<String, Material> getMaterialProperties() {
        return Collections.unmodifiableMap(this.materialProperties);
    }

    public EntityRegistrationDetails getRegistrationDetails() {
        return this.registrationDetails;
    }

    public List<Metaproject> getMetaprojects() throws IllegalArgumentException {
        if (this.metaprojects == null) {
            return Collections.unmodifiableList(new ArrayList());
        }
        return Collections.unmodifiableList(this.metaprojects);
    }

    private Material() {
        super(null, null);
    }

    @JsonProperty(value="id")
    private String getIdAsString() {
        return JsonPropertyUtil.toStringOrNull(this.id);
    }

    private void setIdAsString(String id) {
        this.id = JsonPropertyUtil.toLongOrNull(id);
    }

    private void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    private void setMaterialProperties(Map<String, Material> materialProperties) {
        this.materialProperties = materialProperties;
    }

    private void setRegistrationDetails(EntityRegistrationDetails registrationDetails) {
        this.registrationDetails = registrationDetails;
    }

    private void setMetaProjects(List<Metaproject> metaprojects) {
        this.metaprojects = metaprojects;
    }

    public static final class MaterialInitializer {
        private MaterialTypeIdentifier materialTypeIdentifier;
        private Long id;
        private String materialCode;
        private Map<String, String> properties;
        private Map<String, Material> materialProperties;
        private EntityRegistrationDetails registrationDetails;
        private List<Metaproject> metaprojects = new ArrayList<Metaproject>();

        public MaterialTypeIdentifier getMaterialTypeIdentifier() {
            return this.materialTypeIdentifier;
        }

        public void setMaterialTypeIdentifier(MaterialTypeIdentifier materialTypeIdentifier) {
            this.materialTypeIdentifier = materialTypeIdentifier;
        }

        public Long getId() {
            return this.id;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public String getMaterialCode() {
            return this.materialCode;
        }

        public void setMaterialCode(String materialCode) {
            this.materialCode = materialCode;
        }

        public Map<String, String> getProperties() {
            return this.properties;
        }

        public void setProperties(Map<String, String> properties) {
            this.properties = properties;
        }

        public Map<String, Material> getMaterialProperties() {
            return this.materialProperties;
        }

        public void setMaterialProperties(Map<String, Material> materialProperties) {
            this.materialProperties = materialProperties;
        }

        public List<Metaproject> getMetaprojects() {
            return this.metaprojects;
        }

        public void addMetaproject(Metaproject metaproject) {
            this.metaprojects.add(metaproject);
        }

        public EntityRegistrationDetails getRegistrationDetails() {
            return this.registrationDetails;
        }

        public void setRegistrationDetails(EntityRegistrationDetails registrationDetails) {
            this.registrationDetails = registrationDetails;
        }
    }
}

