/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.api.v1.dto;

import ch.systemsx.cisd.base.annotation.JsonObject;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.InitializingChecks;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataTypeCode;
import java.io.Serializable;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

@JsonObject(value="PropertyType")
public class PropertyType
implements Serializable {
    private static final long serialVersionUID = 1L;
    private DataTypeCode dataType;
    private String code;
    private String label;
    private String description;
    private boolean mandatory;

    public PropertyType(PropertyTypeInitializer initializer) {
        if (initializer.dataType == null) {
            throw new IllegalArgumentException("Unspecified data type.");
        }
        this.dataType = initializer.getDataType();
        InitializingChecks.checkValidString(initializer.getCode(), "Unspecified code.");
        this.code = initializer.getCode();
        InitializingChecks.checkValidString(initializer.getLabel(), "Unspecified label.");
        this.label = initializer.getLabel();
        this.description = initializer.getDescription();
        this.mandatory = initializer.isMandatory();
    }

    public DataTypeCode getDataType() {
        return this.dataType;
    }

    public String getCode() {
        return this.code;
    }

    public String getLabel() {
        return this.label;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isMandatory() {
        return this.mandatory;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PropertyType)) {
            return false;
        }
        EqualsBuilder builder = new EqualsBuilder();
        PropertyType other = (PropertyType)obj;
        builder.append((Object)this.getCode(), (Object)other.getCode());
        return builder.isEquals();
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.getCode());
        return builder.toHashCode();
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
        builder.append((Object)this.getDataType());
        builder.append((Object)this.getCode());
        builder.append((Object)this.getLabel());
        builder.append((Object)this.getDescription());
        builder.append((Object)(this.isMandatory() ? "mandatory" : "optional"));
        this.appendFieldsToStringBuilder(builder);
        return builder.toString();
    }

    protected void appendFieldsToStringBuilder(ToStringBuilder builder) {
    }

    PropertyType() {
    }

    private void setDataType(DataTypeCode dataType) {
        this.dataType = dataType;
    }

    private void setCode(String code) {
        this.code = code;
    }

    private void setLabel(String label) {
        this.label = label;
    }

    private void setDescription(String description) {
        this.description = description;
    }

    private void setMandatory(boolean mandatory) {
        this.mandatory = mandatory;
    }

    public static class PropertyTypeInitializer {
        private DataTypeCode dataType;
        private String code;
        private String label;
        private String description;
        private boolean mandatory;

        public DataTypeCode getDataType() {
            return this.dataType;
        }

        public void setDataType(DataTypeCode dataType) {
            this.dataType = dataType;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public boolean isMandatory() {
            return this.mandatory;
        }

        public void setMandatory(boolean mandatory) {
            this.mandatory = mandatory;
        }
    }
}

