/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.basic.dto;

import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetTypePropertyType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityTypePropertyType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ExperimentType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ExperimentTypePropertyType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MaterialType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MaterialTypePropertyType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewETPTAssignment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewPTNewAssigment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleTypePropertyType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Script;
import java.io.Serializable;
import java.util.List;

public class NewETNewPTAssigments
implements Serializable {
    private EntityType entity;
    private List<NewPTNewAssigment> assigments;

    public EntityType getEntity() {
        return this.entity;
    }

    public void setEntity(EntityType entity) {
        this.entity = entity;
    }

    public List<NewPTNewAssigment> getAssigments() {
        return this.assigments;
    }

    public void setAssigments(List<NewPTNewAssigment> assigments) {
        this.assigments = assigments;
    }

    public boolean isNewPropertyType(String code) {
        int i = 0;
        while (i < this.entity.getAssignedPropertyTypes().size()) {
            if (this.entity.getAssignedPropertyTypes().get(i).getPropertyType().getCode().equals(code)) {
                return !this.assigments.get(i).isExistingPropertyType();
            }
            ++i;
        }
        return false;
    }

    public void updateCodeFromNewPropertyType(String currentCode, String newCode) {
        if (this.isNewPropertyType(currentCode)) {
            int i = 0;
            while (i < this.entity.getAssignedPropertyTypes().size()) {
                if (this.entity.getAssignedPropertyTypes().get(i).getPropertyType().getCode().equals(currentCode)) {
                    this.entity.getAssignedPropertyTypes().get(i).getPropertyType().setCode(newCode);
                    this.assigments.get(i).getPropertyType().setCode(newCode);
                    this.assigments.get(i).getAssignment().setPropertyTypeCode(newCode);
                }
                ++i;
            }
        } else {
            throw new RuntimeException("A code from an existing property type can't be modified.");
        }
    }

    public void updateOrdinalToDBOrder() {
        int i = 0;
        while (i < this.entity.getAssignedPropertyTypes().size()) {
            this.entity.getAssignedPropertyTypes().get(i).setOrdinal(Long.valueOf(i));
            this.assigments.get(i).getAssignment().setOrdinal(Long.valueOf(i));
            ++i;
        }
    }

    public void updateOrdinalToGridOrder() {
        int i = 0;
        while (i < this.entity.getAssignedPropertyTypes().size()) {
            this.entity.getAssignedPropertyTypes().get(i).setOrdinal((long)i + 1L);
            this.assigments.get(i).getAssignment().setOrdinal((long)i + 1L);
            ++i;
        }
    }

    public void refreshOrderAdd(NewPTNewAssigment newAssigment) throws Exception {
        if (this.isAssigmentFound(newAssigment)) {
            throw new Exception("A property can't be assigned twice.");
        }
        this.updateOrdinalToDBOrder();
        int insertPos = newAssigment.getAssignment().getOrdinal().intValue();
        EntityTypePropertyType<?> newEtpt = NewETNewPTAssigments.getEntityTypePropertyType(this.entity, newAssigment);
        switch (this.entity.getEntityKind()) {
            case SAMPLE: {
                SampleType sampleType = (SampleType)this.entity;
                sampleType.getAssignedPropertyTypes().add(insertPos, (SampleTypePropertyType)newEtpt);
                break;
            }
            case EXPERIMENT: {
                ExperimentType experimentType = (ExperimentType)this.entity;
                experimentType.getAssignedPropertyTypes().add(insertPos, (ExperimentTypePropertyType)newEtpt);
                break;
            }
            case DATA_SET: {
                DataSetType datasetType = (DataSetType)this.entity;
                datasetType.getAssignedPropertyTypes().add(insertPos, (DataSetTypePropertyType)newEtpt);
                break;
            }
            case MATERIAL: {
                MaterialType materialType = (MaterialType)this.entity;
                materialType.getAssignedPropertyTypes().add(insertPos, (MaterialTypePropertyType)newEtpt);
            }
        }
        this.assigments.add(insertPos, newAssigment);
        this.updateOrdinalToGridOrder();
    }

    public void refreshOrderDelete(String code) {
        this.updateOrdinalToDBOrder();
        int i = 0;
        while (i < this.entity.getAssignedPropertyTypes().size()) {
            if (this.entity.getAssignedPropertyTypes().get(i).getPropertyType().getCode().equals(code)) {
                this.entity.getAssignedPropertyTypes().remove(i);
                this.assigments.remove(i);
                break;
            }
            ++i;
        }
        this.updateOrdinalToGridOrder();
    }

    public void refreshOrderUpdate(NewETPTAssignment toRegister) throws Exception {
        this.updateOrdinalToDBOrder();
        NewPTNewAssigment current = null;
        for (NewPTNewAssigment assigment : this.assigments) {
            if (!assigment.getAssignment().getPropertyTypeCode().equals(toRegister.getPropertyTypeCode())) continue;
            current = assigment;
            break;
        }
        long currentOrdinal = current.getAssignment().getOrdinal();
        long newOrdinal = toRegister.getOrdinal();
        if (newOrdinal > currentOrdinal) {
            toRegister.setOrdinal(toRegister.getOrdinal() - 1L);
        }
        this.updateOrdinalToGridOrder();
        this.refreshOrderDelete(toRegister.getPropertyTypeCode());
        current.setAssignment(toRegister);
        this.refreshOrderAdd(current);
    }

    public boolean isAssigmentFound(NewPTNewAssigment assigment) {
        for (NewPTNewAssigment assigmentFound : this.assigments) {
            if (!assigmentFound.getPropertyType().getCode().equals(assigment.getPropertyType().getCode())) continue;
            return true;
        }
        return false;
    }

    public static EntityTypePropertyType<?> getEntityTypePropertyType(EntityType entityType, NewPTNewAssigment propertyTypeAsg) {
        EntityTypePropertyType etpt = null;
        switch (entityType.getEntityKind()) {
            case SAMPLE: {
                etpt = new SampleTypePropertyType();
                etpt.setEntityType((SampleType)entityType);
                break;
            }
            case EXPERIMENT: {
                etpt = new ExperimentTypePropertyType();
                ((ExperimentTypePropertyType)etpt).setEntityType((ExperimentType)entityType);
                break;
            }
            case DATA_SET: {
                etpt = new DataSetTypePropertyType();
                ((DataSetTypePropertyType)etpt).setEntityType((DataSetType)entityType);
                break;
            }
            case MATERIAL: {
                etpt = new MaterialTypePropertyType();
                ((MaterialTypePropertyType)etpt).setEntityType((MaterialType)entityType);
            }
        }
        etpt.setPropertyType(propertyTypeAsg.getPropertyType());
        etpt.setOrdinal(propertyTypeAsg.getAssignment().getOrdinal());
        etpt.setSection(propertyTypeAsg.getAssignment().getSection());
        etpt.setMandatory(propertyTypeAsg.getAssignment().isMandatory());
        etpt.setDynamic(propertyTypeAsg.getAssignment().isDynamic());
        etpt.setManaged(propertyTypeAsg.getAssignment().isManaged());
        etpt.setShownInEditView(propertyTypeAsg.getAssignment().isShownInEditView());
        etpt.setShowRawValue(propertyTypeAsg.getAssignment().getShowRawValue());
        etpt.setModificationDate(propertyTypeAsg.getAssignment().getModificationDate());
        if (propertyTypeAsg.getAssignment().getScriptName() != null) {
            Script scriptNew = new Script();
            scriptNew.setName(propertyTypeAsg.getAssignment().getScriptName());
            etpt.setScript(scriptNew);
        }
        return etpt;
    }
}

