/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.security;

import ch.rinn.restrictions.Private;
import java.io.Serializable;
import java.security.SecureRandom;
import java.util.Formatter;

public final class TokenGenerator
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Private
    static final String TIMESTAMP_FORMAT = "%1$ty%1$tm%1$td%1$tH%1$tM%1$tS%1$tL";
    private static final char DEFAULT_SEPARATOR = '-';
    private final SecureRandom pseudoRandomNumberGenerator = new SecureRandom();

    public synchronized String getNewToken(long timeStamp) {
        return this.getNewToken(timeStamp, '-');
    }

    public synchronized String getNewToken(long timeStamp, char separator) {
        Formatter formatter = new Formatter();
        byte[] bytes = new byte[16];
        formatter.format(TIMESTAMP_FORMAT, timeStamp);
        formatter.format("" + separator, new Object[0]);
        this.pseudoRandomNumberGenerator.nextBytes(bytes);
        TokenGenerator.hexify(formatter, bytes);
        return formatter.toString();
    }

    private static void hexify(Formatter formatter, byte[] bytes) {
        byte[] byArray = bytes;
        int n = bytes.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            formatter.format("%02X", b);
            ++n2;
        }
    }
}

