/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.common.conversation.message;

import ch.systemsx.cisd.common.serviceconversation.server.ServiceConversationServer;
import ch.systemsx.cisd.openbis.common.conversation.annotation.Conversational;
import ch.systemsx.cisd.openbis.common.conversation.annotation.Progress;
import ch.systemsx.cisd.openbis.common.conversation.context.ServiceConversationsThreadContext;
import ch.systemsx.cisd.openbis.common.conversation.progress.IServiceConversationProgressListener;
import ch.systemsx.cisd.openbis.common.conversation.progress.ServiceConversationAutomaticProgressListener;
import ch.systemsx.cisd.openbis.common.conversation.progress.ServiceConversationRateLimitedProgressListener;
import java.io.Serializable;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.springframework.remoting.support.RemoteInvocation;

public class ServiceConversationMethodInvocation
implements Serializable {
    private static final long serialVersionUID = 8679256131459236150L;
    private RemoteInvocation invocation;

    public ServiceConversationMethodInvocation(String methodName, Class<?>[] parameterTypes, Object[] arguments2) {
        this.invocation = new RemoteInvocation(methodName, parameterTypes, arguments2);
    }

    public Serializable executeOn(Object target, ServiceConversationServer server, String conversationId, int progressInterval) {
        IServiceConversationProgressListener progressListener = null;
        try {
            Method m = this.findMethodOn(target);
            progressListener = this.createProgressListener(server, conversationId, progressInterval, m);
            ServiceConversationsThreadContext.setProgressListener(progressListener);
            Serializable serializable = (Serializable)m.invoke(target, this.invocation.getArguments());
            return serializable;
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new RuntimeException(cause);
        }
        catch (Exception e) {
            throw new RuntimeException("Method call failed", e);
        }
        finally {
            ServiceConversationsThreadContext.unsetProgressListener();
            if (progressListener != null) {
                progressListener.close();
            }
        }
    }

    private Method findMethodOn(Object o) throws SecurityException, NoSuchMethodException {
        AccessibleObject methodFound = null;
        Class<?>[] classArray = o.getClass().getInterfaces();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method[] methods;
            Class<?> inter = classArray[n2];
            Method[] methodArray = methods = inter.getMethods();
            int n3 = methods.length;
            int n4 = 0;
            while (n4 < n3) {
                Method method = methodArray[n4];
                if (method.getName().equals(this.invocation.getMethodName()) && Arrays.equals(method.getParameterTypes(), this.invocation.getParameterTypes())) {
                    methodFound = method;
                    break;
                }
                ++n4;
            }
            if (methodFound != null && methodFound.isAnnotationPresent(Conversational.class)) {
                return methodFound;
            }
            ++n2;
        }
        if (methodFound == null) {
            throw new NoSuchMethodException("No method found for the service conversation invocation: " + this.invocation);
        }
        throw new NoSuchMethodException("Method found for the service conversation invocation: " + this.invocation + " is not marked as @Conversational");
    }

    private IServiceConversationProgressListener createProgressListener(ServiceConversationServer server, String conversationId, int progressInterval, Method method) {
        Progress progress = method.getAnnotation(Conversational.class).progress();
        if (Progress.AUTOMATIC.equals((Object)progress)) {
            return new ServiceConversationAutomaticProgressListener(server, conversationId, progressInterval, method);
        }
        if (Progress.MANUAL.equals((Object)progress)) {
            return new ServiceConversationRateLimitedProgressListener(server, conversationId, progressInterval);
        }
        throw new IllegalArgumentException("Unsupported service conversation progress: " + (Object)((Object)progress));
    }

    public String toString() {
        return this.invocation.toString();
    }
}

