/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.string;

import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;

public final class UnicodeUtils {
    public static final String DEFAULT_UNICODE_CHARSET = "UTF-8";

    private UnicodeUtils() {
    }

    public static final Charset getDefaultUnicodeCharset() {
        return Charset.forName(DEFAULT_UNICODE_CHARSET);
    }

    public static final Reader createReader(InputStream inputStream) throws EnvironmentFailureException {
        return UnicodeUtils.createReader(inputStream, DEFAULT_UNICODE_CHARSET);
    }

    public static final Reader createReader(InputStream inputStream, String encoding) throws EnvironmentFailureException {
        try {
            return new InputStreamReader(inputStream, encoding);
        }
        catch (UnsupportedEncodingException ex) {
            throw new EnvironmentFailureException(ex.getMessage());
        }
    }
}

