/*
 * Copyright 2011 ETH Zuerich, CISD
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package ch.systemsx.cisd.openbis.plugin.screening.client.api.v1;

/**
 * Interface for factories of {@link IScreeningOpenbisServiceFacade} instances.
 *
 * @author Franz-Josef Elmer
 */
public interface IScreeningOpenbisServiceFacadeFactory
{
    /**
     * Tries to create a facade object for specified user ID, password and server URL.
     * 
     * @return null if the user could not be authenticated.
     */
    public  IScreeningOpenbisServiceFacade tryToCreate(String userId, String userPassword,
            String serverUrl);
    
    /**
     * Tries to create a facade object for specified session token and server URL.
     * 
     * @return null if the session token is invalid.
     */
    public IScreeningOpenbisServiceFacade tryToCreate(String sessionToken, String serverUrl);

}
