import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.DataType as DataType

tr = service.transaction()

file_type_CSV = tr.getOrCreateNewFileFormatType('CSV')
file_type_CSV.setDescription('files with values separated by comma or semicolon')

file_type_JPG = tr.getOrCreateNewFileFormatType('JPG')
file_type_JPG.setDescription(None)

vocabulary_MICROSCOPE = tr.getOrCreateNewVocabulary('MICROSCOPE')
vocabulary_MICROSCOPE.setDescription('Microscope used in an experiment.')
vocabulary_MICROSCOPE.setUrlTemplate(None)
vocabulary_MICROSCOPE.setManagedInternally(False)
vocabulary_MICROSCOPE.setInternalNamespace(False)
vocabulary_MICROSCOPE.setChosenFromList(True)

vocabulary_term_MICROSCOPE_MD_IMAGEXPRESS_MICRO_2 = tr.createNewVocabularyTerm('MD_IMAGEXPRESS_MICRO_2')
vocabulary_term_MICROSCOPE_MD_IMAGEXPRESS_MICRO_2.setDescription(None)
vocabulary_term_MICROSCOPE_MD_IMAGEXPRESS_MICRO_2.setLabel(None)
vocabulary_term_MICROSCOPE_MD_IMAGEXPRESS_MICRO_2.setOrdinal(3)
vocabulary_MICROSCOPE.addTerm(vocabulary_term_MICROSCOPE_MD_IMAGEXPRESS_MICRO_2)

vocabulary_term_MICROSCOPE_MD_IMAGEXPRESS_MICROLIVE = tr.createNewVocabularyTerm('MD_IMAGEXPRESS_MICROLIVE')
vocabulary_term_MICROSCOPE_MD_IMAGEXPRESS_MICROLIVE.setDescription(None)
vocabulary_term_MICROSCOPE_MD_IMAGEXPRESS_MICROLIVE.setLabel(None)
vocabulary_term_MICROSCOPE_MD_IMAGEXPRESS_MICROLIVE.setOrdinal(2)
vocabulary_MICROSCOPE.addTerm(vocabulary_term_MICROSCOPE_MD_IMAGEXPRESS_MICROLIVE)

vocabulary_term_MICROSCOPE_BD_PATHWAY_855 = tr.createNewVocabularyTerm('BD_PATHWAY_855')
vocabulary_term_MICROSCOPE_BD_PATHWAY_855.setDescription(None)
vocabulary_term_MICROSCOPE_BD_PATHWAY_855.setLabel(None)
vocabulary_term_MICROSCOPE_BD_PATHWAY_855.setOrdinal(1)
vocabulary_MICROSCOPE.addTerm(vocabulary_term_MICROSCOPE_BD_PATHWAY_855)

exp_type_COMPOUND_HCS = tr.getOrCreateNewExperimentType('COMPOUND_HCS')
exp_type_COMPOUND_HCS.setDescription('Compound High Content Screening')

exp_type_SIRNA_HCS = tr.getOrCreateNewExperimentType('SIRNA_HCS')
exp_type_SIRNA_HCS.setDescription('Small Interfering RNA High Content Screening')

data_set_type_HCS_ANALYSIS_CELL_CLASS = tr.getOrCreateNewDataSetType('HCS_ANALYSIS_CELL_CLASS')
data_set_type_HCS_ANALYSIS_CELL_CLASS.setDescription('HCS image analysis cell classification')
data_set_type_HCS_ANALYSIS_CELL_CLASS.setContainerType(False)

data_set_type_HCS_ANALYSIS_CELL_FEATURES = tr.getOrCreateNewDataSetType('HCS_ANALYSIS_CELL_FEATURES')
data_set_type_HCS_ANALYSIS_CELL_FEATURES.setDescription('HCS image analysis cell feature vectors')
data_set_type_HCS_ANALYSIS_CELL_FEATURES.setContainerType(False)

data_set_type_HCS_ANALYSIS_CELL_SEGMENTATION = tr.getOrCreateNewDataSetType('HCS_ANALYSIS_CELL_SEGMENTATION')
data_set_type_HCS_ANALYSIS_CELL_SEGMENTATION.setDescription('HCS image analysis cell segmentation')
data_set_type_HCS_ANALYSIS_CELL_SEGMENTATION.setContainerType(False)

data_set_type_MICROSCOPY_IMG_OVERVIEW = tr.getOrCreateNewDataSetType('MICROSCOPY_IMG_OVERVIEW')
data_set_type_MICROSCOPY_IMG_OVERVIEW.setDescription('Overview Microscopy Images. Generated from raw images.')
data_set_type_MICROSCOPY_IMG_OVERVIEW.setContainerType(False)

data_set_type_HCS_IMAGE_CONTAINER_SEGMENTATION = tr.getOrCreateNewDataSetType('HCS_IMAGE_CONTAINER_SEGMENTATION')
data_set_type_HCS_IMAGE_CONTAINER_SEGMENTATION.setDescription('Container for HCS segmentation (a.k.a. overlays) images of different resolutions (original, overviews, thumbnails).')
data_set_type_HCS_IMAGE_CONTAINER_SEGMENTATION.setContainerType(True)

data_set_type_HCS_ANALYSIS_CONTAINER_CELL_FEATURES = tr.getOrCreateNewDataSetType('HCS_ANALYSIS_CONTAINER_CELL_FEATURES')
data_set_type_HCS_ANALYSIS_CONTAINER_CELL_FEATURES.setDescription('Container for HCS image analysis cell feature vectors.')
data_set_type_HCS_ANALYSIS_CONTAINER_CELL_FEATURES.setContainerType(True)

data_set_type_HCS_ANALYSIS_CONTAINER_WELL_FEATURES = tr.getOrCreateNewDataSetType('HCS_ANALYSIS_CONTAINER_WELL_FEATURES')
data_set_type_HCS_ANALYSIS_CONTAINER_WELL_FEATURES.setDescription('Container for HCS image analysis well feature vectors.')
data_set_type_HCS_ANALYSIS_CONTAINER_WELL_FEATURES.setContainerType(True)

material_type_BACTERIUM = tr.getOrCreateNewMaterialType('BACTERIUM')
material_type_BACTERIUM.setDescription('Bacterium')

material_type_CELL_LINE = tr.getOrCreateNewMaterialType('CELL_LINE')
material_type_CELL_LINE.setDescription('Cell Line or Cell Culture. The growing of cells under controlled conditions.')

material_type_VIRUS = tr.getOrCreateNewMaterialType('VIRUS')
material_type_VIRUS.setDescription('Virus')

# Already exists in the database
prop_type_DESCRIPTION = tr.getPropertyType('DESCRIPTION')
prop_type_ANALYSIS_PROCEDURE = tr.getPropertyType('ANALYSIS_PROCEDURE')
prop_type_RESOLUTION = tr.getPropertyType('RESOLUTION')

prop_type_MICROSCOPE = tr.getOrCreateNewPropertyType('MICROSCOPE', DataType.CONTROLLEDVOCABULARY)
prop_type_MICROSCOPE.setLabel('Microscope')
prop_type_MICROSCOPE.setManagedInternally(False)
prop_type_MICROSCOPE.setInternalNamespace(False)
prop_type_MICROSCOPE.setVocabulary(vocabulary_MICROSCOPE)

prop_type_NUMBER_OF_CHANNEL = tr.getOrCreateNewPropertyType('NUMBER_OF_CHANNEL', DataType.INTEGER)
prop_type_NUMBER_OF_CHANNEL.setLabel('Channels')
prop_type_NUMBER_OF_CHANNEL.setManagedInternally(False)
prop_type_NUMBER_OF_CHANNEL.setInternalNamespace(False)

prop_type_REFSEQ = tr.getOrCreateNewPropertyType('REFSEQ', DataType.VARCHAR)
prop_type_REFSEQ.setLabel('RefSeq')
prop_type_REFSEQ.setManagedInternally(False)
prop_type_REFSEQ.setInternalNamespace(False)

assignment_MATERIAL_BACTERIUM_DESCRIPTION = tr.assignPropertyType(material_type_BACTERIUM, prop_type_DESCRIPTION)
assignment_MATERIAL_BACTERIUM_DESCRIPTION.setMandatory(False)
assignment_MATERIAL_BACTERIUM_DESCRIPTION.setSection(None)
assignment_MATERIAL_BACTERIUM_DESCRIPTION.setPositionInForms(1)

assignment_EXPERIMENT_COMPOUND_HCS_DESCRIPTION = tr.assignPropertyType(exp_type_COMPOUND_HCS, prop_type_DESCRIPTION)
assignment_EXPERIMENT_COMPOUND_HCS_DESCRIPTION.setMandatory(True)
assignment_EXPERIMENT_COMPOUND_HCS_DESCRIPTION.setSection(None)
assignment_EXPERIMENT_COMPOUND_HCS_DESCRIPTION.setPositionInForms(1)

assignment_DATA_SET_HCS_ANALYSIS_WELL_FEATURES_ANALYSIS_PROCEDURE = tr.assignPropertyType(data_set_type_HCS_ANALYSIS_CONTAINER_WELL_FEATURES, prop_type_ANALYSIS_PROCEDURE)
assignment_DATA_SET_HCS_ANALYSIS_WELL_FEATURES_ANALYSIS_PROCEDURE.setMandatory(False)
assignment_DATA_SET_HCS_ANALYSIS_WELL_FEATURES_ANALYSIS_PROCEDURE.setSection(None)
assignment_DATA_SET_HCS_ANALYSIS_WELL_FEATURES_ANALYSIS_PROCEDURE.setPositionInForms(1)

assignment_DATA_SET_HCS_IMAGE_SEGMENTATION_ANALYSIS_PROCEDURE = tr.assignPropertyType(data_set_type_HCS_IMAGE_CONTAINER_SEGMENTATION, prop_type_ANALYSIS_PROCEDURE)
assignment_DATA_SET_HCS_IMAGE_SEGMENTATION_ANALYSIS_PROCEDURE.setMandatory(False)
assignment_DATA_SET_HCS_IMAGE_SEGMENTATION_ANALYSIS_PROCEDURE.setSection(None)
assignment_DATA_SET_HCS_IMAGE_SEGMENTATION_ANALYSIS_PROCEDURE.setPositionInForms(1)

assignment_DATA_SET_MICROSCOPY_IMG_OVERVIEW_RESOLUTION = tr.assignPropertyType(data_set_type_MICROSCOPY_IMG_OVERVIEW, prop_type_RESOLUTION)
assignment_DATA_SET_MICROSCOPY_IMG_OVERVIEW_RESOLUTION.setMandatory(False)
assignment_DATA_SET_MICROSCOPY_IMG_OVERVIEW_RESOLUTION.setSection(None)
assignment_DATA_SET_MICROSCOPY_IMG_OVERVIEW_RESOLUTION.setPositionInForms(1)

assignment_EXPERIMENT_SIRNA_HCS_DESCRIPTION = tr.assignPropertyType(exp_type_SIRNA_HCS, prop_type_DESCRIPTION)
assignment_EXPERIMENT_SIRNA_HCS_DESCRIPTION.setMandatory(True)
assignment_EXPERIMENT_SIRNA_HCS_DESCRIPTION.setSection(None)
assignment_EXPERIMENT_SIRNA_HCS_DESCRIPTION.setPositionInForms(1)

assignment_EXPERIMENT_SIRNA_HCS_MICROSCOPE = tr.assignPropertyType(exp_type_SIRNA_HCS, prop_type_MICROSCOPE)
assignment_EXPERIMENT_SIRNA_HCS_MICROSCOPE.setMandatory(False)
assignment_EXPERIMENT_SIRNA_HCS_MICROSCOPE.setSection(None)
assignment_EXPERIMENT_SIRNA_HCS_MICROSCOPE.setPositionInForms(2)

assignment_MATERIAL_VIRUS_DESCRIPTION = tr.assignPropertyType(material_type_VIRUS, prop_type_DESCRIPTION)
assignment_MATERIAL_VIRUS_DESCRIPTION.setMandatory(False)
assignment_MATERIAL_VIRUS_DESCRIPTION.setSection(None)
assignment_MATERIAL_VIRUS_DESCRIPTION.setPositionInForms(1)
