/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.basic;

import ch.systemsx.cisd.common.shared.basic.string.StringUtils;
import ch.systemsx.cisd.openbis.generic.shared.basic.BasicURLEncoder;
import com.google.gwt.user.client.rpc.IsSerializable;

public class URLMethodWithParameters
implements IsSerializable {
    private static final char STARTING_DELIMITER = '?';
    private final StringBuilder builder;
    private char delim = (char)63;

    public URLMethodWithParameters(String methodName) {
        this.builder = new StringBuilder();
        this.builder.append(BasicURLEncoder.encode(methodName, ":/"));
    }

    public void addParameterWithoutEncoding(String parameterName, Object value) {
        this.addParameter(parameterName, value, false);
    }

    public void addParameter(String parameterName, Object value) {
        this.addParameter(parameterName, value, true);
    }

    public void startHistoryToken() {
        this.delim = (char)35;
    }

    private void addParameter(String parameterName, Object value, boolean withEncoding) {
        String maybeEncodedName = withEncoding ? BasicURLEncoder.encode(parameterName) : parameterName;
        this.builder.append(this.delim).append(maybeEncodedName).append('=');
        if (value != null) {
            String maybeEncodedValue = withEncoding ? BasicURLEncoder.encode(value.toString()) : value.toString();
            this.builder.append(maybeEncodedValue);
        }
        this.delim = (char)38;
    }

    public String toString() {
        return this.builder.toString();
    }

    public String toStringWithoutDelimiterPrefix() {
        String string = this.toString();
        if (!StringUtils.isBlank((String)string) && string.charAt(0) == '?') {
            return string.substring(1);
        }
        return string;
    }

    public static String createEmbededImageHtml(String imageURL, String linkURLOrNull, int width, int height) {
        String linkStart = "";
        String linkEnd = "";
        if (linkURLOrNull != null) {
            linkStart = "<a class='link-style' href='" + linkURLOrNull + "' target='_blank'>";
            linkEnd = "</a>";
        }
        StringBuilder builder = new StringBuilder();
        if (width > 0) {
            builder.append(" width='").append(width).append("'");
        }
        if (height > 0) {
            builder.append(" height='").append(height).append("'");
        }
        return "<div align='center'>" + linkStart + "<img src='" + imageURL + "' alt='" + " image " + "'" + builder + "/>" + linkEnd + "</div>";
    }

    public static String createEmbededLinkHtml(String linkText, String linkUrl, String linkAlign) {
        String linkStart = "";
        String linkEnd = "";
        if (linkUrl != null) {
            linkStart = "<a class='link-style' href='" + linkUrl + "' target='_blank'>";
            linkEnd = "</a>";
        }
        String align = linkAlign != null ? "align='" + linkAlign + "'" : "";
        return "<div " + align + ">" + linkStart + linkText + linkEnd + "</div>";
    }
}

