/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.common.conversation.manager;

import ch.systemsx.cisd.common.serviceconversation.ServiceMessage;
import ch.systemsx.cisd.common.serviceconversation.client.IServiceConversation;
import ch.systemsx.cisd.openbis.common.conversation.client.ServiceConversationClientWithConversationTracking;
import ch.systemsx.cisd.openbis.common.conversation.manager.IServiceConversationClientManagerRemote;
import ch.systemsx.cisd.openbis.common.conversation.manager.ServiceConversationServiceProxy;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class BaseServiceConversationClientManager
implements IServiceConversationClientManagerRemote {
    private Map<ClientConfig, ServiceConversationClientWithConversationTracking> clientConfigToClientMap = Collections.synchronizedMap(new HashMap());
    private Map<String, ServiceConversationClientWithConversationTracking> conversationIdToClientMap = Collections.synchronizedMap(new HashMap());

    @Override
    public void send(ServiceMessage message) {
        ServiceConversationClientWithConversationTracking client = this.getClientForConversationId(message.getConversationId());
        if (client != null) {
            client.receiveMessage(message);
        }
    }

    @Override
    public void ping() {
    }

    public <T> T getService(String serverUrl, Class<T> serviceInterface, String sessionToken, Object clientId, int clientTimeout) {
        return ServiceConversationServiceProxy.newInstance(this.getClientForServerUrl(serverUrl, clientId, clientTimeout), serviceInterface, sessionToken);
    }

    public int getConversationCount() {
        return this.conversationIdToClientMap.size();
    }

    public int getClientCount() {
        return this.clientConfigToClientMap.size();
    }

    private synchronized ServiceConversationClientWithConversationTracking getClientForServerUrl(String serverUrl, Object clientId, int clientTimeout) {
        ClientConfig clientConfig = new ClientConfig(serverUrl, clientId, clientTimeout);
        ServiceConversationClientWithConversationTracking client = this.clientConfigToClientMap.get(clientConfig);
        if (client == null) {
            client = new ServiceConversationClientWithConversationTracking(serverUrl, clientId, clientTimeout){

                @Override
                public void onConversationStart(IServiceConversation conversation) {
                    BaseServiceConversationClientManager.this.conversationIdToClientMap.put(conversation.getId(), this);
                }

                @Override
                public void onConversationClose(IServiceConversation conversation) {
                    BaseServiceConversationClientManager.this.conversationIdToClientMap.remove(conversation.getId());
                }
            };
            this.clientConfigToClientMap.put(clientConfig, client);
        }
        return client;
    }

    private ServiceConversationClientWithConversationTracking getClientForConversationId(String conversationId) {
        return this.conversationIdToClientMap.get(conversationId);
    }

    private static class ClientConfig {
        private String serverUrl;
        private Object clientId;
        private int clientTimeout;

        public ClientConfig(String serverUrl, Object clientId, int clientTimeout) {
            this.serverUrl = serverUrl;
            this.clientId = clientId;
            this.clientTimeout = clientTimeout;
        }

        public int hashCode() {
            HashCodeBuilder builder = new HashCodeBuilder();
            builder.append((Object)this.serverUrl);
            builder.append(this.clientId);
            builder.append(this.clientTimeout);
            return builder.toHashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            ClientConfig that = (ClientConfig)obj;
            EqualsBuilder builder = new EqualsBuilder();
            builder.append((Object)this.serverUrl, (Object)that.serverUrl);
            builder.append(this.clientId, that.clientId);
            builder.append(this.clientTimeout, that.clientTimeout);
            return builder.isEquals();
        }
    }
}

