/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.basic;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import java.util.regex.Pattern;

public class MetaprojectName {
    private static final Pattern PATTERN = Pattern.compile("^[^\\s,/\\\\]+$", 2);

    public static void validate(String name) {
        if (name == null) {
            throw new UserFailureException("Metaproject name cannot be null");
        }
        if (name.isEmpty()) {
            throw new UserFailureException("Metaproject name cannot be empty");
        }
        if (name.length() > 60) {
            throw new UserFailureException("Metaproject name cannot be longer than 60 characters.");
        }
        if (!PATTERN.matcher(name).matches()) {
            throw new UserFailureException("Metaproject name cannot contain white spaces, commas, slashes or backslashes.");
        }
    }
}

