/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.authentication;

import ch.systemsx.cisd.common.reflection.AbstractHashable;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.builder.ToStringBuilder;

public final class Principal
extends AbstractHashable
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String userId;
    private String firstName;
    private String lastName;
    private String email;
    private boolean authenticated;
    private boolean anonymous;
    private Map<String, String> properties;

    public static boolean isAuthenticated(Principal principalOrNull) {
        return principalOrNull == null ? false : principalOrNull.isAuthenticated();
    }

    public Principal() {
    }

    public Principal(String userId, String firstName, String lastName, String email) {
        this(userId, firstName, lastName, email, false, new HashMap<String, String>());
    }

    public Principal(String userId, String firstName, String lastName, String email, boolean authenticated) {
        this(userId, firstName, lastName, email, authenticated, new HashMap<String, String>());
    }

    public Principal(String userId, String firstName, String lastName, String email, boolean authenticated, Map<String, String> properties) {
        assert (userId != null);
        assert (firstName != null);
        assert (lastName != null);
        assert (email != null);
        assert (properties != null);
        this.userId = userId;
        this.firstName = firstName;
        this.lastName = lastName;
        this.email = email;
        this.authenticated = authenticated;
        this.properties = properties;
    }

    public String getUserId() {
        return this.userId;
    }

    public final String getEmail() {
        return this.email;
    }

    public final String getFirstName() {
        return this.firstName;
    }

    public final String getLastName() {
        return this.lastName;
    }

    public final String getProperty(String key) {
        return this.properties != null ? this.properties.get(key) : null;
    }

    public final Set<String> getPropertyNames() {
        return Collections.unmodifiableSet(this.properties.keySet());
    }

    public boolean isAuthenticated() {
        return this.authenticated;
    }

    public boolean isAnonymous() {
        return this.anonymous;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setAuthenticated(boolean authenticated) {
        this.authenticated = authenticated;
    }

    public void setAnonymous(boolean anonymous) {
        this.anonymous = anonymous;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

