/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.resource;

import ch.systemsx.cisd.common.resource.IReleasable;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class Resources {
    private Logger logger;
    public Set<IReleasable> resources = new LinkedHashSet<IReleasable>();

    public Resources(Logger logger) {
        this.logger = logger;
    }

    public void add(IReleasable resource) {
        this.resources.add(resource);
    }

    public void release() {
        if (this.resources.size() > 0) {
            for (IReleasable resource : this.resources) {
                try {
                    resource.release();
                    if (this.logger == null) continue;
                    this.logger.debug("Successfully released a resource: " + resource);
                }
                catch (Exception e) {
                    if (this.logger == null) continue;
                    this.logger.debug("Couldn't release a resource: " + resource, e);
                }
            }
        } else if (this.logger != null) {
            this.logger.debug("Didn't have to release any resources");
        }
    }

    public void clear() {
        this.resources.clear();
    }
}

