/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver;

import ch.systemsx.cisd.common.reflection.AbstractHashable;
import ch.systemsx.cisd.hcs.Geometry;
import ch.systemsx.cisd.hcs.Location;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class HCSImageCheckList {
    private final List<Map<FullLocation, Check>> list;

    public HCSImageCheckList(int numberOfChannels, Geometry plateGeometry, Geometry wellGeometry) {
        if (numberOfChannels < 1) {
            throw new IllegalArgumentException("Number of channels smaller than one.");
        }
        if (plateGeometry == null) {
            throw new IllegalArgumentException("Unspecified plate geometry.");
        }
        if (wellGeometry == null) {
            throw new IllegalArgumentException("Unspecified well geometry.");
        }
        this.list = new ArrayList<Map<FullLocation, Check>>();
        int i = 0;
        while (i < numberOfChannels) {
            HashMap<FullLocation, Check> map = new HashMap<FullLocation, Check>();
            int plateX = 1;
            while (plateX <= plateGeometry.getColumns()) {
                int plateY = 1;
                while (plateY <= plateGeometry.getRows()) {
                    Location wellLocation = new Location(plateX, plateY);
                    int wellX = 1;
                    while (wellX <= wellGeometry.getColumns()) {
                        int wellY = 1;
                        while (wellY <= wellGeometry.getRows()) {
                            Location tileLocation = new Location(wellX, wellY);
                            map.put(new FullLocation(wellLocation, tileLocation), new Check());
                            ++wellY;
                        }
                        ++wellX;
                    }
                    ++plateY;
                }
                ++plateX;
            }
            assert (map.size() == plateGeometry.getColumns() * plateGeometry.getRows() * wellGeometry.getColumns() * wellGeometry.getRows()) : "Wrong map size";
            this.list.add(map);
            ++i;
        }
    }

    public final void checkOff(int channel, Location wellLocation, Location tileLocation) {
        assert (wellLocation != null) : "Unspecified well location.";
        assert (tileLocation != null) : "Unspecified tile location.";
        if (channel < 1) {
            throw new IllegalArgumentException("Not a positive channel number: " + channel);
        }
        if (channel > this.list.size()) {
            throw new IllegalArgumentException("Channel number to large: " + channel + " > " + this.list.size());
        }
        Map<FullLocation, Check> map = this.list.get(channel - 1);
        Check check = map.get(new FullLocation(wellLocation, tileLocation));
        if (check == null) {
            throw new IllegalArgumentException("Invalid well/tile location: " + wellLocation);
        }
        if (check.isCheckedOff()) {
            throw new IllegalArgumentException("Image already handle for channel" + channel + ", well:" + wellLocation + " tile:" + tileLocation);
        }
        check.checkOff();
    }

    public final List<FullLocation> getCheckedOnFullLocations() {
        ArrayList<FullLocation> fullLocations = new ArrayList<FullLocation>();
        for (Map<FullLocation, Check> map : this.list) {
            for (Map.Entry<FullLocation, Check> entry : map.entrySet()) {
                if (entry.getValue().isCheckedOff()) continue;
                fullLocations.add(entry.getKey());
            }
        }
        return fullLocations;
    }

    private static final class Check {
        private boolean checkedOff;

        private Check() {
        }

        final void checkOff() {
            this.checkedOff = true;
        }

        final boolean isCheckedOff() {
            return this.checkedOff;
        }
    }

    public static final class FullLocation
    extends AbstractHashable {
        final Location wellLocation;
        final Location tileLocation;

        FullLocation(Location wellLocation, Location tileLocation) {
            this.wellLocation = wellLocation;
            this.tileLocation = tileLocation;
        }

        private static final String toString(Location location, String type) {
            return String.valueOf(type) + "=" + location;
        }

        @Override
        public final String toString() {
            return "[" + FullLocation.toString(this.wellLocation, "well") + "," + FullLocation.toString(this.tileLocation, "tile") + "]";
        }
    }
}

