/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.registrator.v2;

import ch.systemsx.cisd.base.exceptions.InterruptedExceptionUnchecked;
import ch.systemsx.cisd.common.action.AbstractDelegatedActionWithResult;
import ch.systemsx.cisd.common.action.IDelegatedActionWithResult;
import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.HighLevelException;
import ch.systemsx.cisd.common.exceptions.NotImplementedException;
import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.common.filesystem.AssertionCatchingImmutableCopierWrapper;
import ch.systemsx.cisd.common.filesystem.FastRecursiveHardLinkMaker;
import ch.systemsx.cisd.common.filesystem.FileOperations;
import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.common.filesystem.IFileOperations;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.properties.ExtendedProperties;
import ch.systemsx.cisd.common.reflection.ClassUtils;
import ch.systemsx.cisd.etlserver.AbstractTopLevelDataSetRegistrator;
import ch.systemsx.cisd.etlserver.DataStrategyStore;
import ch.systemsx.cisd.etlserver.DssUniqueFilenameGenerator;
import ch.systemsx.cisd.etlserver.IDataStrategyStore;
import ch.systemsx.cisd.etlserver.IStorageProcessorTransactional;
import ch.systemsx.cisd.etlserver.ITopLevelDataSetRegistratorDelegate;
import ch.systemsx.cisd.etlserver.PropertiesBasedETLServerPlugin;
import ch.systemsx.cisd.etlserver.TopLevelDataSetRegistratorGlobalState;
import ch.systemsx.cisd.etlserver.registrator.DataSetFile;
import ch.systemsx.cisd.etlserver.registrator.DataSetRegistrationContext;
import ch.systemsx.cisd.etlserver.registrator.DataSetRegistrationPreStagingBehavior;
import ch.systemsx.cisd.etlserver.registrator.MarkerFileUtility;
import ch.systemsx.cisd.etlserver.registrator.TopLevelDataSetChecker;
import ch.systemsx.cisd.etlserver.registrator.api.impl.SecondaryTransactionFailure;
import ch.systemsx.cisd.etlserver.registrator.api.v2.impl.DataSetRegistrationTransaction;
import ch.systemsx.cisd.etlserver.registrator.v2.ConfiguredOnErrorActionDecision;
import ch.systemsx.cisd.etlserver.registrator.v2.DataSetRegistrationService;
import ch.systemsx.cisd.etlserver.registrator.v2.DataSetStorageAlgorithmRunner;
import ch.systemsx.cisd.etlserver.registrator.v2.DataSetStorageRollbacker;
import ch.systemsx.cisd.etlserver.registrator.v2.DefaultDataSetRegistrationDetailsFactory;
import ch.systemsx.cisd.etlserver.registrator.v2.IDataSetOnErrorActionDecision;
import ch.systemsx.cisd.etlserver.registrator.v2.IOmniscientEntityRegistrator;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.v1.validation.ValidationError;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.v1.validation.ValidationScriptRunner;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.DataSetInformation;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseInstance;
import ch.systemsx.cisd.openbis.generic.shared.dto.NewExternalData;
import java.io.File;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;

public abstract class AbstractOmniscientTopLevelDataSetRegistrator<T extends DataSetInformation>
extends AbstractTopLevelDataSetRegistrator
implements IOmniscientEntityRegistrator<T> {
    protected static final Logger notificationLog = LogFactory.getLogger(LogCategory.NOTIFY, AbstractOmniscientTopLevelDataSetRegistrator.class);
    protected static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, AbstractOmniscientTopLevelDataSetRegistrator.class);
    protected final OmniscientTopLevelDataSetRegistratorState state;
    private boolean stopped;

    protected AbstractOmniscientTopLevelDataSetRegistrator(TopLevelDataSetRegistratorGlobalState globalState) {
        super(globalState);
        IStorageProcessorTransactional storageProcessor = PropertiesBasedETLServerPlugin.create(IStorageProcessorTransactional.class, globalState.getThreadParameters().getThreadProperties(), "storage-processor", true, new Object[0]);
        storageProcessor.setStoreRootDirectory(globalState.getStoreRootDir());
        ExtendedProperties onErrorDecisionProperties = ExtendedProperties.getSubset(globalState.getThreadParameters().getThreadProperties(), "on-error-decision.", true);
        IDataSetOnErrorActionDecision onErrorDecision = ClassUtils.create(IDataSetOnErrorActionDecision.class, globalState.getThreadParameters().getOnErrorActionDecisionClass(ConfiguredOnErrorActionDecision.class), onErrorDecisionProperties);
        this.state = new OmniscientTopLevelDataSetRegistratorState(globalState, storageProcessor, new ReentrantLock(), FileOperations.getMonitoredInstanceForCurrentThread(), onErrorDecision);
        this.state.fileOperations.mkdirs(this.getRollBackStackParentFolder());
        DataSetRegistrationTransaction.rollbackDeadTransactions(this.getRollBackStackParentFolder());
    }

    @Override
    public OmniscientTopLevelDataSetRegistratorState getRegistratorState() {
        return this.state;
    }

    @Override
    public Lock getRegistrationLock() {
        return this.state.registrationLock;
    }

    @Override
    public File getRollBackStackParentFolder() {
        return this.getGlobalState().getDssInternalTempDir();
    }

    protected boolean hasRecoveryMarkerFile(File incoming) {
        return false;
    }

    protected void handleRecovery(File incomingFileOriginal) {
        throw new NotImplementedException("Recovery feature is not implemented for this kind of registrator");
    }

    @Override
    public final void handle(final File incomingDataSetFileOrIsFinishedFile) {
        File incomingDataSetFile;
        if (this.stopped) {
            return;
        }
        File file = incomingDataSetFile = this.getGlobalState().isUseIsFinishedMarkerFile() ? this.state.getMarkerFileUtility().getIncomingDataSetPathFromMarker(incomingDataSetFileOrIsFinishedFile) : incomingDataSetFileOrIsFinishedFile;
        if (this.hasRecoveryMarkerFile(incomingDataSetFile)) {
            this.handleRecovery(incomingDataSetFile);
            return;
        }
        IDelegatedActionWithResult<Boolean> markerFileCleanupAction = this.getGlobalState().isUseIsFinishedMarkerFile() ? new IDelegatedActionWithResult<Boolean>(){

            @Override
            public Boolean execute(boolean didOperationSucceed) {
                if (AbstractOmniscientTopLevelDataSetRegistrator.this.hasRecoveryMarkerFile(incomingDataSetFile)) {
                    return true;
                }
                return AbstractOmniscientTopLevelDataSetRegistrator.this.state.getMarkerFileUtility().deleteAndLogIsFinishedMarkerFile(incomingDataSetFileOrIsFinishedFile);
            }
        } : new DoNothingDelegatedAction();
        DataSetRegistrationPreStagingBehavior preStagingUsage = this.state.getGlobalState().getThreadParameters().getDataSetRegistrationPreStagingBehavior();
        if (preStagingUsage == DataSetRegistrationPreStagingBehavior.USE_ORIGINAL) {
            DataSetFile incoming = new DataSetFile(incomingDataSetFile);
            this.handle(incoming, null, new NoOpDelegate(DataSetRegistrationPreStagingBehavior.USE_ORIGINAL), markerFileCleanupAction);
        } else {
            File copyOfIncoming = this.tryCopyIncomingFileToPreStaging(incomingDataSetFile);
            if (copyOfIncoming == null) {
                return;
            }
            DataSetFile dsf = new DataSetFile(incomingDataSetFile, copyOfIncoming);
            PostRegistrationCleanUpAction cleanupAction = new PostRegistrationCleanUpAction(dsf, markerFileCleanupAction);
            this.handle(dsf, null, new NoOpDelegate(DataSetRegistrationPreStagingBehavior.USE_PRESTAGING), cleanupAction);
        }
    }

    private File tryCopyIncomingFileToPreStaging(File incomingDataSetFile) {
        TopLevelDataSetRegistratorGlobalState globalState = this.state.getGlobalState();
        File preStagingRootDir = globalState.getPreStagingDir();
        String incomingDirName = new DssUniqueFilenameGenerator(globalState.getThreadParameters().getThreadName(), incomingDataSetFile.getName(), null).generateFilename();
        File preStagingDir = new File(preStagingRootDir, incomingDirName);
        preStagingDir.mkdir();
        AssertionCatchingImmutableCopierWrapper hardlinkMaker = new AssertionCatchingImmutableCopierWrapper(FastRecursiveHardLinkMaker.tryCreate());
        boolean linkWasMade = false;
        Status status = hardlinkMaker.copyImmutably(incomingDataSetFile, preStagingDir, null);
        linkWasMade = status.isOK();
        if (status.isError()) {
            String msg = status.tryGetErrorMessage() == null ? "Unknown error" : status.tryGetErrorMessage();
            operationLog.warn("Failed to make a hard link copy of " + incomingDataSetFile + " to " + preStagingDir + ": " + msg);
        }
        if (!linkWasMade) {
            if (!incomingDataSetFile.exists()) {
                operationLog.warn(String.valueOf(incomingDataSetFile.getAbsolutePath()) + " has been deleted. Nothing to process.");
                return null;
            }
            FileOperations.getMonitoredInstanceForCurrentThread().copyToDirectory(incomingDataSetFile, preStagingDir);
        }
        return new File(preStagingDir, incomingDataSetFile.getName());
    }

    @Override
    public final void handle(File incomingDataSetFile, DataSetInformation callerDataSetInformation, ITopLevelDataSetRegistratorDelegate delegate) {
        this.handle(new DataSetFile(incomingDataSetFile), callerDataSetInformation, delegate);
    }

    public final void handle(DataSetFile incomingDataSetFile, DataSetInformation callerDataSetInformation, ITopLevelDataSetRegistratorDelegate delegate) {
        if (this.stopped) {
            return;
        }
        DataSetRegistrationService<T> service = this.handle(incomingDataSetFile, callerDataSetInformation, delegate, new DoNothingDelegatedAction());
        if (service.didErrorsArise()) {
            Throwable firstError = service.getEncounteredErrors().get(0);
            throw new EnvironmentFailureException("Could not process file " + incomingDataSetFile.getLogicalIncomingFile().getName(), this.asSerializableException(firstError));
        }
    }

    protected Throwable asSerializableException(Throwable throwable) {
        if (throwable instanceof HighLevelException) {
            return new RuntimeException(throwable.getMessage());
        }
        Throwable cause = throwable;
        while (cause.getCause() != null) {
            cause = cause.getCause();
        }
        return new RuntimeException(cause.toString());
    }

    private DataSetRegistrationService<T> handle(DataSetFile incomingDataSetFile, DataSetInformation callerDataSetInformationOrNull, ITopLevelDataSetRegistratorDelegate delegate, IDelegatedActionWithResult<Boolean> cleanAfterwardsAction) {
        DataSetRegistrationService<T> service;
        block6: {
            service = this.createDataSetRegistrationService(incomingDataSetFile, callerDataSetInformationOrNull, cleanAfterwardsAction, delegate);
            try {
                try {
                    ValidationScriptRunner validationScriptRunner = ValidationScriptRunner.createValidatorFromScriptPaths(this.getGlobalState().getValidationScriptsOrNull());
                    List<ValidationError> validationErrors = validationScriptRunner.validate(incomingDataSetFile.getLogicalIncomingFile());
                    if (validationErrors.size() > 0) {
                        this.handleValidationErrors(validationErrors, incomingDataSetFile, service);
                        break block6;
                    }
                    this.handleDataSet(incomingDataSetFile, service);
                    service.commit();
                }
                catch (Throwable ex) {
                    operationLog.error("Could not process file " + incomingDataSetFile, ex);
                    this.rollback(service, ex);
                    IStorageProcessorTransactional.UnstoreDataAction action = this.getRegistratorState().getOnErrorActionDecision().computeUndoAction(IDataSetOnErrorActionDecision.ErrorType.REGISTRATION_SCRIPT_ERROR, ex);
                    DataSetStorageRollbacker rollbacker = new DataSetStorageRollbacker(this.getRegistratorState(), operationLog, action, incomingDataSetFile, null, ex, IDataSetOnErrorActionDecision.ErrorType.REGISTRATION_SCRIPT_ERROR);
                    operationLog.info(rollbacker.getErrorMessageForLog());
                    service.getDssRegistrationLog().log("Processing failed : " + ex.toString());
                    rollbacker.doRollback(service.getDssRegistrationLog());
                    service.getDssRegistrationLog().registerFailure();
                    service.cleanAfterRegistrationIfNecessary();
                }
            }
            finally {
                service.cleanAfterRegistrationIfNecessary();
            }
        }
        return service;
    }

    protected void handleValidationErrors(List<ValidationError> validationErrors, DataSetFile incomingDataSetFile, DataSetRegistrationService<T> service) {
        StringBuilder sb = new StringBuilder();
        sb.append("Validation script [");
        sb.append(this.getGlobalState().getValidationScriptsOrNull());
        sb.append("] found errors in incoming data set [");
        sb.append(incomingDataSetFile.getLogicalIncomingFile());
        sb.append("]:\n");
        for (ValidationError error : validationErrors) {
            sb.append("\t");
            sb.append(error.getErrorMessage());
            sb.append("\n");
        }
        IStorageProcessorTransactional.UnstoreDataAction action = this.getRegistratorState().getOnErrorActionDecision().computeUndoAction(IDataSetOnErrorActionDecision.ErrorType.INVALID_DATA_SET, null);
        DataSetStorageRollbacker rollbacker = new DataSetStorageRollbacker(this.getRegistratorState(), operationLog, action, incomingDataSetFile, null, null, IDataSetOnErrorActionDecision.ErrorType.INVALID_DATA_SET);
        sb.append(rollbacker.getErrorMessageForLog());
        String logMessage = sb.toString();
        service.getDssRegistrationLog().info(operationLog, logMessage);
        rollbacker.doRollback(service.getDssRegistrationLog());
        service.getDssRegistrationLog().registerFailure();
    }

    @Override
    public boolean isStopped() {
        return this.stopped;
    }

    @Override
    public boolean isRemote() {
        return true;
    }

    @Override
    public final void check() throws ConfigurationFailureException, EnvironmentFailureException {
        new TopLevelDataSetChecker(operationLog, this.state.storageProcessor, this.state.fileOperations).runCheck();
    }

    @Override
    public void didRollbackTransaction(DataSetRegistrationService<T> dataSetRegistrationService, DataSetRegistrationTransaction<T> transaction, DataSetStorageAlgorithmRunner<T> algorithm, Throwable ex) {
        this.updateStopped(ex instanceof InterruptedExceptionUnchecked);
    }

    @Override
    public void didCommitTransaction(DataSetRegistrationService<T> dataSetRegistrationService, DataSetRegistrationTransaction<T> transaction) {
    }

    @Override
    public void didPreRegistration(DataSetRegistrationService<T> service, DataSetRegistrationContext.IHolder registrationContextHolder) {
    }

    @Override
    public void didPostRegistration(DataSetRegistrationService<T> service, DataSetRegistrationContext.IHolder registrationContextHolder) {
    }

    @Override
    public void didEncounterSecondaryTransactionErrors(DataSetRegistrationService<T> dataSetRegistrationService, DataSetRegistrationTransaction<T> transaction, List<SecondaryTransactionFailure> secondaryErrors) {
    }

    protected void rollback(DataSetRegistrationService<T> service, Throwable throwable) {
        this.updateStopped(throwable instanceof InterruptedExceptionUnchecked);
        service.abort(throwable);
    }

    protected DataSetRegistrationService<T> createDataSetRegistrationService(DataSetFile incomingDataSetFile, DataSetInformation callerDataSetInformationOrNull, IDelegatedActionWithResult<Boolean> cleanAfterwardsAction, ITopLevelDataSetRegistratorDelegate delegate) {
        DataSetRegistrationService<DataSetInformation> service = new DataSetRegistrationService<DataSetInformation>(this, incomingDataSetFile, new DefaultDataSetRegistrationDetailsFactory(this.getRegistratorState(), callerDataSetInformationOrNull), cleanAfterwardsAction, delegate);
        return service;
    }

    public void registerDataSetInApplicationServer(DataSetInformation dataSetInformation, NewExternalData data) throws Throwable {
        this.getGlobalState().getOpenBisService().registerDataSet(dataSetInformation, data);
    }

    protected void updateStopped(boolean update) {
        this.stopped |= update;
    }

    protected abstract void handleDataSet(DataSetFile var1, DataSetRegistrationService<T> var2) throws Throwable;

    public static class DoNothingDelegatedAction
    extends AbstractDelegatedActionWithResult<Boolean> {
        public DoNothingDelegatedAction() {
            super(true);
        }
    }

    public static class NoOpDelegate
    implements ITopLevelDataSetRegistratorDelegate {
        private final DataSetRegistrationPreStagingBehavior preStagingBehavior;

        public NoOpDelegate(DataSetRegistrationPreStagingBehavior preStagingBehavior) {
            this.preStagingBehavior = preStagingBehavior;
        }

        @Override
        public void didRegisterDataSets(List<DataSetInformation> dataSetInformations) {
        }

        @Override
        public DataSetRegistrationPreStagingBehavior getPrestagingBehavior() {
            return this.preStagingBehavior;
        }
    }

    public static class OmniscientTopLevelDataSetRegistratorState {
        private final TopLevelDataSetRegistratorGlobalState globalState;
        private final IStorageProcessorTransactional storageProcessor;
        private final ReentrantLock registrationLock;
        private final IFileOperations fileOperations;
        private final IDataStrategyStore dataStrategyStore;
        private final MarkerFileUtility markerFileUtility;
        private final DatabaseInstance homeDatabaseInstance;
        private final ValidationScriptRunner validationScriptRunner;
        private final IDataSetOnErrorActionDecision onErrorActionDecision;

        public OmniscientTopLevelDataSetRegistratorState(TopLevelDataSetRegistratorGlobalState globalState, IStorageProcessorTransactional storageProcessor, ReentrantLock registrationLock, IFileOperations fileOperations, IDataSetOnErrorActionDecision onErrorActionDecision) {
            this.globalState = globalState;
            this.storageProcessor = storageProcessor;
            this.registrationLock = registrationLock;
            this.fileOperations = fileOperations;
            this.dataStrategyStore = new DataStrategyStore(globalState.getOpenBisService(), globalState.getMailClient());
            this.markerFileUtility = new MarkerFileUtility(operationLog, notificationLog, fileOperations, storageProcessor);
            this.homeDatabaseInstance = globalState.getOpenBisService().getHomeDatabaseInstance();
            this.validationScriptRunner = ValidationScriptRunner.createValidatorFromScriptPaths(globalState.getValidationScriptsOrNull());
            this.onErrorActionDecision = onErrorActionDecision;
        }

        public TopLevelDataSetRegistratorGlobalState getGlobalState() {
            return this.globalState;
        }

        public IStorageProcessorTransactional getStorageProcessor() {
            return this.storageProcessor;
        }

        public ReentrantLock getRegistrationLock() {
            return this.registrationLock;
        }

        public IFileOperations getFileOperations() {
            return this.fileOperations;
        }

        public IDataStrategyStore getDataStrategyStore() {
            return this.dataStrategyStore;
        }

        public MarkerFileUtility getMarkerFileUtility() {
            return this.markerFileUtility;
        }

        public DatabaseInstance getHomeDatabaseInstance() {
            return this.homeDatabaseInstance;
        }

        public ValidationScriptRunner getValidationScriptRunner() {
            return this.validationScriptRunner;
        }

        public IDataSetOnErrorActionDecision getOnErrorActionDecision() {
            return this.onErrorActionDecision;
        }
    }

    public static class PostRegistrationCleanUpAction
    extends AbstractDelegatedActionWithResult<Boolean> {
        private final DataSetFile incoming;
        private final IDelegatedActionWithResult<Boolean> wrappedAction;

        public PostRegistrationCleanUpAction(DataSetFile incoming, IDelegatedActionWithResult<Boolean> wrappedAction) {
            super(true);
            this.incoming = incoming;
            this.wrappedAction = wrappedAction;
        }

        @Override
        public Boolean execute(boolean didOperationSucceed) {
            boolean operationSuccessful = true;
            if (didOperationSucceed) {
                boolean stillExists = this.incoming.getRealIncomingFile().exists();
                if (!stillExists) {
                    operationLog.warn("Incoming file [" + this.incoming.getRealIncomingFile() + "] was deleted outside of openBIS after processing started. The data had already been registered in the database.");
                } else {
                    operationSuccessful = FileUtilities.deleteRecursively(this.incoming.getRealIncomingFile());
                }
                File hardlinkCopyParent = this.incoming.getLogicalIncomingFile().getParentFile();
                if (hardlinkCopyParent.list().length < 1) {
                    hardlinkCopyParent.delete();
                }
            } else {
                operationSuccessful = FileUtilities.deleteRecursively(this.incoming.getLogicalIncomingFile());
            }
            boolean wrappedActionResult = this.wrappedAction.execute(didOperationSucceed);
            if (operationSuccessful && wrappedActionResult) {
                return true;
            }
            return false;
        }
    }
}

