/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server;

import ch.systemsx.cisd.base.exceptions.InterruptedExceptionUnchecked;
import ch.systemsx.cisd.common.collection.IExtendedBlockingQueue;
import ch.systemsx.cisd.common.io.PersistentExtendedBlockingQueueDecorator;
import ch.systemsx.cisd.common.io.PersistentExtendedBlockingQueueFactory;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.mail.MailClientParameters;
import ch.systemsx.cisd.openbis.dss.generic.server.DeletionCommand;
import ch.systemsx.cisd.openbis.dss.generic.server.ICIFEXRPCServiceFactory;
import ch.systemsx.cisd.openbis.dss.generic.server.IDataSetCommand;
import ch.systemsx.cisd.openbis.dss.generic.server.IDataSetCommandExecutor;
import ch.systemsx.cisd.openbis.dss.generic.server.ProcessDatasetsCommand;
import ch.systemsx.cisd.openbis.dss.generic.server.UploadingCommand;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.tasks.IProcessingPluginTask;
import ch.systemsx.cisd.openbis.dss.generic.shared.DataSetDirectoryProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.IHierarchicalContentProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.IShareIdManager;
import ch.systemsx.cisd.openbis.dss.generic.shared.ServiceProvider;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatastoreServiceDescription;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IDatasetLocation;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataSetUploadContext;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatasetDescription;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.time.StopWatch;
import org.apache.log4j.Logger;

class DataSetCommandExecutor
implements IDataSetCommandExecutor {
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, DataSetCommandExecutor.class);
    private static final Logger notificationLog = LogFactory.getLogger(LogCategory.NOTIFY, DataSetCommandExecutor.class);
    private final File store;
    private final IExtendedBlockingQueue<IDataSetCommand> commandQueue;
    private IShareIdManager shareIdManager;
    private IHierarchicalContentProvider hierarchicalContentProvider;

    public DataSetCommandExecutor(File store, File queueDir) {
        this.store = store;
        File queueFile = DataSetCommandExecutor.getCommandQueueFile(queueDir);
        this.commandQueue = PersistentExtendedBlockingQueueFactory.createSmartPersist(queueFile);
    }

    void setShareIdManager(IShareIdManager shareIdManager) {
        this.shareIdManager = shareIdManager;
    }

    private static File getCommandQueueFile(File store) {
        return new File(store, "commandQueue");
    }

    @Override
    public void start() {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                String description = "?";
                try {
                    while (true) {
                        StopWatch stopWatch;
                        block11: {
                            IDataSetCommand command = (IDataSetCommand)DataSetCommandExecutor.this.commandQueue.peekWait();
                            description = command.getDescription();
                            if (operationLog.isInfoEnabled()) {
                                operationLog.info("Executing " + description);
                            }
                            stopWatch = new StopWatch();
                            stopWatch.start();
                            try {
                                try {
                                    IShareIdManager manager = DataSetCommandExecutor.this.getShareIdManager();
                                    manager.lock(command.getDataSetCodes());
                                    command.execute(DataSetCommandExecutor.this.getHierarchicalContentProvider(), new DataSetDirectoryProvider(DataSetCommandExecutor.this.store, manager));
                                }
                                catch (RuntimeException e) {
                                    notificationLog.error("Error executing command '" + description + "'.", e);
                                    DataSetCommandExecutor.this.getShareIdManager().releaseLocks();
                                    break block11;
                                }
                            }
                            catch (Throwable throwable) {
                                DataSetCommandExecutor.this.getShareIdManager().releaseLocks();
                                throw throwable;
                            }
                            DataSetCommandExecutor.this.getShareIdManager().releaseLocks();
                        }
                        if (operationLog.isInfoEnabled()) {
                            operationLog.info("Finished executing " + description + " after " + stopWatch);
                        }
                        DataSetCommandExecutor.this.commandQueue.take();
                    }
                }
                catch (InterruptedException interruptedException) {
                }
                catch (InterruptedExceptionUnchecked interruptedExceptionUnchecked) {}
                operationLog.info("Executor stopped");
            }
        }, "Data Set Command Execution");
        thread.setDaemon(true);
        thread.start();
    }

    @Override
    public void scheduleDeletionOfDataSets(List<? extends IDatasetLocation> dataSets, int maxNumberOfRetries, long waitingTimeBetweenRetries) {
        this.scheduleCommand(new DeletionCommand(dataSets, maxNumberOfRetries, waitingTimeBetweenRetries));
    }

    @Override
    public void scheduleUploadingDataSetsToCIFEX(ICIFEXRPCServiceFactory cifexServiceFactory, MailClientParameters mailClientParameters, List<AbstractExternalData> dataSets, DataSetUploadContext uploadContext, String cifexAdminUserOrNull, String cifexAdminPasswordOrNull) {
        this.scheduleCommand(new UploadingCommand(cifexServiceFactory, mailClientParameters, dataSets, uploadContext, cifexAdminUserOrNull, cifexAdminPasswordOrNull));
    }

    @Override
    public void scheduleProcessDatasets(IProcessingPluginTask task, List<DatasetDescription> datasets, Map<String, String> parameterBindings, String userId, String userEmailOrNull, String sessionTokenOrNull, DatastoreServiceDescription serviceDescription, MailClientParameters mailClientParameters) {
        this.scheduleCommand(new ProcessDatasetsCommand(task, datasets, parameterBindings, userId, userEmailOrNull, sessionTokenOrNull, serviceDescription, mailClientParameters));
    }

    private void scheduleCommand(IDataSetCommand command) {
        if (operationLog.isDebugEnabled()) {
            operationLog.debug("Scheduling " + command);
        }
        this.commandQueue.add(command);
    }

    private IShareIdManager getShareIdManager() {
        if (this.shareIdManager == null) {
            this.shareIdManager = ServiceProvider.getShareIdManager();
        }
        return this.shareIdManager;
    }

    private IHierarchicalContentProvider getHierarchicalContentProvider() {
        if (this.hierarchicalContentProvider == null) {
            this.hierarchicalContentProvider = ServiceProvider.getHierarchicalContentProvider();
        }
        return this.hierarchicalContentProvider;
    }

    public static void listQueuedCommands(File store) {
        File queueFile = DataSetCommandExecutor.getCommandQueueFile(store);
        PersistentExtendedBlockingQueueDecorator<IDataSetCommand> commandQueue = PersistentExtendedBlockingQueueFactory.createSmartPersist(queueFile);
        if (commandQueue.isEmpty()) {
            System.out.println("Command queue is empty.");
        } else {
            System.out.println("Found " + commandQueue.size() + " items in command queue:");
            for (IDataSetCommand cmd : commandQueue) {
                try {
                    System.out.println(cmd.getDescription());
                }
                catch (RuntimeException ex) {
                    System.err.printf("Error showing description of command '%s':\n", cmd.getClass().getSimpleName());
                    ex.printStackTrace();
                }
            }
        }
    }
}

