/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server;

import ch.systemsx.cisd.common.exceptions.InvalidAuthenticationException;
import ch.systemsx.cisd.common.resource.IInitializable;
import ch.systemsx.cisd.common.serviceconversation.ServiceMessage;
import ch.systemsx.cisd.openbis.common.spring.IInvocationLoggerContext;
import ch.systemsx.cisd.openbis.generic.shared.IDataStoreService;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.CustomImportFile;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IDatasetLocation;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.LinkModel;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModel;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataSetUploadContext;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatasetDescription;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

class DataStoreServiceLogger
implements IDataStoreService,
IInitializable {
    private static final String RESULT_SUCCESS = "";
    private static final String RESULT_FAILURE = " ...FAILED";
    private final Logger operationLog;
    private final IInvocationLoggerContext loggerContext;

    DataStoreServiceLogger(Logger operationLog, IInvocationLoggerContext context) {
        this.operationLog = operationLog;
        this.loggerContext = context;
    }

    private final void log(String commandName, String parameterDisplayFormat, Object ... parameters) {
        int i = 0;
        while (i < parameters.length) {
            Object parameter = parameters[i];
            parameters[i] = parameter == null ? "<UNDEFINED>" : "'" + parameter + "'";
            ++i;
        }
        String message = String.format(parameterDisplayFormat, parameters);
        String invocationStatusMessage = this.loggerContext.invocationWasSuccessful() ? RESULT_SUCCESS : RESULT_FAILURE;
        this.operationLog.info(String.format("%s  %s%s (%s ms)", commandName, message, invocationStatusMessage, this.loggerContext.getElapsedTime()));
    }

    @Override
    public void initialize() {
        this.log("initialize", RESULT_SUCCESS, new Object[0]);
    }

    @Override
    public int getVersion(String sessionToken) {
        this.log("getVersion", "SESSION(%s)", sessionToken);
        return 0;
    }

    public void send(ServiceMessage message) {
        this.log("send", RESULT_SUCCESS, message);
    }

    @Override
    public List<String> getKnownDataSets(String sessionToken, List<? extends IDatasetLocation> dataSetLocations, boolean ignoreNonExistingLocation) throws InvalidAuthenticationException {
        this.log("getKnownDataSets", "DATA_SETS(%s) IGNORE_NON_EXISTING_LOCATION(%s)", dataSetLocations, ignoreNonExistingLocation);
        return null;
    }

    public void deleteDataSets(String sessionToken, List<? extends IDatasetLocation> dataSets) throws InvalidAuthenticationException {
        this.log("deleteDataSets", "DATA_SETS(%s)", dataSets);
    }

    @Override
    public void uploadDataSetsToCIFEX(String sessionToken, List<AbstractExternalData> dataSets, DataSetUploadContext context) throws InvalidAuthenticationException {
        StringBuilder builder = new StringBuilder();
        for (AbstractExternalData externalDataPE : dataSets) {
            builder.append(' ').append(externalDataPE.getCode());
        }
        this.log("uploadDataSetsToCIFEX", "USER(%s) DATASETS(%s)", context.getUserID(), builder.toString().trim());
    }

    @Override
    public TableModel createReportFromDatasets(String sessionToken, String userSessionToken, String serviceKey, List<DatasetDescription> datasets, String userId, String userEmailOrNull) {
        this.log("createReportFromDatasets", "USER_SESSION(%s) TASK_ID(%s) NO_OF_DATASETS(%s) USER_ID (%s) EMAIL(%s)", userSessionToken, serviceKey, datasets.size(), userId, userEmailOrNull);
        return null;
    }

    @Override
    public void processDatasets(String sessionToken, String userSessionToken, String serviceKey, List<DatasetDescription> datasets, Map<String, String> parameterBindings, String userId, String userEmailOrNull) {
        this.log("processDatasets", "USER_SESSION(%s) TASK_ID(%s) NO_OF_DATASETS(%s) PARAMETERS(%s) USER_ID (%s)  USER_EMAIL(%s)", userSessionToken, serviceKey, datasets.size(), parameterBindings, userId, userEmailOrNull);
    }

    @Override
    public void unarchiveDatasets(String sessionToken, String userSessionToken, List<DatasetDescription> datasets, String userId, String userEmailOrNull) {
        this.log("activateDatasets", "NO_OF_DATASETS(%s) USER_ID (%s) USER_EMAIL(%s)", datasets.size(), userId, userEmailOrNull);
    }

    @Override
    public void archiveDatasets(String sessionToken, String userSessionToken, List<DatasetDescription> datasets, String userId, String userEmailOrNull, boolean removeFromDataStore) {
        this.log("archiveDatasets", "NO_OF_DATASETS(%s) USER_ID (%s) USER_EMAIL(%s) REMOVE_FROM_DATA_STORE(%s)", datasets.size(), userId, userEmailOrNull, removeFromDataStore);
    }

    @Override
    public LinkModel retrieveLinkFromDataSet(String sessionToken, String serviceKey, DatasetDescription dataSet) {
        this.log("retrieveLinkFromDataSet", "TASK_ID(%s) DATA_SET(%s)", serviceKey, dataSet);
        return null;
    }

    @Override
    public TableModel createReportFromAggregationService(String sessionToken, String userSessionToken, String serviceKey, Map<String, Object> parameters, String userId, String userEmailOrNull) {
        this.log("createReportFromAggregationService", "USER_SESSION(%s) SERVICE(%s) PARAMETERS(%s) USER_ID(%s) EMAIL(%s)", userSessionToken, serviceKey, parameters, userId, userEmailOrNull);
        return null;
    }

    @Override
    public String putDataSet(String sessionToken, String dropboxName, CustomImportFile customImportFile) {
        this.log("putDataSet", "DROPBOX_NAME(%s), CUSTOM_IMPORT_FILE(%s)", dropboxName, customImportFile);
        return null;
    }

    @Override
    public void cleanupSession(String userSessionToken) {
        this.log("cleanupSession", "USER_SESSION(%s)", userSessionToken);
    }
}

