/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.plugins.jython;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.jython.MailService;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.jython.api.IEmailSender;
import java.io.IOException;

public class EmailSender
implements IEmailSender {
    private final MailService.IEmailSenderService service;
    private String subject;
    private String bodyText;
    private String attachmentNameOrNull;
    private String attachmentFilePathOrNull;
    private String attachmentTextOrNull;

    public EmailSender(MailService.IEmailSenderService service, String defaultSubject, String defaultBodyText) {
        this.service = service;
        this.subject = defaultSubject;
        this.bodyText = defaultBodyText;
    }

    @Override
    public IEmailSender withSubject(String aSubject) {
        this.subject = aSubject;
        return this;
    }

    @Override
    public IEmailSender withBody(String aBodyText) {
        this.bodyText = aBodyText;
        return this;
    }

    @Override
    public IEmailSender withAttachedFile(String filePath, String attachmentName) {
        if (attachmentName == null) {
            throw new IllegalArgumentException("Unspecified attachment name.");
        }
        if (this.attachmentTextOrNull != null) {
            throw new IllegalStateException("Attachment text was already set.");
        }
        this.attachmentFilePathOrNull = filePath;
        this.attachmentNameOrNull = attachmentName;
        return this;
    }

    @Override
    public IEmailSender withAttachedText(String text, String attachmentName) {
        if (attachmentName == null) {
            throw new IllegalArgumentException("Unspecified attachment name.");
        }
        if (this.attachmentFilePathOrNull != null) {
            throw new IllegalStateException("Attachment file path was already set.");
        }
        this.attachmentTextOrNull = text;
        this.attachmentNameOrNull = attachmentName;
        return this;
    }

    public String toString() {
        return "EmailSender [subject=" + this.subject + ", bodyText=" + this.bodyText + ", attachmentNameOrNull=" + this.attachmentNameOrNull + ", attachmentFilePathOrNull=" + this.attachmentFilePathOrNull + ", attachmentTextOrNull=" + this.attachmentTextOrNull + "]";
    }

    @Override
    public void send() {
        block5: {
            try {
                if (this.attachmentNameOrNull == null) {
                    this.service.trySendEmail(this.subject, this.bodyText);
                    break block5;
                }
                if (this.attachmentFilePathOrNull != null) {
                    this.service.trySendEmailWithFileAttachment(this.subject, this.bodyText, this.attachmentNameOrNull, this.attachmentFilePathOrNull);
                    break block5;
                }
                if (this.attachmentTextOrNull != null) {
                    this.service.trySendEmailWithTextAttachment(this.subject, this.bodyText, this.attachmentNameOrNull, this.attachmentTextOrNull);
                    break block5;
                }
                throw new IllegalStateException("Neither file path nor text of attachment was specified");
            }
            catch (IOException ex) {
                throw CheckedExceptionTunnel.wrapIfNecessary(ex);
            }
        }
    }
}

